##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################


import pooler
import tools

_uid_cache = {}

def login(db, login, password):
	cr = pooler.get_db(db).cursor()
	cr.execute('select id from res_users where login=%s and password=%s and active', (login, password))
	res = cr.fetchone()
	cr.close()
	if res:
		return res[0]
	else:
		raise _('Bad username or password')

def check_super(passwd):
	if passwd == tools.config['admin_passwd']:
		return True
	else:
		raise 'AccessDenied'
	
def check(db, uid, passwd):
	#FIXME: this should be db dependent
	if _uid_cache.has_key(uid) and (_uid_cache[uid]==passwd):
		return True
	cr = pooler.get_db(db).cursor()
	cr.execute('select count(*) from res_users where id=%d and password=%s', (int(uid), passwd))
	res = cr.fetchone()[0]
	cr.close()
	if not bool(res):
		raise 'AccessDenied'
	if res:
		_uid_cache[uid] = passwd
	return bool(res)

def access(db, uid, passwd, sec_level, ids):
	cr = pooler.get_db(db).cursor()
	cr.execute('select id from res_users where id=%s and password=%s', (uid, passwd))
	res = cr.fetchone()
	cr.close()
	if not res:
		raise _('Bad username or password')
	return res[0]
