AC_DEFUN(
  MY_ARG_DATADIR,
  [AC_ARG_WITH(
     [$1],
     AS_HELP_STRING(
       [--with-$1=DIR],
       [define $2 @<:@DATADIR/$3@:>@]
     ),
     [$1=$withval],
     [$1=\$\{datadir\}/$3]
   )
  ]
)

AC_DEFUN(
  MY_CHECK_WXCONFIG,
  [AC_CHECK_PROGS(WXCONFIG,wx-config)
     if [[ ! "${WXCONFIG}" ]]; then \
       AC_MSG_ERROR(wx-config not found) \
     fi
  ]
)

AC_DEFUN(
  MY_VERSION_WXWINDOWS,
  [AC_REQUIRE([MY_CHECK_WXCONFIG])
   AC_MSG_CHECKING(for version of installed wxwindows)
   wxversion=`${WXCONFIG} --version`
   AC_MSG_RESULT(${wxversion})
   test "$wxversion" \< "$1" && \
     AC_MSG_ERROR(You need wxwindows version $1 or later.)
  ]
)
