/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTEST_H
#define CONTEST_H

#include "LessonController.H"
#include "lektion.h"
#include "dirs.H"
#include <wx/wx.h>
#include <wx/filename.h>

class ContestDesc {
public:
  ContestDesc (int weight = 70)
    : id(-1), weight(weight) {};

  long id;
  wxString title; //the wizard title
  UrlFile pictureFile; //wizard picture file
  UrlFile descrFile; //wizard description page text
  UrlFile lessonFile; //lesson text
  wxFileName dataFile; //where the lesson results data is stored
  int weight; //weight between speed (0.0 = max) or correctness (100.0 = max)
};

class Contest : public LessonController {
public:
  Contest (wxWindow* parent, ContestDesc& cdata);
  ~Contest ();

private:
  wxWindow* parent;
  wxString username;
  ContestDesc data;
  void onLessonStart(wxCommandEvent& WXUNUSED(e));
  void onLessonAbort(wxCommandEvent& WXUNUSED(e));
  void onLessonFinish(wxCommandEvent& WXUNUSED(e));

  DECLARE_EVENT_TABLE()
};

#endif
