/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "kurs.h"
#include "main.h"
#include "kurslaus.h"
#include "lektionsanweisung.h"
#include "ConfigFile.H"
#include "KursBeginWizard.H"
#include "ClassSelectDlg.H"
#include <wx/defs.h>
#include <wx/wizard.h>
#include <wx/ffile.h>
#include <wx/notebook.h>
#include <wx/wfstream.h>
#include <wx/txtstrm.h>

using namespace std;

BEGIN_EVENT_TABLE(Kurs,LessonController)
  LESSON_START(wxID_ANY, Kurs::onLessonStart)
  LESSON_ABORT(wxID_ANY, Kurs::onLessonAbort)
  LESSON_FINISH(wxID_ANY, Kurs::onLessonFinish)
END_EVENT_TABLE()

Kurs::Kurs (wxWindow* parent)
  : parent(parent)
{
  controllerName=_("class");
  lesson=0;
  if (!Hauptfenster::getPtr()->setLessonController(this)) {
    throw Abbruch();
  }
  ClassSelectDlg* kd = new ClassSelectDlg(this->parent);
  switch (kd->ShowModal()) {
  case SEL_B:
    if (kd->GetSelection() != 0) {
      this->name = kd->GetSelection()->name;
      this->key = kd->GetSelection()->key;
    } else {
      throw DialogAborted();
    }
    if (!KursLaden()) {
      throw DialogAborted();
    }
    break;
  case NEW_B:
    if (!KursBeginnen()) {
      throw DialogAborted();
    }
    break;
  case wxID_CANCEL:
    throw DialogAborted();
    break;
  }
  delete kd;
}

Kurs::~Kurs () {
  if (runningLesson()) {
    lesson->LektionAbbrechen();
    delete lesson;
  }
}

#include "commonElements.H"
#include <wx/tokenzr.h>

bool Kurs::ladeKursKriterien () {
  bool retval = true;
  LessonPath f;
  f.appendDir(TtConfigFile::getPtr()->getKeyboardLayout());
  f.setFileName(_T("kurs"));
  wxString filename;
  filename << this->kn;
  f.setFileExt(filename);

  wxURL* u = f.getURL();
  wxInputStream* input = common::getInputStream(*u);
  if (input==0) {
    ::wxLogError(_("Cannot load file %s"), f.getFullFileName().c_str());
    retval=false;
  } else {
    wxArrayString ar = common::getIndexFile(*input);
    wxStringTokenizer t;
    long num,time,mil;
    for (unsigned int i=0; i<ar.GetCount(); ++i) {
      t.SetString(ar[i],wxString(_T(":")),wxTOKEN_RET_EMPTY_ALL);
      num=0;
      t.GetNextToken().ToLong(&num);
      time=0;
      t.GetNextToken().ToLong(&time);
      mil=0;
      t.GetNextToken().ToLong(&mil);
      this->kriterien.push_back(LKrit(num, time, mil));
    }
  }
  delete input;
  delete u;
  return retval;
}


bool Kurs::KursBeginnen () {
  //Wizard aufrufen
  KursBeginWizard* wizard = new KursBeginWizard(this->parent);
  if (!wizard->runWizard()) {
    wizard->Destroy();
    return false;
  }
  this->kn = wizard->getKursNummer();
  this->name = wizard->getName();
  wizard->Destroy();
  //Wizard beendet

  srand(::wxGetUTCTime() + ::wxGetProcessId());
  this->key = _T("");
  this->key << rand();
  TtConfigFile::getPtr()->storeKursNummer(this->name, this->key, this->kn);

  if (!this->ladeKursKriterien()) {
    return false;
  }
  results = new std::vector<LEntry>();

  //Info Fenster zum Kurs wird angezeigt
  this->akt_krit = 0;
  KursEinleitung();
  LKrit t = this->kriterien[akt_krit];
  lesson = 0;
  lesson = new Lektion(t.getNummer(), this);
  return true;
}

bool Kurs::KursLaden () {
  this->kn=TtConfigFile::getPtr()->getKursNummer(this->name, this->key);
  results = TtConfigFile::getPtr()->loadKursDaten(name,key);
  this->akt_krit=results->size();
  if (!this->ladeKursKriterien()) {
    return false;
  }

  // Die Lektion, die nun dran ist laden.
  if (this->akt_krit <  this->kriterien.size()) {
    LKrit t = this->kriterien[this->akt_krit];
    lesson = 0;
    lesson = new Lektion(t.getNummer(), this);
  } else {
    KursEnde();
    return false;
  }
  return true;
}

void Kurs::NaechsteLektion (const LEntry& ldata) {
  kurslaus k(this->parent, ldata, this->kriterien[this->akt_krit]);
  switch (k.ShowModal()) {
  case NEXT_B:
    if (this->akt_krit >= this->kriterien.size()) {
      //class ends here
      KursEnde();
      ((Hauptfenster*)this->parent)->setLessonController(0);;
      break;
    } else {
      //next lesson
      LektionSpeichern(ldata);
      ++this->akt_krit;
    }
    //no break
  case PREV_B:
    delete lesson;
    lesson = 0;
    try {
      lesson = new Lektion(this->kriterien[this->akt_krit].getNummer(),
			   this);
    }
    catch (Lektion::LessonLoadedFailed) {
      ((Hauptfenster*)this->parent)->setLessonController(0);
    }
    break;
  default:
    ((Hauptfenster*)this->parent)->setLessonController(0);;
    break;
  }
}

bool Kurs::KursEinleitung () {
  LessonPath f;
  f.appendDir(TtConfigFile::getPtr()->getKeyboardLayout());
  f.setFileName(_T("kurs"));
  wxString filename(_T("a"));
  filename << this->kn;
  f.setFileExt(filename);

  wxURL* u = f.getURL();
  wxInputStream* input = common::getInputStream(*u);
  if (input==0) {
    ::wxLogError(_("Cannot load file %s"), f.getFullFileName().c_str());
  } else {
    wxString s = common::readTextAll (*input);
    wxMessageBox(s , _("Class intro"));
  }    
  delete input;
  delete u;
  return true;
}

bool Kurs::KursEnde () {
  LessonPath f;
  f.appendDir(TtConfigFile::getPtr()->getKeyboardLayout());
  f.setFileName(_T("kurs"));
  wxString filename(_T("e"));
  filename << this->kn;
  f.setFileExt(filename);

  wxURL* u = f.getURL();
  wxInputStream* input = common::getInputStream(*u);
  if (input == 0) {
    ::wxLogError(_("Cannot load file %s"), f.getFullFileName().c_str());
  } else {
    wxString s = common::readTextAll(*input);
    wxMessageBox(s, _("End of class"));
  }    
  delete input;
  delete u;
  return true;
}

wxString Kurs::GetLimits () {
  wxString s;
  wxString temp;
  temp.Printf(_("The maximum of allowed mistakes for this lesson (per mil) is %d.\n"),
	      this->kriterien[this->akt_krit].getPromille());
  s << temp;
  if (this->kriterien[this->akt_krit].getZeit() != 0) {
    temp.Printf(_("The time is limited to %s\n."),
		(this->kriterien[this->akt_krit].getZeitString()).c_str());
    s << temp;
  }
  s << _("Good luck!");
  return s;
}

bool Kurs::LektionSpeichern (const LEntry& ldata) {;
  this->results->push_back(ldata);
  TtConfigFile::getPtr()->storeKursDaten(this->name, this->key, *this->results);
  return true;
}

void Kurs::onLessonStart (wxCommandEvent& WXUNUSED(e)) {
  LKrit t = this->kriterien[akt_krit];
  wxString s;
  s << _("Lesson ") << t.getNummer();
  wxString k;
  k << GetLimits();
  LessonStartDlg la(Hauptfenster::getPtr(),
		    t.getNummer(),
		    k, -1, s/*,
		    wxDefaultPosition,
		    wxSize(500, 300)*/);
  la.Centre();
  la.ShowModal();
}

void Kurs::onLessonAbort (wxCommandEvent& WXUNUSED(e)) {
  delete lesson;
  lesson = 0;
}

void Kurs::onLessonFinish (wxCommandEvent& WXUNUSED(e)) {
  LEntry ldata(lesson->GetLessonData());
  NaechsteLektion(ldata);
}
