/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "main.h"
#include "info.h"
#include "ConfigFile.H"
#include "optionen.h"
#include "auswahl.h"
#include <wx/fontdlg.h>
#include <wx/font.h>
#include <wx/image.h>
#include <wx/tooltip.h>

#ifndef __VISUALC__
#  include "../config.h"
#endif

#ifndef __WXMSW__
#  include "logo.xpm"
#endif

BEGIN_EVENT_TABLE(Hauptfenster, wxFrame)
  EVT_MENU(D_LektionLaden, Hauptfenster::OnLektionLaden)
  EVT_MENU(D_LPause, Hauptfenster::OnD_LektionPause)
  EVT_MENU(D_LektionBeenden, Hauptfenster::OnD_LBeenden)
  EVT_MENU(D_KLaden, Hauptfenster::OnD_KursLaden)
  EVT_MENU(D_Beenden, Hauptfenster::OnD_Beenden)
  EVT_MENU(C_RunContest, Hauptfenster::OnC_RunContest)
  EVT_MENU(C_ShowRanking, Hauptfenster::OnC_ShowRanking)
  EVT_MENU(C_EditContest, Hauptfenster::OnC_EditContest)
  EVT_MENU(O_SwitchBell, Hauptfenster::OnO_SwitchBell)
  EVT_MENU(O_Schriftwaehlen, Hauptfenster::OnO_Schriftwaehlen)
  EVT_MENU(O_Einstellungen, Hauptfenster::OnO_Einstellungen)
  EVT_MENU(Hilfe_Info,  Hauptfenster::OnHilfe_Info)
  EVT_SIZE(Hauptfenster::OnSize)
END_EVENT_TABLE()

IMPLEMENT_APP(tipptrainer)

int current_lang = 0;

void tipptrainer::localize () {
  //i18n
  //get setting from system
  int syslang = wxLocale::GetSystemLanguage();
  //get setting from configuration file
  wxString lang = TtConfigFile::getPtr()->getLanguage();

  bool translation_warning = false;
  int i = 0;
  if (lang == _T("")) {
    /* set the programs locale according to the systems locale
     * but only if listed as supported
     */
    while (supported_langs[i].name != _T("")) {
      if (syslang >= supported_langs[i].locale_min &&
	  syslang <= supported_langs[i].locale_max) {
	if (i > 0) {
	  translation_warning = true;
	}
	{
	  wxLogNull l;
	  m_locale.Init(wxLANGUAGE_DEFAULT,wxLOCALE_CONV_ENCODING);
	}
	break;
      }
      ++i;
    }
  } else {
    /* set the programs locale to the forced value
     */
    int lindex_min = syslang;
    int lindex_max = syslang;
    while (supported_langs[i].name != _T("")) {
      if (supported_langs[i].name == lang) {
	lindex_min = supported_langs[i].locale_min;
	lindex_max = supported_langs[i].locale_max;
	break;
      }
      ++i;
    }
    if (lindex_min <= syslang && syslang <= lindex_max) {
      //current system locale matches wanted one
      {
	wxLogNull l;
	m_locale.Init(wxLANGUAGE_DEFAULT,wxLOCALE_CONV_ENCODING);
      }
    } else if (i > 0) {
      //language is not english (compiled-in lang)
      translation_warning = true;
      //find the right locale to load
      for (int k=lindex_min;k<=lindex_max;++k) {
	if (!m_locale.IsOk()) {
	  {
	    wxLogNull l;
	    m_locale.Init(k,wxLOCALE_CONV_ENCODING);
	  }
	}
      }
    }
  }
  if (supported_langs[i].name != _T("")) {
    current_lang = i;
  }

  if (!m_locale.IsOk()) {
    if (translation_warning) {
      ::wxLogError(wxString(_T("The translation file loader needs an installed locale.")));
    }
  } else {
    /* Loading gettext (.mo) files does only work when a locale was loaded.
     * Overriding compiled in texts is even enabled for english texts
     * but warnings are only issued for foreign languages.
     */
    LangDir l;
    m_locale.AddCatalogLookupPathPrefix(l.GetFullPath());
    if (!m_locale.AddCatalog(_T("wxstd")) && translation_warning) {
      ::wxLogError(wxString(_T("Could not load wxWindows translation file.")));
    }
    if (!m_locale.AddCatalog(_T("tipptrainer")) && translation_warning) {
      ::wxLogError(wxString(_T("Could not load Tipptrainer translation file.")));
    }
  }
}

bool tipptrainer::OnInit () {
  SetVendorName(_T("Pingos"));
  SetAppName(_T("Tipptrainer"));

  ::wxInitAllImageHandlers();
  unsigned int seconds = TtConfigFile::getPtr()->getToolTipDelay();
  wxToolTip::Enable(true);
  wxToolTip::SetDelay(seconds*1000);

  localize();

  Hauptfenster *h = new Hauptfenster(); 
  SetTopWindow(h);
  h->Show(TRUE);
  return TRUE;
};

int tipptrainer::OnExit () {
  delete TtConfigFile::getPtr();
  return 0;
}

Hauptfenster* Hauptfenster::localpointer = 0;

Hauptfenster::Hauptfenster ()
  : wxFrame((wxFrame *) NULL, -1, _T("PingoS Tipptrainer")),
    lcontrol(0)
{
  this->localpointer = this;
  SetIcon(wxICON(logo));
  SetTitle(_T("PingoS Tipptrainer ")+wxString::FromAscii(PACKAGE_VERSION));

  SetSize(TtConfigFile::getPtr()->getMainWindowSize());
  Move(TtConfigFile::getPtr()->getMainWindowPosition());

  // ****************************************** 
  // *Menus erzeugen
  // ******************************************
  MainMenu = new wxMenuBar;

  FileMenu = new wxMenu;
  FileMenu->Append(D_LPause, _("&Pause"),
		    _("Pauses the current lesson"));
  FileMenu->Append(D_LektionBeenden, _("&Abort"),
		    _("Cancels the current lesson|class|contest"));
  FileMenu->AppendSeparator();
  FileMenu->Append(D_Beenden, _("E&xit"), /* never to be disabled */
		    _("Terminates the tipptrainer"));
  //default is an enabled menu item but not all should be
  FileMenu->Enable(D_LektionBeenden, FALSE);
  FileMenu->Enable(D_LPause, FALSE);

  bool hasContests = TtConfigFile::getPtr()->contestsExist();

  ModesMenu = new wxMenu;
  ModesMenu->Append(D_LektionLaden, _("&Lesson..."), /* never to be disabled */
		    _("Shows the lesson selection dialog"));
  ModesMenu->Append(D_KLaden, _("&Class..."), /* never to be disabled */
		    _("Show the class selection dialog"));
  ModesMenu->Append(C_RunContest,_("&Do the contest..."),
		      _("Runs the contest start wizard"));
  ModesMenu->Enable(C_RunContest,hasContests);

  ViewMenu = new wxMenu;
  ViewMenu->Append(C_ShowRanking,_("Contest &Ranking..."),
		      _("Displays the ranking for the current contest"));
  ViewMenu->Enable(C_ShowRanking,hasContests);

  OptionsMenu = new wxMenu;
  OptionsMenu->AppendCheckItem(O_SwitchBell,_("&Beep on error"),/* never to be disabled */
				_("Beep on type errors on/off"));
  OptionsMenu->Append(O_Schriftwaehlen, _("Select &font..."), /* never to be disabled */
		       _("Show the font selection dialog"));
  OptionsMenu->Append(C_EditContest,_("Contest &editor..."),
		      _("Select/add/remove/edit contests"));
  OptionsMenu->Append(O_Einstellungen, _("&Configure Tipptrainer..."), /* never to be disabled */
		       _("Shows the configuration dialog"));
  //setting defaults for some menu items
  OptionsMenu->Check(O_SwitchBell,TtConfigFile::getPtr()->getBellStatus());


  HelpMenu = new wxMenu;
  HelpMenu->Append(Hilfe_Info, _("A&bout..."),  /* never to be disabled */
		    _("Show information about the Tipptrainer team"));
  
  MainMenu->Append(FileMenu, _("&File"));
  MainMenu->Append(ModesMenu, _("&Modes"));
  MainMenu->Append(ViewMenu, _("&View"));
  MainMenu->Append(OptionsMenu, _("&Settings"));
  MainMenu->Append(HelpMenu, _("&Help"));
  
  // Menubar dem Hauptfenster zuweisen
  SetMenuBar(MainMenu);

  // Statusbar erzeugen
  CreateStatusBar(1);
  SetStatusText(_("Welcome to PingoS Tipptrainer"),0);

  // SplitterWindow erzeugen
  sw = new wxSplitterWindow(this, 1);
  sw->SplitHorizontally(new TtOutputControl(sw),
			new TtInputControl(sw),
			TtConfigFile::getPtr()->getSashPosition(this->GetClientSize().y/2));
  Show(true);

  //show startup selection dialog
  Auswahldialog ad(this, -1,_T("PingoS Tipptrainer"));
  ad.Centre();
  wxCommandEvent* e = 0;
  switch (ad.ShowModal()) {
  case KL:
    e = new wxCommandEvent(wxEVT_COMMAND_MENU_SELECTED,
			   D_KLaden);
    break;
  case LL:
    e = new wxCommandEvent(wxEVT_COMMAND_MENU_SELECTED,
			   D_LektionLaden);
    break;
  case CS:
    e = new wxCommandEvent(wxEVT_COMMAND_MENU_SELECTED,
			   C_RunContest);
    break;
  default:
    break;
  };
  if (e != 0) {
    ProcessEvent(*e);
  }
}

Hauptfenster::~Hauptfenster () {
  TtConfigFile::getPtr()->setMainWindowSize(GetSize());
  TtConfigFile::getPtr()->setMainWindowPosition(GetPosition());
  TtConfigFile::getPtr()->setSashPosition(sw->GetSashPosition());
}

void Hauptfenster::OnHilfe_Info (wxCommandEvent& event) {
  Info_Dialog id(this);
  id.Centre();
  id.ShowModal();
}

void Hauptfenster::OnD_Beenden (wxCommandEvent& event) {
  Close();
}

void Hauptfenster::OnD_LBeenden (wxCommandEvent& event) {
  setLessonController(0);
}

void Hauptfenster::OnD_LektionPause (wxCommandEvent& event) {
  this->lcontrol->getLesson()->Pause();
}

void Hauptfenster::OnSize (wxSizeEvent& event) {
  event.Skip();
}

void Hauptfenster::OnO_Einstellungen (wxCommandEvent& event) {
  ODialog od(this);
  od.Center();
  od.ShowModal();
}

bool Hauptfenster::setLessonController(LessonController* c, bool deleteOld) {
  if (this->lcontrol != 0 && deleteOld) {
    int answer = wxYES;
    if (this->lcontrol->runningLesson()) {
      wxString s;
      s.Printf(_("Abort current %s?"),this->lcontrol->getType().c_str());
      answer = wxMessageBox(s,_("Abort request"),wxYES_NO,this);
    }
    if (answer==wxYES) {
      delete this->lcontrol;
    } else {
      return false;
    }
  }
  this->lcontrol=c;
  FileMenu->Enable(D_LektionBeenden, (this->lcontrol != 0));
  return true;
}

void Hauptfenster::OnO_Schriftwaehlen (wxCommandEvent& event) {
  wxFont oldFont = TtConfigFile::getPtr()->getMainWindowFont();
  //we could do our own wxFontDialog but why?
  //somehow, the initial font stuff does not work :-(
  wxFont chosenFont = ::wxGetFontFromUser(this, oldFont);

  if (chosenFont.Ok()) {
    this->GetInput()->setFont(chosenFont);
    this->GetOutput()->setFont(chosenFont);
    TtConfigFile::getPtr()->setMainWindowFont(chosenFont);
  }
}

void Hauptfenster::OnO_SwitchBell (wxCommandEvent& WXUNUSED(event)) {
  TtConfigFile::getPtr()->toggleBellStatus();
}

#include "SingleLesson.H"
void Hauptfenster::OnLektionLaden (wxCommandEvent& event) {
  try {
    new SingleLesson(this);
  }
  catch (LessonController::Abbruch) {
    setLessonController(0,false);
  }
  catch (Lektion::LessonLoadedFailed) {
    setLessonController(0,false);
  }
}

#include "kurs.h"
void Hauptfenster::OnD_KursLaden (wxCommandEvent& event) {
  try {
    new Kurs(this);
  }
  catch (LessonController::Abbruch) {
  }
  catch (Kurs::DialogAborted) {
    setLessonController(0,false);
  }
  catch (Lektion::LessonLoadedFailed) {
    setLessonController(0,false);
  }
}

#include "Contest.H"
void Hauptfenster::OnC_RunContest(wxCommandEvent& event){
  ContestDesc c = TtConfigFile::getPtr()->getContest(TtConfigFile::getPtr()->getSelectedContestId());
  try {
    new Contest(this,c);
  }
  catch(LessonController::Abbruch) {
  }
  catch (Lektion::LessonLoadedFailed) {
    setLessonController(0,false);
  }
}

#include "ContestRankingDlg.H"
void Hauptfenster::OnC_ShowRanking(wxCommandEvent& WXUNUSED(event)){
  ContestDesc c = TtConfigFile::getPtr()->getContest(TtConfigFile::getPtr()->getSelectedContestId());
  ContestRankingDlg ranking(this,c.title,c.dataFile,c.weight);
  ranking.ShowModal();
}

#include "ContestSelectDlg.H"
void Hauptfenster::OnC_EditContest(wxCommandEvent& WXUNUSED(event)){
  ContestSelectDlg* dialog = new ContestSelectDlg(this);
  dialog->ShowModal();
  bool hasContests = TtConfigFile::getPtr()->contestsExist();
  ModesMenu->Enable(C_RunContest,hasContests);
  ViewMenu->Enable(C_ShowRanking,hasContests);
}
