#proc getpasswd { host share} {
#   global SH_PASS_${host}_${share} H_PASS_${host}
#   set id pass_${host}_${share}
#   toplevel .$id
#   global ${id}_pass
#   
#   entry .${id}.e -textvariable ${id}_pass
#   button .${id}.o -text Ok -command "destroy .${id}"
#   button .${id}.c -text Cancel -command "set ${id}_pass {}
#   destroy .{id}"
#   pack .${id}.e -side top -fill x
#   pack .${id}.o -side left -fill x
#   pack .${id}.c -side left -fill x
#   tkwait window .$id
#   return ${id}_pass
#}

proc makepasswd { host share flag } {
#flag - 0 - 
#       1 - save PASSWORD in H_PASS        
#       2 - save PASSWORD in SH_PASS

   global SH_PASS_${host}_${share} H_PASS_${host} PASSWORD keeppw
   set pass ""
   if { [ def H_PASS_${host} ] } { set pass [set H_PASS_${host}] }
   if { [ def SH_PASS_${host}_${share} ] } { set pass [set SH_PASS_${host}_${share}] }
   if { $PASSWORD != "" && $flag != 0 } { 
	   set pass $PASSWORD 
           if { $keeppw != "yes" } { set PASSWORD {} }
           }
   
   if { $flag == 2 } { set SH_PASS_${host}_${share} $pass }
   if { $flag == 1 } { set H_PASS_${host} $pass }
   return $pass 
}




proc viewhost { name group goto} {
	# File pattens.tcl
	global patten_share patten_hosts patten_hosts2 patten_groups patten_groups2 patten2 patten2a patten3 patten_info1 patten_info2

	# GlobalVars
	global font USERNAME PASSWORD timeout C_HOST C_GROUP H_PASS_${name}
	global H_${name}_IP H_${name}_Browse

	set addr [nmblookup $name]
	#.trt4 configure -text $name
	#.trt6 configure -text $group

	#set H_${name}_IP $addr
	defifndef H_${name}_Browse no
	if { [set H_${name}_Browse] == "now" } { return {} }
	set H_${name}_Browse now
	set passflag "0"

	set get_group {}
	set get_comment ""

	if { $addr == "" } {
		spawn -nottyinit smbclient -L $name -U $USERNAME -W $group 
		} else {
		spawn -nottyinit smbclient -L $name -U $USERNAME -W $group -I $addr
		}
	set id $spawn_id
	set fail 1

	expect {
		-i $id Password: {
			if { $passflag == "0" } {
			   	set pass [makepasswd $name "" 1]
	  			exp_send "$pass\r"
				} {
	  			exp_send "none\r"
				}
			set passflag 1
			exp_continue
			}
		-i $id -indices -re $patten_info1 { 
			set get_domain  $expect_out(1,string)
			set get_group   $expect_out(1,string)
			set get_os      $expect_out(2,string)
			set get_comment $expect_out(3,string)
			set fail 0
			put "Get Info1......."
			addhost $name $get_comment $get_domain
			exp_continue
			}
		-i $id -indices -re $patten_info2  {
			set get_server  $expect_out(1,string)
			set get_user    $expect_out(2,string)
			set get_group   $expect_out(3,string)
			set get_domain  $expect_out(4,string)
			set fail 0
			put "Get Info2......"
			exp_continue
			}
		-i $id timeout {close -i $id;puts "Timeout $timeout sec.........."}
		-i $id -indices -re $patten_share {
			put {Share Part...........}
			set res {put "Unexpected end of input while reading shares........."}
			expect {
	    			-i $id -indices -re $patten3 {
					put "<<$expect_out(1,string)<:$expect_out(3,string):>$expect_out(4,string)>>"
					if { $expect_out(3,string)=="Disk"} {
						addshare $name $expect_out(1,string) $expect_out(4,string)
						}
					if { $expect_out(1,string)=="" } {
						set res "exp_continue"
						} else {
						exp_continue
						}
					}
	    
	    			}
			set fail 0
			eval $res
			}
		-i $id $patten_hosts2 { exp_continue}
		-i $id -indices -re $patten_hosts {
			set res {put "Unexpected end of Input while reading hosts........."} 
			expect {
	   			-i $id -indices -re $patten2 {
					put "!$expect_out(1,string)!$expect_out(3,string)!"
					addhost $expect_out(1,string) $expect_out(3,string) $group
					if { $expect_out(1,string)=="" } {
						set res exp_continue
						} else {
						exp_continue
						}
					}
	   			}
			set fail 0
			eval $res	
			}
		-i $id $patten_groups2 { exp_continue}
   		-i $id -indices -re $patten_groups {
			expect {
	   			-i $id "\r\n\r\n"   {
					put "Internal Error in VIEWHOST.......... Possible unsupported 'smbclient'"
					}
				-i $id -indices -re $patten2a {
					addgroup $expect_out(1,string) $expect_out(3,string)
					put "?$expect_out(1,string)?$expect_out(3,string)?"
                			exp_continue
					}
	   			}
			set fail 0
			}
		}
	#close -i $id
	wait  -i $id
	global H_${name}_Browse
	set H_${name}_Browse host
	if { $group == $get_group } { set H_${name}_Browse group }
	if { $fail == "1" } {
		if { $name == $C_HOST && [set H_${name}_Browse] != "failed" } {
			.shares configure -state normal
			.shares insert end "<FAILED>"
			.shares configure -state disabled
			}
		set H_${name}_Browse failed
		}
	global C_SHARE
	set C_SHARE {}
	puts "Terminated.. <$name>"
	global GR_${get_group}_Master
	defifndef GR_${get_group}_Master {}
	if { $goto == 1 && $get_group != "" && [set GR_${get_group}_Master] != "" } {
		new_group_request $get_group 0
		new_host_request $name 0
  		}
	}
