/*
** iksemel (XML Parser for Jabber)
** Copyright (C) 2000-2001 Gurer Ozen <palpa@jabber.org>
** Copyright (C) 2002 Evan Prodromou <mr.bad@pigdog.org>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of GNU Lesser General Public License.
**
** jabber ID utilities
*/

#include "common.h"
#include "iksemel.h"

/* guess as to default size of parts of the ID. */

#define USER_SIZE 16
#define SERVER_SIZE 24
#define RESOURCE_SIZE 8

/* enough room for 3 parts, a full, and a partial. */

#define IKS_ID_DEFAULT_POOL_SIZE (sizeof(iksid) + \
                                  USER_SIZE + \
                                  SERVER_SIZE + \
                                  RESOURCE_SIZE + \
                                  (USER_SIZE + 1 + SERVER_SIZE + 1 + RESOURCE_SIZE) + \
                                  (USER_SIZE + 1 + SERVER_SIZE))

/*****  jabber id  *****/

iksid *iks_id_new(ikspool *parg, const char *src)
{
	char *tmp;
	iksid *id;
        ikspool * p;
        int n;

	if(!src) return(NULL);

        p = (parg) ? parg : iks_pool_new(IKS_ID_DEFAULT_POOL_SIZE);

	if(!p) return(NULL);

	id = iks_pool_alloc(p, sizeof(iksid));
	if(!id) return(NULL);
	memset(id, 0, sizeof(iksid));
	id->p = p;

        if (p != parg)
          iks_pool_set_owner(p, id);

	tmp = strchr(src, ':');
	if(tmp) src = ++tmp;

	tmp = strchr(src, '@');
	if(tmp)
	{
                n = tmp - src;
		id->user = iks_pool_alloc(p, n + 1);
                strncpy(id->user, src, n);
                id->user[n] = '\0';
		src = tmp + 1;
	}

	tmp = strchr(src, '/');
	if(tmp)
	{
                n = tmp - src;
                id->server = iks_pool_alloc(p, n + 1);
                strncpy(id->server, src, n);
                id->server[n] = '\0';
		id->resource = iks_pool_strdup(p, tmp + 1);
	}
        else
        {
		id->server = iks_pool_strdup(p, src);
        }

	/* FIX ME: implement jid checks here */

	return id;
}

void iks_id_delete(iksid *id)
{
        if (!id) return;
        if (!id->p) return;
        
        if (iks_pool_owner(id->p) == id)
          {
            iks_pool_delete(id->p);
          }
        else
          {
            if (id->user) iks_pool_free(id->p, id->user);
            if (id->server) iks_pool_free(id->p, id->server);
            if (id->resource) iks_pool_free(id->p, id->resource);
            if (id->full) iks_pool_free(id->p, id->full);
            if (id->partial) iks_pool_free(id->p, id->partial);

            iks_pool_free(id->p, id);
          }
}

void iks_id_set(iksid *id, const char *src, int item)
{
        int n;
        char **field;

	id->full = NULL;

        switch(item)
          {
          case IKS_ID_USER:
            id->partial = NULL;
            field = &id->user;
            break;
            
          case IKS_ID_SERVER:
            id->partial = NULL;
            field = &id->server;
            break;

          case IKS_ID_RESOURCE:
            field = &id->resource;
            break;

            /* FIXME: IKS_ID_USER | IKS_ID_SERVER */
            /* FIXME: IKS_ID_USER | IKS_ID_SERVER | IKS_ID_RESOURCE */

          default:
            return;
          }

        if (!src)
          {
            iks_pool_free(id->p, *field);
            *field = NULL;
          }
        else
          {
            n = strlen(src);
            if (*field)
              {
                *field = iks_pool_realloc(id->p, *field, n + 1);
                strcpy(*field, src);
              }
            else
              {
                *field = iks_pool_strdup(id->p, src);
              }
          }
}


int iks_id_cmp(iksid *a, iksid *b)
{
	return iks_id_cmpx(a, b, IKS_ID_RESOURCE | IKS_ID_USER | IKS_ID_SERVER);
}


int iks_id_cmpx(iksid *a, iksid *b, int parts)
{
	int diff = 0;

	if(!a || !b) return(IKS_ID_RESOURCE | IKS_ID_USER | IKS_ID_SERVER);

	if(parts & IKS_ID_RESOURCE && !(!a->resource && !b->resource) && iks_strcmp(a->resource, b->resource) != 0)
		diff += IKS_ID_RESOURCE;

	if(parts & IKS_ID_USER && !(!a->user && !b->user) && iks_strcasecmp(a->user, b->user) != 0)
		diff += IKS_ID_USER;

	if(parts & IKS_ID_SERVER && !(!a->server && !b->server) && iks_strcmp(a->server, b->server) != 0)
		diff += IKS_ID_SERVER;

	return diff;
}


char *iks_id_print(iksid *id)
{
	ikstr *s;

	if(!id) return(NULL);

	if(id->full) return(id->full);

	s = iks_str_new(id->p);
	if(!s) return(NULL);

	if(id->user)
	{
		iks_str_add(s, id->user);
		iks_str_add(s, "@");
	}
	iks_str_add(s, id->server);
	if(id->resource)
	{
		iks_str_add(s, "/");
		iks_str_add(s, id->resource);
	}

	id->full = iks_str_print(s);
	return id->full;
}


char *iks_id_printx(iksid *id, int parts)
{
	switch(parts)
	{
	case IKS_ID_USER | IKS_ID_SERVER:
	{
		ikstr *s;
		if(id->partial) return(id->partial);
		s = iks_str_new(id->p);
		if(!s) return(NULL);
		if(id->user)
		{
			iks_str_add(s, id->user);
			iks_str_add(s, "@");
		}
		iks_str_add(s, id->server);
		id->partial = iks_str_print(s);
		return id->partial;
	}

	case IKS_ID_USER:
		return id->user;

	case IKS_ID_SERVER:
		return id->server;

	case IKS_ID_RESOURCE:
		return id->resource;

	case IKS_ID_USER | IKS_ID_SERVER | IKS_ID_RESOURCE:
		return iks_id_print(id);
	}

	return NULL;
}
