/*
** Jabby (a C library for Jabber protocol)
** Copyright (c) 2002 Hubert Sokoowski <who_ami@tlen.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/

#include "jabby.h"
#include <string.h>
#include <time.h>

jabby_search_res *jabby_search_res_new()
{
  jabby_search_res *search;

  search = g_malloc(sizeof(*search));
  memset(search, '\0', sizeof(*search));
  return search;
}

jabby_search_set *jabby_search_set_new()
{
  jabby_search_set *search;

  search = g_malloc(sizeof(*search));
  memset(search, '\0', sizeof(*search));
  return search;
}

void jabby_search_res_free(jabby_search_res *search)
{
  g_free(search->id);
  g_free(search->first);
  g_free(search->last);
  g_free(search->city);
  g_free(search->nick);
  g_free(search);
}

void jabby_search_set_free(jabby_search_set *search)
{
  g_free(search->id);
  g_free(search->first);
  g_free(search->last);
  g_free(search->city);
  g_free(search);
}

void jabby_search_wp(jabby_session *ses, jabby_search_set *search)
{
  iks *x, *y, *d, *field, *value;
  gchar *s;

  x = iks_new("iq");
  iks_insert_attrib(x, "type", "set");
  iks_insert_attrib(x, "to", "search.jabber.wp.pl");
  iks_insert_attrib(x, "id", "search");
  y = iks_insert(x, "query");
  iks_insert_attrib(y, "xmlns", IKS_NS_SEARCH);
  d = iks_insert(y, "x");
  iks_insert_attrib(d, "xmlns", "jabber:x:data");
  if(search->id)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "nick");
    value = iks_insert(field, "value");
    iks_insert_cdata(value, search->id, -1);
  }
  if(search->first)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "first");
    value = iks_insert(field, "value");
    iks_insert_cdata(value, search->first, -1);
  }
  if(search->last)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "last");
    value = iks_insert(field, "value");
    iks_insert_cdata(value, search->last, -1);
  }
  if(search->city)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "city");
    value = iks_insert(field, "value");
    iks_insert_cdata(value, search->city, -1);
  }
  if(search->age_min)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "age_min");
    value = iks_insert(field, "value");
    s = g_strdup_printf("%d", search->age_min);
    iks_insert_cdata(value, s, -1);
    g_free(s);
  }
  if(search->age_max)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "age_max");
    value = iks_insert(field, "value");
    s = g_strdup_printf("%d", search->age_max);
    iks_insert_cdata(value, s, -1);
    g_free(s);
  }
  if(search->population)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "population");
    value = iks_insert(field, "value");
    s = g_strdup_printf("%d", search->population);
    iks_insert_cdata(value, s, -1);
    g_free(s);
  }
  if(search->province)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "province");
    value = iks_insert(field, "value");
    s = g_strdup_printf("%d", search->province);
    iks_insert_cdata(value, s, -1);
    g_free(s);
  }
  if(search->sex)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "sex");
    value = iks_insert(field, "value");
    s = g_strdup_printf("%d", search->sex);
    iks_insert_cdata(value, s, -1);
    g_free(s);
  }
  if(search->occupation)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "occupation");
    value = iks_insert(field, "value");
    s = g_strdup_printf("%d", search->occupation);
    iks_insert_cdata(value, s, -1);
    g_free(s);
  }
  if(search->online)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "online");
    value = iks_insert(field, "value");
    s = g_strdup_printf("%d", search->online);
    iks_insert_cdata(value, s, -1);
    g_free(s);
  }
  iks_send(ses->parser, x);
  iks_delete(x);
}

void jabby_gg_search_start(jabby_session *session, jabby_search_set *search)
{
  iks *x, *y, *d, *field, *value;
  gchar *s;
  GDate *date;
  int current_time, year;

  x = iks_new("iq");
  iks_insert_attrib(x, "type", "set");
  s = g_strconcat("gg.", session->id->server, NULL);
  iks_insert_attrib(x, "to", s);
  g_free(s);
  /* remember year in id ;)  */
  date = g_date_new();
  current_time = time(NULL);
  g_date_set_time(date, current_time);
  year = g_date_get_year(date);
  s = g_strdup_printf("%d %d", year, current_time);
  iks_insert_attrib(x, "id", s);
  g_free(s);
//  iks_insert_attrib(x, "id", "search_1");
  y = iks_insert(x, "query");
  iks_insert_attrib(y, "xmlns", IKS_NS_SEARCH);
  iks_insert_attrib(y, "type", "submit");
  d = iks_insert(y, "x");
  iks_insert_attrib(d, "xmlns", "jabber:x:data");
  if(search->nick)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "nick");
    value = iks_insert(field, "value");
    iks_insert_cdata(value, search->nick, -1);
  }
  if(search->first)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "firstname");
    value = iks_insert(field, "value");
    iks_insert_cdata(value, search->first, -1);
  }
  if(search->last)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "lastname");
    value = iks_insert(field, "value");
    iks_insert_cdata(value, search->last, -1);
  }
  if(search->city)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "city");
    value = iks_insert(field, "value");
    iks_insert_cdata(value, search->city, -1);
  }
  if(search->age_min)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "birthyear");
    value = iks_insert(field, "value");
    s = g_strdup_printf("%d", year - search->age_min);
    iks_insert_cdata(value, s, -1);
    g_free(s);
  }
  if(search->id)
  {
    field = iks_insert(d, "field");
    iks_insert_attrib(field, "var", "uin");
    value = iks_insert(field, "value");
    iks_insert_cdata(value, search->id, -1);
  }

  field = iks_insert(d, "field");
  iks_insert_attrib(field, "var", "gender");
  value = iks_insert(field, "value");
  if (search->sex)
    {
      s = g_strdup_printf("%d", search->sex);
      iks_insert_cdata(value, s, -1);
    }
  else
    iks_insert_cdata(value, "_any_", -1);

  field = iks_insert(d, "field");
  iks_insert_attrib(field, "var", "maxgroups");
  value = iks_insert(field, "value");
  iks_insert_cdata(value, "1", -1);

  iks_send(session->parser, x);
  iks_delete(x);
}
