/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** Thanks to GG2 Team for most of this code
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#ifndef DISABLE_DOCKLET

#include "main.h"
#include <X11/Xatom.h>

#include "eggtrayicon.h"
#include "utils.h"
#include "support.h"
#include "docklet.h"


static gboolean docklet_notify_visible = FALSE;
guint docklet_notify_active_type = NOTIFY_NOEVENT;


static const gchar  *tooltips_info_key = "_GtkTooltipsInfo";

static GtkWidget *pixmap = NULL;
static GtkTooltips *tooltips = NULL;
static GtkWidget *docklet = NULL;

static void
tip_window_display_closed (GdkDisplay  *display,
                           gboolean     was_error,
                           GtkTooltips *tooltips);
static void
disconnect_tip_window_display_closed (GtkTooltips *tooltips);

static void
gtk_tooltips_unset_tip_window (GtkTooltips *tooltips)
{
  if (tooltips->tip_window)
  {
    disconnect_tip_window_display_closed (tooltips);

    gtk_widget_destroy (tooltips->tip_window);
    tooltips->tip_window = NULL;
  }
}


static void
tip_window_display_closed (GdkDisplay  *display,
                           gboolean     was_error,
                           GtkTooltips *tooltips)
{
  gtk_tooltips_unset_tip_window (tooltips);
}


static void
gtk_tooltips_set_active_widget (GtkTooltips *tooltips,
                                GtkWidget   *widget)
{
  if (tooltips->tip_window)
  {
    if (GTK_WIDGET_VISIBLE (tooltips->tip_window))
      g_get_current_time (&tooltips->last_popdown);
    gtk_widget_hide (tooltips->tip_window);
  }
  if (tooltips->timer_tag)
  {
    g_source_remove (tooltips->timer_tag);
    tooltips->timer_tag = 0;
  }

  tooltips->active_tips_data = NULL;

  if (widget)
  {
    GList *list;

    for (list = tooltips->tips_data_list; list; list = list->next)
    {
      GtkTooltipsData *tooltipsdata;

      tooltipsdata = list->data;

      if (tooltipsdata->widget == widget &&
          GTK_WIDGET_DRAWABLE (widget))
      {
        tooltips->active_tips_data = tooltipsdata;
        break;
      }
    }
  }
  else
  {
    tooltips->use_sticky_delay = FALSE;
  }
}

static gboolean
get_keyboard_mode (GtkWidget *widget)
{
  GtkWidget *toplevel = gtk_widget_get_toplevel (widget);
  if (GTK_IS_WINDOW (toplevel))
    return GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (toplevel),
                                                "gtk-tooltips-keyboard-mode"));
  else
    return FALSE;
}


static void
disconnect_tip_window_display_closed (GtkTooltips *tooltips)
{
  g_signal_handlers_disconnect_by_func (gtk_widget_get_display
                                        (tooltips->tip_window),
                                        (gpointer) tip_window_display_closed,
                                        tooltips);
}

static void
gtk_tooltips_update_screen (GtkTooltips *tooltips,
                            gboolean     new_window)
{
  gboolean screen_changed = FALSE;

  if (tooltips->active_tips_data &&
      tooltips->active_tips_data->widget)
  {
    GdkScreen *screen = gtk_widget_get_screen
            (tooltips->active_tips_data->widget);

    screen_changed = (screen != gtk_widget_get_screen (tooltips->tip_window));

    if (screen_changed)
    {
      if (!new_window)
        disconnect_tip_window_display_closed (tooltips);

      gtk_window_set_screen (GTK_WINDOW (tooltips->tip_window), screen);
    }
  }

  if (screen_changed || new_window)
    g_signal_connect (gtk_widget_get_display (tooltips->tip_window), "closed",
                      G_CALLBACK (tip_window_display_closed), tooltips);

}

static void
gtk_tooltips_draw_tips (GtkTooltips *tooltips)
{
  GtkRequisition requisition;
  GtkWidget *widget;
  GtkStyle *style;
  gint x, y, w, h;
  GtkTooltipsData *data;
  gboolean keyboard_mode;
  GdkScreen *screen;
  GdkScreen *pointer_screen;
  gint monitor_num, px, py;
  GdkRectangle monitor;

  if (!tooltips->tip_window)
    gtk_tooltips_force_window (tooltips);
  else if (GTK_WIDGET_VISIBLE (tooltips->tip_window))
    g_get_current_time (&tooltips->last_popdown);

  gtk_widget_ensure_style (tooltips->tip_window);
  style = tooltips->tip_window->style;
  widget = tooltips->active_tips_data->widget;
  g_object_set_data (G_OBJECT (tooltips->tip_window), tooltips_info_key,
                     tooltips);

  keyboard_mode = get_keyboard_mode (widget);

  gtk_tooltips_update_screen (tooltips, FALSE);

  screen = gtk_widget_get_screen (widget);

  data = tooltips->active_tips_data;

  gtk_label_set_text (GTK_LABEL (tooltips->tip_label), data->tip_text);

  gtk_widget_size_request (tooltips->tip_window, &requisition);
  w = requisition.width;
  h = requisition.height;
  gdk_window_get_origin (widget->window, &x, &y);
  if (GTK_WIDGET_NO_WINDOW (widget))
  {
    x += widget->allocation.x;
    y += widget->allocation.y;
  }

  x += widget->allocation.width / 2;

  if (!keyboard_mode)
    gdk_window_get_pointer (gdk_screen_get_root_window (screen),
                            &x, NULL, NULL);

  x -= (w / 2 + 4);
  gdk_display_get_pointer (gdk_screen_get_display (screen),
                           &pointer_screen, &px, &py, NULL);
  if (pointer_screen != screen)
  {
    px = x;
    py = y;
  }
  monitor_num = gdk_screen_get_monitor_at_point (screen, px, py);
  gdk_screen_get_monitor_geometry (screen, monitor_num, &monitor);

  if ((x + w) > monitor.x + monitor.width)
    x -= (x + w) - (monitor.x + monitor.width);
  else if (x < monitor.x)
    x = monitor.x;

  if ((y + h + widget->allocation.height + 4) > monitor.y + monitor.height)
    y = y - h - 4;
  else
    y = y + widget->allocation.height + 4;
    gtk_window_move (GTK_WINDOW (tooltips->tip_window), x, y);
//  gtk_window_set_transient_for (GTK_WINDOW (tooltips->tip_window),
//                                );
//  gtk_window_set_position (GTK_WINDOW (tooltips->tip_window),
//                           GTK_WIN_POS_CENTER_ON_PARENT);
//  gtk_window_move (GTK_WINDOW (tooltips->tip_window), 4, 4);
//  gtk_widget_set_uposition (tooltips->tip_window, 0, 0);
  gtk_widget_show (tooltips->tip_window);
}

static void
gtk_tooltips_hide_tip (GtkWidget *widget)
{
  GtkTooltipsData *tooltipsdata;

  tooltipsdata = gtk_tooltips_data_get (widget);

  if (tooltipsdata &&
      (tooltipsdata->tooltips->active_tips_data &&
       tooltipsdata->tooltips->active_tips_data->widget == widget))
    gtk_tooltips_set_active_widget (tooltipsdata->tooltips, NULL);
}


static void
gtk_tooltips_show_tip (GtkWidget *widget)
{
  GtkTooltipsData *tooltipsdata;

  tooltipsdata = gtk_tooltips_data_get (widget);

  if (tooltipsdata &&
      (!tooltipsdata->tooltips->active_tips_data ||
       tooltipsdata->tooltips->active_tips_data->widget != widget))
  {
    gtk_tooltips_set_active_widget (tooltipsdata->tooltips, widget);
    gtk_tooltips_draw_tips (tooltipsdata->tooltips);
  }
}

static gboolean hide_tip (gpointer data)
{
  gtk_tooltips_hide_tip (docklet);
  docklet_change_status (status);
  return FALSE;
}

void docklet_set_tip (const gchar *tip)
{
  gchar *s;
  GdkEvent *ev;
  gboolean ret;

  if (! GTK_IS_WIDGET (status_docklet) ) {
    create_docklet ();
  }
  s = utf (tip);
  gtk_tooltips_set_tip (tooltips, docklet, s, NULL);
  ev = gdk_event_new (GDK_ENTER_NOTIFY);
  ev->crossing.send_event = TRUE;
  ev->crossing.window = g_object_ref (docklet->window);
  ev->crossing.time = get_miliseconds ();
  ev->crossing.x = 0;
  ev->crossing.y = 0;
  g_signal_emit_by_name (docklet, "enter_notify_event",
                         (GdkEventCrossing*) ev, &ret, 0);
  gdk_event_free (ev);
  gtk_tooltips_show_tip (docklet);
  g_timeout_add (3000, hide_tip, NULL);
  tleenx_print(DEBUG, "show tips\n");
  g_free (s);
}

void docklet_change_status(guint status)
{
  gchar *s = NULL, *p = NULL;

  if (! GTK_IS_WIDGET (status_docklet) ) {
    create_docklet();
  }

  /* set status icon */
  gtk_image_set_from_pixbuf(GTK_IMAGE(pixmap),
                            gtk_image_get_pixbuf(GTK_IMAGE(icons[status])));
  gtk_widget_show(pixmap);
  /* set tooltip */
  if( (s = desc_get_full()) )
	  p = g_strdup_printf("TleenX2 - %s\nOpis: %s", opisy[status-2], s);
  else
	  p = g_strdup_printf("TleenX2 - %s", opisy[status-2]); 
  tleenx_print(DEBUG, "docklet_set_tip(): tryin to set: %s.\n", p);
  g_free(s);
  s = utf(p);
  g_free(p);
  gtk_tooltips_set_tip(tooltips, docklet, s, NULL);
  g_free(s);

}


void docklet_notify_start(guint notify_type)
{
	if (! GTK_IS_WIDGET (status_docklet) ) {
		create_docklet();
	}
	
	/* set status icon */
	gtk_image_set_from_pixbuf(GTK_IMAGE(pixmap),
			gtk_image_get_pixbuf(GTK_IMAGE(notify_icons[notify_type])));
	gtk_widget_show(pixmap);
	docklet_notify_active_type = notify_type;
	docklet_notify_visible = TRUE;
}


void docklet_notify_clear()
{
	docklet_notify_active_type = NOTIFY_NOEVENT;
	docklet_notify_visible = FALSE;
	docklet_change_status(status);
}


void docklet_notify_blink()
{
	if(docklet_notify_active_type) {
		if(docklet_notify_visible) {
			docklet_change_status(status);
			docklet_notify_visible = FALSE;
		}
		else {
			gtk_image_set_from_pixbuf(GTK_IMAGE(pixmap),gtk_image_get_pixbuf(
						GTK_IMAGE(notify_icons[docklet_notify_active_type])));
			gtk_widget_show(pixmap);
			docklet_notify_visible = TRUE;
		}
	}

}


static
void docklet_clicked_cb(GtkWidget * widget, GdkEventButton * ev, gpointer data)
{
  GtkWidget *menu;

  if(!window1) return;

  if(ev->button == 3) {
    menu = lookup_widget(window1, "menu_tlen");
    gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
                   ev->button, ev->time);
  }
  else if(ev->button == 2) {
    menu = lookup_widget(window1, "menu_status");
    gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
                   ev->button, ev->time);
  }
  else if(ev->button == 1) {
    if(GTK_WIDGET_VISIBLE(window1)) {
      gtk_window_get_position(GTK_WINDOW(window1), &posx, &posy);
      gtk_widget_hide(window1);
    }
    else {
      gtk_window_move(GTK_WINDOW(window1), posx, posy);
      gtk_widget_show(window1);
    }
  }

}

void create_docklet()
{
  GtkWidget *eventbox;

  docklet = GTK_WIDGET (egg_tray_icon_new("TleenX 2"));
  if (!docklet) return;

  gtk_widget_realize(GTK_WIDGET(docklet));

  /* tooltip */
  tooltips = gtk_tooltips_new();
  gtk_tooltips_enable(tooltips);

  pixmap = gtk_image_new();

  eventbox = gtk_event_box_new();

  gtk_container_add(GTK_CONTAINER(eventbox), pixmap);
  gtk_container_add(GTK_CONTAINER(docklet), eventbox);

  g_signal_connect(G_OBJECT(docklet),"button_press_event",
                   G_CALLBACK(docklet_clicked_cb),pixmap);

  gtk_widget_show_all(docklet);

  status_docklet = docklet;
  //docklet_change_status(TLEN_STATUS_UNAVAILABLE);
  if(window1) docklet_change_status(status);
  else docklet_change_status(TLEN_STATUS_UNAVAILABLE);

}

void docklet_show() {
  if(status_docklet) {
    if (GTK_IS_WIDGET (status_docklet) ) {
      gtk_widget_show_all(status_docklet);  
    }
    else {
      status_docklet = NULL;
      create_docklet();
    }
  }
}

#endif

