/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/

/*obsluga okna search*/


#include "main.h"
#include "search.h"
#include "support.h"
#include "utils.h"

static gchar *look_for[] = {
  "", "rozmowa", "przyja", "romans", "mio"
};



void pubdir_list_add(struct tlen_pubdir *pubdir)
{
  pubdir_list = g_list_append(pubdir_list, (gpointer*)pubdir);
}

void pubdir_list_clear()
{
  struct tlen_pubdir *pubdir;
  GList *l = pubdir_list;

  while(l)
  {
    pubdir = (struct tlen_pubdir*)l->data;
    tlen_free_pubdir(pubdir);
    l = l->next;
  }
  g_list_free(pubdir_list);
  pubdir_list = NULL;
}

void search_update()
{
  GtkTreeStore *store;
  GtkTreeIter iter;
  GList *l;
  struct tlen_pubdir *pubdir;
  gchar *s=NULL;
  GtkWidget *treeview;

  store = gtk_tree_store_new(SEARCH_TC_COLUMNS,
                             G_TYPE_UINT,//status
                             G_TYPE_STRING,//jid
                             G_TYPE_UINT,//wiek
                             G_TYPE_STRING,//plec
                             G_TYPE_STRING,//miasto
                             G_TYPE_STRING,//imie
                             G_TYPE_STRING,//nazwisko
                             G_TYPE_STRING,//nick
                             G_TYPE_STRING,//email
                             G_TYPE_STRING,//poszukuje
                             G_TYPE_STRING,//szkola
                             G_TYPE_STRING,//zawod
                             G_TYPE_STRING,//glosowe
                             G_TYPE_STRING//plany
                             );
  for(l = pubdir_list; l; l=l->next)
  {
    guint status;

    pubdir = (struct tlen_pubdir*) l->data;
    status = pubdir->status;
    gtk_tree_store_append (store, &iter,NULL);
    if(status == 0)
      status = TLEN_STATUS_UNAVAILABLE;
    if(status == 1)
      status = TLEN_STATUS_INVISIBLE;
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_STATUS, status,
                        SEARCH_TC_ID, pubdir->id,
                        -1);
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_AGE, pubdir->age,
                        -1);

    switch(pubdir->gender)
    {
      case TLEN_PUBDIR_GENDER_FEMALE:
        s = utf("kobieta");
        break;
      case TLEN_PUBDIR_GENDER_MALE:
        s = utf("mczyzna");
        break;
      case TLEN_PUBDIR_GENDER_NONE:
        s = utf("");
        break;
    }
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_GENDER, s,
                        -1);
    g_free(s);

    s = utf(pubdir->city);
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_CITY, s,
                        -1);
    g_free(s);

    s = utf(pubdir->firstname);
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_FIRSTNAME, s,
                        -1);
    g_free(s);

    s = utf(pubdir->lastname);
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_SURNAME, s,
                        -1);
    g_free(s);

    s = utf(pubdir->nick);
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_NICK, s,
                        -1);
    g_free(s);

    s = utf(pubdir->email);
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_EMAIL, s,
                        -1);
    g_free(s);

    s = utf(look_for[pubdir->look_for]);
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_LOOK, s,
                        -1);
    g_free(s);

    s = utf(pubdir->school);
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_SCHOOL, s,
                        -1);
    g_free(s);

    s = utf(job[pubdir->job]);
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_JOB, s,
                        -1);
    g_free(s);

    if(pubdir->voice == TLEN_PUBDIR_VOICE_ENABLED)
      gtk_tree_store_set (store, &iter,
                          SEARCH_TC_VOICE, "tak",
                          -1);
    else
      gtk_tree_store_set (store, &iter,
                          SEARCH_TC_VOICE, "nie",
                          -1);

    s = utf(plans[pubdir->plans]);
    gtk_tree_store_set (store, &iter,
                        SEARCH_TC_PLANS, s,
                        -1);
    g_free(s);
  }

  treeview = lookup_widget(window_search, "treeview");
  gtk_tree_view_set_model(GTK_TREE_VIEW(treeview),
                          GTK_TREE_MODEL(store));
  g_object_unref(G_OBJECT(store));
}
