;;; toolbar-fancy.el --- Use fancy toolbar icons

;; Copyright (C) 1998 by Jan Vroonof

;; Author: Jan Vroonhof    <vroonhof@math.ethz.ch>
;; Keywords: toolbar

;; This file is not part of XEmacs.

;; This software  is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This software  is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs ; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Synched up with: Not in FSF

;;; Commentary:

;;; Change Log

;;; Code:

(defvar color-x-toolbar-list
  '((toolbar-last-win-icon . "color-last-win")
    (toolbar-next-win-icon . "color-next-win")
    (toolbar-file-icon     . "color-file")
    (toolbar-folder-icon   . "color-folder")
    (toolbar-disk-icon     . "color-disk")
    (toolbar-printer-icon  . "color-printer")
    (toolbar-cut-icon      . "color-cut")
    (toolbar-copy-icon     . "color-copy")
    (toolbar-paste-icon    . "color-paste")
    (toolbar-undo-icon     . "color-undo")
    (toolbar-spell-icon    . "color-spell")
    (toolbar-replace-icon  . "color-replace")
    (toolbar-mail-icon     . "color-mail")
    (toolbar-info-icon     . "color-info-def")
    (toolbar-compile-icon  . "color-compile")
    (toolbar-debug-icon    . "color-debug")
    (toolbar-news-icon     . "color-news")))

(defvar next-x-toolbar-list
  '((toolbar-last-win-icon . "next-last-win")
    (toolbar-next-win-icon . "next-next-win")
    (toolbar-file-icon     . "next-file")
    (toolbar-folder-icon   . "next-folder")
    (toolbar-disk-icon     . "next-disk")
    (toolbar-printer-icon  . "next-printer")
    (toolbar-cut-icon      . "next-cut")
    (toolbar-copy-icon     . "next-copy")
    (toolbar-paste-icon    . "next-paste")
    (toolbar-undo-icon     . "next-undo")
    (toolbar-spell-icon    . "next-spell")
    (toolbar-replace-icon  . "next-replace")
    (toolbar-mail-icon     . "next-mail")
    (toolbar-info-icon     . "next-info-def")
    (toolbar-compile-icon  . "next-compile")
    (toolbar-debug-icon    . "next-debug")
    (toolbar-news-icon     . "next-news")))

(defvar fancy-toolbar-lists-plist
  '(nil init-x-toolbar-list
    color color-x-toolbar-list
    next  next-x-toolbar-list))

;;;###autoload
(defun init-fancy-toolbar (type)
  (toolbar-add-item-data (symbol-value
			  (plist-get fancy-toolbar-lists-plist type))
			 (and type (locate-data-directory "toolbar-fancy")))
  ;; do this now because errors will occur if the icon symbols
  ;; are not initted
  (set-specifier default-toolbar initial-toolbar-spec)
  (setq use-fancy-toolbar type))

;;;###autoload
(defun set-fancy-toolbar (var value)
  (init-fancy-toolbar value))

;; The special 'set' function construction is to satisfy cus-dep.el
(defcustom use-fancy-toolbar nil
  "* Use colored icons for the toolbar."
  :type '(radio (const nil   :tag "Black and White")
		(const color :tag "Color")                
		; (const next  :tag "Next Style")
                )
  :group 'toolbar
  :require 'toolbar-fancy
  :set 'set-fancy-toolbar)

(provide 'toolbar-fancy)
