<?cs set:html.stylesheet = 'css/timeline.css' ?>
<?cs include "header.cs"?>

<div id="ctxtnav" class="nav"></div>

<div id="content" class="timeline">
 <h1>タイムライン</h1>

 <form id="prefs" action="<?cs var:trac.href.timeline ?>">
  <div>
   <label for="from">表示する履歴: </label>
   <input type="text" size="10" id="from" name="from"
       value="<?cs var:timeline.from ?>" /> から <input type="text" size="3"
       id="daysback" name="daysback"  value="<?cs var:timeline.daysback ?>" />
   <label for="daysback">日間</label>.
  </div>
  <fieldset>
   <?cs if:trac.acl.TICKET_VIEW ?><div class="field">
    <input type="checkbox" id="ticket" name="ticket" <?cs
      if:timeline.ticket ?>checked="checked"<?cs /if ?> />
    <label for="ticket">チケットの更新</label>
   </div><?cs /if ?>
   <?cs if:trac.acl.CHANGESET_VIEW ?><div class="field">
    <input type="checkbox" id="changeset" name="changeset" <?cs
      if:timeline.changeset ?>checked="checked"<?cs /if ?> />
    <label for="changeset">リポジトリへのチェックイン</label>
   </div><?cs /if ?>
   <?cs if:trac.acl.WIKI_VIEW ?><div class="field">
    <input type="checkbox" id="wiki" name="wiki" <?cs
      if:timeline.wiki ?>checked="checked"<?cs /if ?> />
    <label for="wiki">Wikiの更新</label>
   </div><?cs /if ?>
   <?cs if:trac.acl.MILESTONE_VIEW ?><div class="field">
    <input type="checkbox" id="milestone" name="milestone" <?cs
      if:timeline.milestone ?>checked="checked"<?cs /if ?> />
    <label for="milestone">マイルストーン</label>
   </div><?cs /if ?>
  </fieldset>
  <div class="buttons">
   <input type="submit" value="更新" />
  </div>
 </form>

<?cs def:day_separator(date) ?>
 <?cs if: $date != $current_date ?>
  <?cs if: $current_date ?></dl><?cs /if ?>
  <?cs set: $current_date = $date ?>
  <h2><?cs var:date ?>:</h2>
  <dl>
 <?cs /if ?>
<?cs /def ?>

<?cs def:tlitem(url, type, msg, descr) ?>
 <dt class="<?cs var:type ?>">
  <a href="<?cs var:url ?>"><span class="time"><?cs
    var:item.time ?></span> <?cs var:msg ?></a>
 </dt>
 <?cs if:descr ?><dd><?cs var:descr ?></dd><?cs /if ?>
<?cs /def ?>

<?cs each:item = timeline.items ?>
 <?cs call:day_separator(item.date) ?>
 <?cs if:item.type == #1 ?><!-- Changeset -->
  <?cs call:tlitem(item.href, 'changeset',
    'チェンジセット <em>['+$item.idata+']</em> が '+$item.author+' によってコミットされました。', $item.node_list+item.message) ?>
 <?cs elif:item.type == #2 ?><!-- New ticket -->
  <?cs call:tlitem(item.href, 'newticket',
    'チケット <em>#'+$item.idata+'</em> が '+$item.author+' によって作成されました。', item.message) ?>
 <?cs elif:item.type == #3 ?><!-- Closed ticket -->
  <?cs if:item.message ?>
   <?cs set:imessage = ' - ' + $item.message ?>
  <?cs else ?>
   <?cs set:imessage = '' ?>
  <?cs /if ?>
  <?cs call:tlitem(item.href, 'closedticket',
    'チケット <em>#'+$item.idata+'</em> が '+$item.author+' によって対処されました。', 
    $item.tdata+$imessage) ?>
 <?cs elif:item.type == #4 ?><!-- Reopened ticket -->
  <?cs call:tlitem(item.href, 'newticket',
    'チケット <em>#'+$item.idata+'</em> が '+$item.author+' によって差し戻されました。', '') ?>
 <?cs elif:item.type == #5 ?><!-- Wiki change -->
  <?cs call:tlitem(item.href, 'wiki',
    'Wikiページ <em>'+$item.tdata+'</em> が '+$item.author+' によって編集されました。', item.message) ?>
 <?cs elif:item.type == #6 ?><!-- milestone -->
  <?cs call:tlitem(item.href, 'milestone',
    'マイルストーン <em>'+$item.message+'</em> に到達しました', '') ?>
 <?cs /if ?>
<?cs /each ?>
<?cs if:len(timeline.items) ?></dl><?cs /if ?>

<div id="help">
 <hr />
 <strong>Note:</strong> タイムラインについてのヘルプは <a href="<?cs var:$trac.href.wiki ?>/TracTimeline">TracTimeline</a> 
 を参照してください。
</div>

</div>
<?cs include "footer.cs"?>
