%define name traffic-vis
%define version 0.34
%define release 1

%define builddir $RPM_BUILD_DIR/%{name}-%{version}

Summary: Network monitoring tool

Name: %{name}
Version: %{version}
Release: %{release}
Group: Networking/Admin
Copyright: GPL
Vendor: Damien Miller <dmiller@ilogic.com.au>
Url: http://www.ilogic.com.au/~dmiller/traffic-vis.html
Packager: Red Hat Contrib|Net <rhcn-bugs@redhat.com>
Distribution: Red Hat Contrib|Net
Source0: http://www.ilogic.com.au/~dmiller/files/%{name}-%{version}.tar.gz
Buildroot: /tmp/%{name}-%{version}-%{release}-root
Requires: libgr-progs, ghostscript

%changelog
* Thu Apr 08 1999 Damien Miller <dmiller@ilogic.com.au>

- Updated to version 0.34

* Sat Mar 27 1999 Damien Miller <dmiller@ilogic.com.au>

- Updated to version 0.33

* Mon Feb 15 1999 Damien Miller <dmiller@ilogic.com.au>

- Updated to version 0.32

* Fri Feb 12 1999 Damien Miller <dmiller@ilogic.com.au>

- Fixed Group field

- Fixed Packager and distribution for submission to RHCN

- Moved changelog to near top of file

* Wed Feb 10 1999 Damien Miller <dmiller@ilogic.com.au>

- Modified to build using static glib without makefile patches

- Added traffic-exclude program

- Increased version number

* Tue Feb 02 1999 Damien Miller <dmiller@ilogic.com.au>

- Added traffic-togif program

- Added dependancies to requires

* Sat Jan 30 1999 Damien Miller <dmiller@ilogic.com.au>

- Added traffic-resolve program and manpage

- Added frontends and their manpages

- Added traffic-vis manpage

* Thu Jan 28 1999 Damien Miller <dmiller@ilogic.com.au>

- Updated to development version v0.30pre

* Tue Dec 01 1998 Damien Miller <dmiller@ilogic.com.au>

- Updated to traffic-vis v0.21
- Added CHANGELOG to %doc files

* Sun Nov 29 1998 Damien Miller <dmiller@ilogic.com.au>

- Initial RPMification

%description
traffic-vis is a suite of tools to help determine which hosts have been
communicating on an IP network, with whom they have been communicating
and the volume of communication taking place on a host by host basis.
It can report the information it gathers in ASCII, HTML or Postscript 
sorted in several different ways.

%prep

%setup

%build
make GLIB=/usr/lib/libglib.a

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT/ ; fi
mkdir -p $RPM_BUILD_ROOT/usr/sbin
mkdir -p $RPM_BUILD_ROOT/usr/man/man8
install -o root -g root -m 755 traffic-vis.8 $RPM_BUILD_ROOT/usr/man/man8
install -o root -g root -m 755 collector/traffic-collector $RPM_BUILD_ROOT/usr/sbin
install -o root -g root -m 644 collector/traffic-collector.8 $RPM_BUILD_ROOT/usr/man/man8
install -o root -g root -m 755 sort/traffic-sort $RPM_BUILD_ROOT/usr/sbin
install -o root -g root -m 755 sort/traffic-sort.8 $RPM_BUILD_ROOT/usr/man/man8
install -o root -g root -m 755 utils/traffic-resolve $RPM_BUILD_ROOT/usr/sbin
install -o root -g root -m 755 utils/traffic-resolve.8 $RPM_BUILD_ROOT/usr/man/man8
install -o root -g root -m 755 utils/traffic-exclude $RPM_BUILD_ROOT/usr/sbin
install -o root -g root -m 755 utils/traffic-exclude.8 $RPM_BUILD_ROOT/usr/man/man8
install -o root -g root -m 755 frontends/traffic-totext $RPM_BUILD_ROOT/usr/sbin
install -o root -g root -m 755 frontends/traffic-totext.8 $RPM_BUILD_ROOT/usr/man/man8
install -o root -g root -m 755 frontends/traffic-tohtml $RPM_BUILD_ROOT/usr/sbin
install -o root -g root -m 755 frontends/traffic-tohtml.8 $RPM_BUILD_ROOT/usr/man/man8
install -o root -g root -m 755 frontends/traffic-tops $RPM_BUILD_ROOT/usr/sbin
install -o root -g root -m 755 frontends/traffic-tops.8 $RPM_BUILD_ROOT/usr/man/man8
install -o root -g root -m 755 frontends/traffic-togif $RPM_BUILD_ROOT/usr/sbin
install -o root -g root -m 755 frontends/traffic-togif.8 $RPM_BUILD_ROOT/usr/man/man8

%files
%doc README COPYING TODO CHANGELOG BUGS
%attr(755,root,root) /usr/sbin/traffic-collector
%attr(755,root,root) /usr/sbin/traffic-sort
%attr(755,root,root) /usr/sbin/traffic-resolve
%attr(755,root,root) /usr/sbin/traffic-exclude
%attr(755,root,root) /usr/sbin/traffic-totext
%attr(755,root,root) /usr/sbin/traffic-tohtml
%attr(755,root,root) /usr/sbin/traffic-tops
%attr(755,root,root) /usr/sbin/traffic-togif
%attr(644,root,root) /usr/man/man8/traffic-vis.8
%attr(644,root,root) /usr/man/man8/traffic-collector.8
%attr(644,root,root) /usr/man/man8/traffic-sort.8
%attr(644,root,root) /usr/man/man8/traffic-resolve.8
%attr(644,root,root) /usr/man/man8/traffic-exclude.8
%attr(644,root,root) /usr/man/man8/traffic-totext.8
%attr(644,root,root) /usr/man/man8/traffic-tohtml.8
%attr(644,root,root) /usr/man/man8/traffic-tops.8

%clean
rm -r $RPM_BUILD_ROOT
rm -r %{builddir}


