//-*-c++-*-
/*
 Author: Delorme Maxime
 Email : Maxime.Delorme@gmail.com

 Last modification : 23/07/2005 (fr) 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef _GLAD_POINT_H
#define _GLAD_POINT_H

#include "GlAugmentedDisplay.h"

namespace tlp {
/** \brief General class to render points as augmented displays
 *
 * This class is a generic class to render points as augmented displays.
 * It only uses the basic GlAugmentedDisplay parameters(position and color).
 *
 * \attention The size of the point is fixed to 5 pixels.
 */
class GlADPoint : public GlAugmentedDisplay
{
 protected:
  Coord *position;
  Color *color;

 public:
  
  /**
   * Base constructor
   */
  GlADPoint();

  /**
   * Constructor with a given position and a given color
   */
  GlADPoint(const Coord &pos, const Color &col);

  /**
   * Destructor
   */
  virtual ~GlADPoint();

  /**
   * Virtual function used to draw the point.
   */
  virtual void draw(GlGraph* graph);

  /**
   * Virtual accessor in reading to the position
   */
  virtual Coord getPosition() const;

  /**
   * Virtual accessor in reading to the color
   */
  virtual Color getColor() const;

  /**
   * Virtual accessor in writing to the position.
   */
  virtual void setPosition(const Coord &position);

  /**
   * Virtual accessor in writing to the color
   */
  virtual void setColor(const Color &color);
};
}
#endif
