//-*-c++-*-
/*
 Author: Delorme Maxime
 Email : Maxime.Delorme@gmail.com

 Last modification : 24/08/2005 (fr) 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef GL_HUD_RECT_4_H
#define GL_HUD_RECT_4_H

#include "GlHud.h"

#define N_RECT_POINTS 4

namespace tlp {
class TLP_GL_SCOPE GlHudRect4 : public GlHud
{
 protected:

  Coord *positions[N_RECT_POINTS];
  Color *colors[N_RECT_POINTS];



 public:
  GlHudRect4();
  GlHudRect4(const Coord &topLeftPos, const Coord &topRightPos, const Coord &bottomRightPos, const Coord &bottomLeftPos, const Color &color);
  GlHudRect4(Coord positions[], const Color &color);
  ~GlHudRect4();

  void draw(GlGraph *);

  virtual Coord getPosition(int id) const;
  virtual Color getColor(int id) const;
  virtual void setPosition(int id, const Coord &position);
  virtual void setColor(int id, const Color &color);

  virtual void translate(const Coord delta);
  virtual void rotate(double angle);
};
}
#endif
