#include "tulip/GlADComposite.h"

using namespace tlp;
using namespace std;

namespace tlp {
  typedef stdext::hash_map<string, GlAugmentedDisplay *>::const_iterator ITM;
    //============================================================
  GlADComposite::GlADComposite() {
  }
  //============================================================
  GlADComposite::~GlADComposite() {
    reset(false);
  }
  //============================================================
  void GlADComposite::reset(bool deleteElems) {
    if (deleteElems)
      for(ITM i = elements.begin(); i != elements.end(); i++)
	delete (*i).second;
    elements.clear();
  }
  //============================================================
  void GlADComposite::addGlAugmentedDisplay(GlAugmentedDisplay *augmentedDisplay, const string &key) {
    elements[key] = augmentedDisplay;
  }
  //============================================================
  void GlADComposite::deleteGlAugmentedDisplay(const string &key) {
    elements.erase(key);
  }
  //============================================================
  void GlADComposite::deleteGlAugmentedDisplay(GlAugmentedDisplay *augmentedDisplay) {
    for(ITM i = elements.begin(); i != elements.end(); i++) {
      if(augmentedDisplay == (*i).second) {
	elements.erase((*i).first);
	return;
      }
    }
  }
  //============================================================
  GlAugmentedDisplay* GlADComposite::findGlAugmentedDisplay(const string &key) {
    ITM ite = elements.find(key);
    if (ite == elements.end())
      return NULL;
    return (*ite).second;
  }
  //============================================================
  void GlADComposite::draw(GlGraph *graph) {
    for(ITM ite = elements.begin(); ite != elements.end(); ite++)
      (*ite).second->draw(graph);
  }

  //======================================================================
  //see header for complete documentation
  void GlADComposite::makeAugmentedDislplaySelect (GlGraph *glGraph) {
    glMatrixMode(GL_MODELVIEW);
    glPushAttrib(GL_ALL_ATTRIB_BITS);
    for(ITM ite = elements.begin(); ite != elements.end(); ite++) { 
      glLoadName((unsigned int)&(*ite));
      glPushMatrix();
      ite->second->draw(glGraph);
      glPopMatrix();
    }
    glPopAttrib();
  }

   //============================================================
  //see headder for complete documentation
  bool GlADComposite::doSelect(const int x, const int y, 
			       const int width, const int height,
			       vector <pair <string, GlAugmentedDisplay *> >
			       &pickedAugmentedDisplays,
			       GlGraph *glGraph) {
    if (glGraph == 0) return false;
    if (glGraph->getSuperGraph() == 0) return false;
    glGraph->initDoSelect(x , y, width, height);
    makeAugmentedDislplaySelect(glGraph);
    glFlush();
    GLint hits = glRenderMode(GL_RENDER);
    if (hits <= 0) {
      delete [] glGraph->selectBuf; 
      glGraph->endSelect(); 
      return false;
    }
    while(hits > 0) {
      pair<string, GlAugmentedDisplay *> *pickedDisplay =
	(pair <string, GlAugmentedDisplay *> *) 
	(glGraph->selectBuf[hits-1][3]);
      pickedAugmentedDisplays.push_back (*pickedDisplay);
      --hits;
    }
    delete [] glGraph->selectBuf;
    glGraph->endSelect();
    return true;
  }

}
