//-*-c++-*-
/*
 Author: Delorme Maxime
 Email : Maxime.Delorme@gmail.com

 Last modification : 05/08/2005 (fr) 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include "tulip/GlHud.h"

using namespace std;

namespace tlp {
  //=========================================================
  GlHud::GlHud() {
  }
  //=========================================================
  GlHud::~GlHud() {
  }
  //=========================================================
  void GlHud::draw(GlGraph* graph) {
  }
  //=========================================================
  void GlHud::setup()  {
    glPushAttrib(GL_ALL_ATTRIB_BITS);
    renderOptions.setup();

    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glLoadIdentity();

    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();
  }
  //=========================================================
  void GlHud::unsetup() {
    glMatrixMode(GL_PROJECTION);
    glPopMatrix();

    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();

    glPopAttrib();
  }
  //=========================================================
  Coord GlHud::transformCoordinates(const Coord &position) {
    Coord res;
    int viewport[4];
    int w, h;
    glGetIntegerv(GL_VIEWPORT, viewport);
    w = viewport[2];
    h = viewport[3];
    float dW = (float)(w / 2);
    float dH = (float)(h / 2);
    res[0] = (position[0] - dW) / dW;
    res[1] = (position[1] - dH) / -dH;
    res[2] =  position[2];
    return res;
  }
  //=========================================================
}
