//-*-c++-*-
#ifndef MOUSEMOVESELECTION_H
#define MOUSEMOVESELECTION_H

#include <tulip/MouseInterface.h>
#include <tulip/GlHudRect.h>
#include <tulip/GlHudRect4.h>
#include <tulip/GlADComposite.h>
#include <tulip/Observable.h>

/** \addtogroup Mouse_interactor */ 
/*@{*/

class TLP_QT_SCOPE MouseMoveSelection:public MouseInterface {

public:

  MouseMoveSelection();
  ~MouseMoveSelection();
  void mPressEvent(GlGraphWidget *,QMouseEvent *);
  void mReleaseEvent(GlGraphWidget *,QMouseEvent *);
  void mMoveEvent(GlGraphWidget *,QMouseEvent *);
  void mPaint(GlGraphWidget *);
  void keyPressEvent (GlGraphWidget *, QKeyEvent *){};
  void keyReleaseEvent(GlGraphWidget *, QKeyEvent *){};
  void wheelEvent(GlGraphWidget *, QWheelEvent *){}
  MouseInterface * clone() { return new MouseMoveSelection();}

private:
  enum EditOperation { NONE=0, ROTATE, STRETCH_X, STRETCH_Y, STRETCH_XY, TRANSLATE};
  enum OperationTarget { COORD = 0, SIZE, COORD_AND_SIZE};

  SuperGraph *_superGraph;
  LayoutProxy *_layout;
  SelectionProxy *_selection;
  MetricProxy *_rotation;
  SizesProxy *_sizes;

  LayoutProxy *_copyLayout;
  SizesProxy *_copySizes;
  MetricProxy *_copyRotation;

  void initProxies(GlGraphWidget *glGraphWidget);
  void saveInfo();
  void restoreInfo();
  void initEdition();
  void undoEdition();
  void stopEdition();

  EditOperation operation;
  OperationTarget mode;

  Coord editCenter;
  Coord editPostion;
  Coord editLayoutCenter;

  int x,y;
  double centerX, centerY;
  Coord ffdCenter; 

  tlp::GlADComposite ffd;
  tlp::GlHudRect controlRects[8];
  tlp::GlHudRect4 centerRect;
  Coord _layoutCenter;

  void computeFFD(GlGraphWidget*);
  void mMouseTranslate(double, double, GlGraphWidget*);
  void mMouseRotate(double, double, GlGraphWidget*);
  void mMouseStretchAxis(double, double, GlGraphWidget*); 


};
/*@}*/

#endif
