//-*-c++-*-
#ifndef TULIP_METAGRAPHPROXY_H
#define TULIP_METAGRAPHPROXY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "PropertyProxy.h"
#include "TemplateFactory.h"

class PropertyContext;

/** \addtogroup properties */ 
/*@{*/
class TLP_SCOPE MetaGraphProxy:public PropertyProxy<MetaGraphType,MetaGraphType>, public GraphObserver { 
  friend class MetaGraph;

public :
  MetaGraphProxy (SuperGraph *);
  virtual ~MetaGraphProxy();
  PProxy* clonePrototype(SuperGraph *, std::string );
  void copy( const node, const node, PProxy * );
  void copy( const edge, const edge, PProxy * );
  void destroy(SuperGraph *);
  
private:
  MutableContainer<std::set<node> > referencedGraph;
  void setNodeValue_handler(const node n, const MetaGraphType::RealType &);
  void setAllNodeValue_handler(const MetaGraphType::RealType &);

};
/*@}*/
#endif

