//-*-c++-*-
#ifndef TULIP_METRICPROXY_H
#define TULIP_METRICPROXY_H

#include "PropertyProxy.h"
#include "TemplateFactory.h"
#include "Metric.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class PropertyContext;

/** \addtogroup properties */ 
/*\@{*/
class TLP_SCOPE MetricProxy:public PropertyProxy<DoubleType,DoubleType,Metric> { 

  friend class Metric;

public :
  MetricProxy (SuperGraph *);
  ~MetricProxy();
  DoubleType::RealType  getNodeMin(SuperGraph *sg=0);
  DoubleType::RealType  getNodeMax(SuperGraph *sg=0);
  DoubleType::RealType  getEdgeMin(SuperGraph *sg=0);
  DoubleType::RealType  getEdgeMax(SuperGraph *sg=0);
  PProxy* clonePrototype(SuperGraph *, std::string );
  void copy( const node, const node, PProxy * );
  void copy( const edge, const edge, PProxy * );
  void uniformQuantification(unsigned int);

protected:
  virtual void setNodeValue_handler(const node n, const DoubleType::RealType &);
  virtual void setEdgeValue_handler(const edge e, const DoubleType::RealType &);
  virtual void setAllNodeValue_handler(const DoubleType::RealType &);
  virtual void setAllEdgeValue_handler(const DoubleType::RealType &);
  void reset_handler();
  void recompute_handler();
  void clone_handler(PropertyProxy<DoubleType,DoubleType> &);

private:
  stdext::hash_map<unsigned long, double> maxN,minN,maxE,minE;
  stdext::hash_map<unsigned long, bool> minMaxOkNode;
  stdext::hash_map<unsigned long, bool> minMaxOkEdge;
  void computeMinMaxNode(SuperGraph *sg=0);
  void computeMinMaxEdge(SuperGraph *sg=0);
};
/*@}*/
#endif
