//-*-c++-*-

#include <float.h>
#include "tulip/MetricProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Metric.h"
#include "tulip/PropertyProxy.h"

using namespace std;

//==============================
///Constructeur d'un MetricProxy
MetricProxy::MetricProxy (SuperGraph *graph):PropertyProxy<DoubleType,DoubleType,Metric>(graph),
  minMaxOkNode(false),minMaxOkEdge(false) {
  //  propertyProxy=this;
}
//==============================
///Destructeur d'un metric Proxy  
///Vide pour l'instant, cela peut
///provoquer des fuites m�moires
MetricProxy::~MetricProxy() {
  notifyDestroy();
}    

void MetricProxy::uniformQuantification(unsigned int k) {
  std::map<double,double> nodeMapping;
  std::map<double,double> edgeMapping;

  //===============================================================
  //build the histogram of node values
  {
    map<double,int> histogram;
    Iterator<node> *itN=superGraph->getNodes();
    while (itN->hasNext()) {
	  node itn=itN->next();
      double nodeValue=getNodeValue(itn);
      if (histogram.find(nodeValue)==histogram.end()) 
	histogram[nodeValue]=1;
      else
	histogram[nodeValue]+=1;
    } delete itN;
    //===============================================================
    //Build the color map
    map<double,int>::iterator it;
    double sum=0;
    double cK=double(superGraph->numberOfNodes())/double(k);
    int k2=0;
    for (it=histogram.begin();it!=histogram.end();++it) {
      sum+=(*it).second;
      nodeMapping[(*it).first]=k2;
      while (sum>cK*double(k2+1)) ++k2;
    }
  }
  //===============================================================
  //build the histogram of edges values
  {
    map<double,int> histogram;
    Iterator<edge> *itE=superGraph->getEdges();
    while (itE->hasNext()) {
      edge ite=itE->next();
      double value=getEdgeValue(ite);
      if (histogram.find(value)==histogram.end()) 
	histogram[value]=1;
      else
	histogram[value]+=1;
    } delete itE;
    //===============================================================
    //Build the color map
    map<double,int>::iterator it;
    double sum=0;
    double cK=double(superGraph->numberOfEdges())/double(k);
    int k2=0;
    for (it=histogram.begin();it!=histogram.end();++it) {
      sum+=(*it).second;
      edgeMapping[(*it).first]=k2;
      while (sum>cK*double(k2+1)) ++k2;
    }
  }

  Iterator<node> *itN=superGraph->getNodes();
  while(itN->hasNext()) {
    node itn=itN->next();
    setNodeValue(itn,nodeMapping[getNodeValue(itn)]);
  } delete itN;
  Iterator<edge> *itE=superGraph->getEdges();
  while(itE->hasNext()) {
    edge ite=itE->next();
    setEdgeValue(ite,edgeMapping[getEdgeValue(ite)]);
  } delete itE;
}

//====================================================================
///Renvoie le minimum de la metrique associe aux noeuds du MetricProxy
double MetricProxy::getNodeMin(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  unsigned long sgi=(unsigned long)sg;
  if (minMaxOkNode.find(sgi)==minMaxOkNode.end()) minMaxOkNode[sgi]=false;
  if (!minMaxOkNode[sgi]) computeMinMaxNode(sg);
  return minN[sgi];

  //  if (!minMaxOkNode) computeMinMaxNode(sg);
  //  return minN;
}
//====================================================================
///Renvoie le maximum de la metrique associe aux noeuds du MetricProxy
double MetricProxy::getNodeMax(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  unsigned long sgi=(unsigned long)sg;
  if (minMaxOkNode.find(sgi)==minMaxOkNode.end()) minMaxOkNode[sgi]=false;
  if (!minMaxOkNode[sgi]) computeMinMaxNode(sg);
  return maxN[sgi];

  //if (!minMaxOkNode) computeMinMaxNode(sg);
  //return maxN;
}
//====================================================================
///Renvoie le Minimum de la metrique associe aux aretes du MetricProxy
double MetricProxy::getEdgeMin(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  unsigned long sgi=(unsigned long)sg;
  if (minMaxOkEdge.find(sgi)==minMaxOkEdge.end()) minMaxOkEdge[sgi]=false;
  if (!minMaxOkEdge[sgi]) computeMinMaxEdge(sg);
  return minE[sgi];
}
//====================================================================
///Renvoie le Maximum de la metrique associe aux aretes du MetricProxy
double MetricProxy::getEdgeMax(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  unsigned long sgi=(unsigned long)sg;
  if (minMaxOkEdge.find(sgi)==minMaxOkEdge.end()) minMaxOkEdge[sgi]=false;
  if (!minMaxOkEdge[sgi]) computeMinMaxEdge(sg);
  return maxE[sgi];
}
//=========================================================
void MetricProxy::computeMinMaxNode(SuperGraph *sg) {
  double tmp;
  double maxN2,minN2;
  Iterator<node> *itN=superGraph->getNodes();
  if (itN->hasNext()) {
    node itn=itN->next();
    tmp=getNodeValue(itn);
    maxN2=tmp;
    minN2=tmp;
  }
  while (itN->hasNext()) {
    node itn=itN->next();
    tmp=getNodeValue(itn);
    if (tmp>maxN2) maxN2=tmp;
    if (tmp<minN2) minN2=tmp;
  } delete itN;

  if (sg==0) sg=superGraph;
  unsigned long sgi=(unsigned long)sg;

  minMaxOkNode[sgi]=true;  
  minN[sgi]=minN2;
  maxN[sgi]=maxN2;
}
//=========================================================
void MetricProxy::computeMinMaxEdge(SuperGraph *sg) {
  double tmp;
  double maxE2,minE2;
  Iterator<edge> *itE=superGraph->getEdges();
  if (itE->hasNext()) {
    edge ite=itE->next();
    tmp=getEdgeValue(ite);
    maxE2=tmp;
    minE2=tmp;
  }
  while (itE->hasNext()) {
    edge ite=itE->next();
    tmp=getEdgeValue(ite);
    if (tmp>maxE2) maxE2=tmp;
    if (tmp<minE2) minE2=tmp;
  } delete itE;

  if (sg==0) sg=superGraph;
  unsigned long sgi=(unsigned long)sg;

  minMaxOkEdge[sgi]=true;
  minE[sgi]=minE2;
  maxE[sgi]=maxE2;
}
//=============================================================================
///Poign� permettnet le reset des variables du MetricProxy par le PropertyProxy
void MetricProxy::reset_handler() {
  minMaxOkNode.clear();
  minMaxOkEdge.clear();
}
//=============================================================================
///Poign� permettnet le recompute il faut absolument mettre le graphProperties
///currentMetricProxy � this sinon le r�sultat est impr�visible
void MetricProxy::recompute_handler() {
  //  superGraph->getPropertyManager()->currentPropertyProxy=this;
  minMaxOkNode.clear();
  minMaxOkEdge.clear();
}
//=================================================================================
void MetricProxy::clone_handler(PropertyProxy<DoubleType,DoubleType> &proxyC) {
  MetricProxy *proxy=(MetricProxy *)&proxyC;
  minMaxOkNode=proxy->minMaxOkNode;
  minMaxOkEdge=proxy->minMaxOkEdge;
  minN=proxy->minN;
  maxN=proxy->maxN;
  minE=proxy->minE;
  maxE=proxy->maxE;
}
//=================================================================================
void MetricProxy::setNodeValue_handler(const node n, const DoubleType::RealType &) {
  minMaxOkNode.clear();
}
void MetricProxy::setEdgeValue_handler(const edge e, const DoubleType::RealType &) {
  minMaxOkEdge.clear();
}
void MetricProxy::setAllNodeValue_handler(const DoubleType::RealType &) {
  minMaxOkNode.clear();
}
void MetricProxy::setAllEdgeValue_handler(const DoubleType::RealType &) {
  minMaxOkEdge.clear();
}

//=================================================================================
PProxy* MetricProxy::clonePrototype(SuperGraph * g, std::string n) {
  if( !g )
    return 0;
  MetricProxy * p = g->getLocalProperty<MetricProxy>( n );
  p->setAllNodeValue( getNodeDefaultValue() );
  p->setAllEdgeValue( getEdgeDefaultValue() );
  return p;
}
//=============================================================
void MetricProxy::copy( const node n0, const node n1, PProxy * p ) {
  if( !p )
    return;
  MetricProxy * tp = dynamic_cast<MetricProxy*>(p);
  assert( tp );
  setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void MetricProxy::copy( const edge e0, const edge e1, PProxy * p ) {
  if( !p )
    return;
  MetricProxy * tp = dynamic_cast<MetricProxy*>(p);
  assert( tp );
  setEdgeValue( e0, tp->getEdgeValue(e1) );
}
//=============================================================

