/*
 * Decompiled with CFR 0.152.
 */
package jargs.test.gnu;

import jargs.gnu.CmdLineParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;

public class CustomOptionTestCase
extends TestCase {
    public CustomOptionTestCase(String name) {
        super(name);
    }

    public void testCustomOption() throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option date = parser.addOption(new ShortDateOption('d', "date"));
        parser.parse(new String[]{"-d", "11/03/2003"}, Locale.UK);
        Date d = (Date)parser.getOptionValue(date);
        CustomOptionTestCase.assertEquals((int)11, (int)d.getDay());
        CustomOptionTestCase.assertEquals((int)3, (int)d.getMonth());
        CustomOptionTestCase.assertEquals((int)2003, (int)d.getYear());
        parser.parse(new String[]{"-d", "11/03/2003"}, Locale.US);
        d = (Date)parser.getOptionValue(date);
        CustomOptionTestCase.assertEquals((int)3, (int)d.getDay());
        CustomOptionTestCase.assertEquals((int)11, (int)d.getMonth());
        CustomOptionTestCase.assertEquals((int)2003, (int)d.getYear());
    }

    public void testIllegalCustomOption() throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option date = parser.addOption(new ShortDateOption('d', "date"));
        try {
            parser.parse(new String[]{"-d", "foobar"}, Locale.US);
            CustomOptionTestCase.fail((String)"Expected IllegalOptionValueException");
        }
        catch (CmdLineParser.IllegalOptionValueException illegalOptionValueException) {
            // empty catch block
        }
    }

    public static class ShortDateOption
    extends CmdLineParser.Option {
        public ShortDateOption(char shortForm, String longForm) {
            super(shortForm, longForm, true);
        }

        protected Object parseValue(String arg, Locale locale) throws CmdLineParser.IllegalOptionValueException {
            try {
                DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
                return dateFormat.parse(arg);
            }
            catch (ParseException e) {
                throw new CmdLineParser.IllegalOptionValueException(this, arg);
            }
        }
    }
}

