<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup BASE
 * @module acl_show
 * @package acl
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('acl','new');

 /**
  * display and change permissions
  */
 class acl_new extends layout {
   /**
    * Return an options array
    */
   Function acl_select($min, $max) {
     global $lang, $tutos;

     $options  = array();
     $selected = array();

     foreach ($this->user->parties as $i => $fn) {
       $l = 0;
       foreach($this->obj as $val) {
         if ( isset($val->acl[$i]) ) {
           $l = max($l, $val->acl[$i]);
         }
       }
       if ( ($l < $max) && ($l >= $min) ) 
	 $selected[] = $i;
       
       $options[$i] = $fn;
     }

     return array($options, $selected);
   }

   /**
    * show info
    */
   Function info() {
     global $lang,$tutos;

     $this->assign('action', 'acl_ins.php');

     $this->user->readKnownParties();
     $this->user->parties[0] = $lang['everybody'];

     $ids = array();
     foreach($this->obj as $val) {
       // Add Used but missing parties
       foreach ($val->acl as $i => $f) {
         if ( ! isset($this->user->parties[$i])
	      || ($this->user->parties[$i] == "") ) {
           $x = getObject($this->dbconn,$i);
           if ( $x == -1 ) {
             continue;
           }
           $pre = "";
           if ( method_exists($x,"gettype") && ($x->gettype() == "team") ) {
             $pre = $lang['team'] ." ";
           } 

           if ( method_exists($x,"getOrderedFullname") ) {
             $this->user->parties[$i] = $pre . $x->getOrderedFullname();
	   }
           else if ( method_exists($x,"getFullName") ) {
             $this->user->parties[$i] = $pre . $x->getFullName();
           }
           unset($x);
         }
       }

       if ( $val->gettype() == "user" ) {
         $ids[] = $val->uid;
       } else {
         $ids[] = $val->id;
       }
       // echo $val->getFullName() ." ". $val->id ."<br>";
     }
     $this->assign('ids', $ids);

     if (count($this->obj) == 1)
       $title = $this->obj[0]->getFullName();
     else
       $title = count($this->obj)." Objects";

     $this->assign('title', sprintf($lang['AclModifyI'], $title));
     $this->assign('ACLread',   $lang['ACLread']);
     $this->assign('ACLuse',    $lang['ACLuse']);
     $this->assign('ACLmodify', $lang['ACLmodify']);
     $this->assign('ACLdelete', $lang['ACLdelete']);

     $seeok = $this->acl_select(1, $tutos[useok]);
     $this->assign('seeok',
		   array('name'     => "r[]",
			 'options'  => $seeok[0],
			 'selected' => $seeok[1],
			 'info'     => sprintf($lang['ACLreadI'],
					       myentities($title))));

     $useok = $this->acl_select($tutos[useok],$tutos[modok]);
     $this->assign('useok',
		   array('name'     => "u[]",
			 'options'  => $useok[0],
			 'selected' => $useok[1],
			 'info'     => sprintf($lang['ACLuseI'],
					       myentities($title))));

     $modok = $this->acl_select($tutos[modok],$tutos[delok]);
     $this->assign('modok',
		   array('name'     => "m[]",
			 'options'  => $modok[0],
			 'selected' => $modok[1],
			 'info'     => sprintf($lang['ACLmodI'],
					       myentities($title))));

     $delok = $this->acl_select($tutos[delok], 99);
     $this->assign('delok',
		   array('name'     => "d[]",
			 'options'  => $delok[0],
			 'selected' => $delok[1],
			 'info'     => sprintf($lang['ACLdelI'],
					       myentities($title))));

     $this->assign('count', count($this->obj));
     $this->assign('keep',
		   array('name'  => 'keep',
			 'value' => 1,
			 'label' => $lang['ACLKeepOld']));

     $this->assign('recursive',
		   array('name'  => 'recursive',
			 'value' => 1,
			 'label' => $lang['ACLRecursive']));

     $this->assign('InputOk',   $lang['InputOk']);
     $this->assign('ChangesOk', $lang['ChangesOk']);
     $this->assign('Enter', $lang['Enter']);
     $this->assign('Reset', $lang['Reset']);

     $this->template('acl_new');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $lang,$msg,$current_user;

     $this->name = $lang['AclModify'];

     if ( ! isset($_GET['id']) ) {
       $msg .= "Missing ID";
       $this->stop = true;
       return;
     }
     $this->obj = array();

     if (! is_Array($_GET['id'])) {
       $id[0] = $_GET['id'];
     } else {
       $id = $_GET['id'];
     }
     foreach($id as $val) {
       $x = getObject($this->dbconn,$val);
       if ( $x == -1 ) {
         $msg .= sprintf($lang['Err0040'],"Object ". $val);
         $this->stop = true;
       } else if ( ! $current_user->isadmin() && ! $x->del_ok() ) {
         # we need delete permissions but talk about modify !
         $msg .= sprintf($lang['Err0024'],$lang[$x->getType()]);
         $this->stop = true;
       } else {
         $this->obj[] = &$x;
       }
       unset($x);
     }
   }
 }


 $l = new acl_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: acl_new.php,v 1.32.2.4 2004/09/30 17:09:33 tapoueh Exp $
    $Author: tapoueh $
-->