<?php
/**
 * Copyright 2001 Boris Wesslowski 
 *
 * @modulegroup BASE
 * @module acl_overview
 * @package acl
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'acl.pinc';
 include_once 'Date.pinc';
 include_once 'location.pinc';
 include_once 'mail.pinc';
 include_once 'team.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';
 include_once 'appointment.pinc';


 check_user();
 loadmodules("acl","overview");
 loadlayout();

 /**
  * show a overview of acl permissions
  */
 class acl_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;


     $query = new query($this->dbconn);

     if ( $this->type != ""  ) {
       $query->setTable($this->dbconn->prefix .$this->type);
       $query->addFld("DISTINCT id");
     } else if ( $this->xtype != ""  ) {
       $query->setTable($this->xtype);
       $query->addFld("DISTINCT id");
	 } else {
       $query->setTable($this->dbconn->prefix ."acl");
       $query->addFld("DISTINCT obj_id","id");
       $query->addWC("obj_id",0,"INT",">");
	 }
     $query->addOrder("id","ASC");
     $query->addRange($this->start,$tutos[maxshow]);

     $result = $query->runSelect();

     $n = $result->numrows();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $result->free();
       return;
     }

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }


     echo $this->actionformStart("acl_overview.php");
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo "<th>#</th><th>ID</th><th>type</th><th>object</th><th>owner</th><th>". $lang['permissions'] ."</th>\n";
     if ( $tutos[massupdate] == 1 ) {
       echo "  <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     }
     echo "</tr>\n";
     echo "</thead>\n";

     echo "<tbody>\n";
     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $g = $result->get($a, "id");
       $obj = getObject($this->dbconn,$g);
       if ( ($obj == -1) || ($obj->id == -1) || (! is_subclass_of($obj,'tutos_base')) ) {
         $a++;
         if ( $this->type == ""  ) {
           $obj = new tutos_base($this->dbconn);
		   if ($g != "") {
             $obj->id = $g;
             // delete the acl set
             acl_delete_obj($obj);
		   }
		   if ($tutos[debug] == 1) { 
            $line++;
             echo $this->OverviewRowStart($line);
             echo "<td colspan=\"".(6 + $tutos[massupdate]) ."\">removed invalid entry:". $g ."</td>";
             echo $this->OverviewRowEnd($line);
		   }
         }
		 unset($obj);
         continue;
       }
	   $n2 = count($obj->acl);
       $line++;
       echo $this->OverviewRowStart($line);
       echo "<td align=\"right\" rowspan=\"". max($n2,1) ."\">". ($a +1) ."</td>\n";
       if ( $obj != -1 ) {
         if ( $obj->getType() == "user" ) {
           echo "<td rowspan=\"". $n2 ."\">". acl_link($obj,$obj->uid) ."</td>\n";
         } else {
           echo "<td rowspan=\"". $n2 ."\">". acl_link($obj,$obj->id) ."</td>\n";
         }
         echo "<td rowspan=\"". $n2 ."\">". $lang[$obj->getType()] ."</td>\n";
         echo "<td rowspan=\"". $n2 ."\">". $obj->getLink() ."</td>\n";
       } else {
         echo "<td rowspan=\"". $n2 ."\">". $g ."</td>\n";
         echo "<td rowspan=\"". $n2 ."\">unknown</td>\n";
         echo "<td rowspan=\"". $n2 ."\">unknown</td>\n";
       }
       if ( $n2 == 0 ) {
         echo "<td colspan=\"2\">&nbsp;</td>\n";
         if ( $tutos[massupdate] == 1 ) {
           echo " <td rowspan=\"". $n2 ."\" align=\"center\">\n";
           if ( $obj->mod_ok() ) {
             echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $obj->id ."\">\n";
           } else {
             echo "-\n";
           }
           echo "</td>\n";
         }
         echo $this->OverviewRowEnd($line);
       } else {
         $b = 0;
         foreach($obj->acl as $h => $p) {
           if ( $b > 0 ) {
             echo $this->OverviewRowStart($line);
           }
           $o = getObject($this->dbconn,$h);
           if ( $o != -1 ) {
             echo "<td>". $o->getFullName() ."</td>\n";
           } else {
             if ( $h == 0 ) {
               echo "<td>". $lang['everybody'] ."</td>\n";
             } else {
               echo "<td>Unknown object ". $h ."</td>\n";
             }
           }
           echo "<td>";
           if ( $p == 1 ) {
             echo $lang['ACLread'];
           } else if ( $p == $tutos[modok] ) {
             echo $lang['ACLmodify'];
           } else if ( $p == $tutos[delok] ) {
             echo $lang['ACLdelete'];
           } else if ( $p == $tutos[useok] ) {
             echo $lang['ACLuse'];
           } else {
             echo "? (".$p.")";
           }
           echo "</td>\n";
#		echo "X |". $this->user->p[$obj->gettypeid()]."| ".$obj->gettypeid();
           if ( $b == 0 ) {
             if ( $tutos[massupdate] == 1 ) {
               echo " <td rowspan=\"". $n2 ."\" align=\"center\">";
               if ( method_exists($obj,"mod_ok") &&  $obj->mod_ok() ) {
                 if ( $obj->getType() == "user" ) {
                   echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $obj->uid ."\">\n";
                 } else {
                   echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $obj->id ."\">\n";
                 }
               } else {
                 echo "&nbsp;-&nbsp;";
               }
               echo "</td>\n";
             }
           }
           echo $this->OverviewRowEnd($line);
		   unset($o);
           $b++;
         }
       }
       $a++;
       unset($obj);
     }
     echo "</tbody>\n";

     echo "<tfoot>\n";
     echo $this->list_navigation($this->link1,6+ $tutos[massupdate],$this->start,$a,$n);

     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart(5);
       echo sprintf($lang['withmarked'],"");
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option value=\"-2\">". $lang['Delete'] ." Objects</option>\n";
       echo " <option value=\"-4\">". $lang['AclModify'] ."</option>\n";
       echo "</select>\n";
       echo $this->UpdateRowEnd(2);
     }

     echo "</tfoot>\n";
     echo $this->OverviewTableEnd();
     echo $this->actionformEnd("acl_overview.php");
     $result->free();
   }
   /**
    * navigate
    */
   Function navigate() {
     global $lang,$tutos;

     echo "<tr><td>\n";
     echo "<span class=\"nodeco\">".$lang['show'] ."</span><br><ul>\n";
     echo "<li>". menulink("acl_overview.php",$lang['AppEverything'],$lang['AppEverything']) ."</li>\n";
     echo "<li>". menulink("acl_overview.php?type=addresses",$lang['Address'],$lang['Address']) ."</li>\n";
     echo "<li>". menulink("acl_overview.php?type=location",$lang['Location'],$lang['Location']) ."</li>\n";
     echo "<li>". menulink("acl_overview.php?type=calendar",$lang['Appointments'],$lang['Appointments']) ."</li>\n";
     echo "<li>". menulink("acl_overview.php?type=tasks",$lang['Tasks'],$lang['Tasks']) ."</li>\n";
     echo "<li>". menulink("acl_overview.php?type=people",$lang['User'],$lang['User']) ."</li>\n";
     echo "<li>". menulink("acl_overview.php?type=teams",$lang['Teams'],$lang['Teams']) ."</li>\n";
     echo "<li>". menulink("acl_overview.php?type=companies",$lang['Company'],$lang['Company']) ."</li>\n";
     echo "<li>". menulink("acl_overview.php?type=departments",$lang['Departments'],$lang['Departments']) ."</li>\n";
     echo "<li>". menulink("acl_overview.php?type=products",$lang['ProductPs'],$lang['ProductPs']) ."</li>\n";
     echo "<li>". menulink("acl_overview.php?type=tutos_dbs",$lang['DB'],$lang['DB']) ."</li>\n";
     foreach($tutos[modules] as $r => $x) {
       $ref = new $x[name]($this->user->dbconn);
       if ( isset($lang[$ref->getType()]) ) {
         echo "<li>". menulink("acl_overview.php?xtype=". $ref->tablename,$lang[$ref->getType()],$lang[$ref->getType()]) ."</li>\n";
       }
     }
     echo "</ul></td></tr>\n";
   }
   /**
    * action
    */
   Function action() {
     global $msg,$lang;

     @reset($_GET['mark']);
     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $b = getObject($this->dbconn,$val);
		 if ( ! is_subclass_of($b,'tutos_base') ) {
           $msg .= "Unknown object: ". $val;
           continue;
		 }
         if ( $b->id != $val ) {
           continue;
         }
         if ( method_exists($b,"del_ok") && method_exists($b,"delete") &&  $b->del_ok() ) {
           $msg .= $lang['Delete'] .":&nbsp;". $lang[$b->getType()] ." ". $b->getFullName() ."<br>";
           $msg .= $b->delete();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0023'],$lang[$b->getType()]);
         }
         unset($b);
       }
       $this->dbconn->Commit("WORK");
     } else if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
     }
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;

     $this->name = $lang['ACLOverview'];
     $this->link1 = "acl_overview.php";
     $this->type = "";
     $this->xtype = "";

     # read the table definitions of modules
     @reset($tutos[modules]);
     while ( list ($r,$x) = @each ($tutos[modules])) {
       loadmodule($r);
     }
     if ( isset($_GET['type']) && ($_GET['type'] != "") ) {
       $this->type = $_GET['type'];
       $this->link1 = addUrlParameter($this->link1,"type=".UrlEncode($this->type));
       $this->addHidden("type",$this->type);
     }
     if ( isset($_GET['xtype']) && ($_GET['xtype'] != "") ) {
       $this->xtype = $_GET['xtype'];
       $this->link1 = addUrlParameter($this->link1,"xtype=".UrlEncode($this->xtype));
       $this->addHidden("xtype",$this->xtype);
     }
     if ( isset($_GET['start']) && ($_GET['start'] != "") ) {
       $this->addHidden("start",$_GET['start']);
	 }
     if ( isset($_GET['maxshow']) && ($_GET['maxshow'] != "") ) {
       $tutos[maxshow] = $_GET['maxshow'];
       $this->addHidden("maxshow",$_GET['maxshow']);
       $this->link1 = addUrlParameter($this->link1,"maxshow=".$_GET['maxshow']);
	 }
     if ( $this->user->admin == 0) {
       $msg .= sprintf($lang['Err0022'],$lang['ACLOverview']);
       $this->stop = true;
       return;
     }
   }
 }

 $l = new acl_overview($current_user);
 $l->display();
 $dbconn->close();
?>
<!--
    CVS Info:  $Id: acl_overview.php,v 1.45 2004/02/11 14:47:54 schueler Exp $
    $Author: schueler $
-->
