<?php
/**
 * Copyright 1999 - 2001 by Gero Kohnert
 */
 include("webelements.p3");
 include("permission.p3");

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("database","overview");
 loadlayout();

 /**
  * show a overview of databases
  */
 class database_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $result = $this->dbconn->Exec($this->q);
     $n = $result->numrows();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $result->free();
       return;
     }
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo $this->orderHeader("dbalias",$lang['AdminDBAlias'],$this->link2);
     echo $this->orderHeader("name",$lang['AdminDBName'],$this->link2);
     echo $this->orderHeader("prefix",$lang['AdminDBPrefix'],$this->link2);
     echo $this->orderHeader("dbhost",$lang['AdminDBHost'],$this->link2);
     echo $this->orderHeader("dbtype",$lang['AdminDBType'],$this->link2);
     echo "</tr>\n";
     echo "</thead>\n";

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     echo "<tbody>\n";
     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $c = new database($this->dbconn);
       $c->read_result($result,$a);
       $a++;
       if ( ! $c->see_ok() ) {
         continue;
       }

       echo $this->OverviewRowStart($line);
       echo "<td valign=\"top\">". $c->alias ."&nbsp;</td>";
       echo "<td valign=\"top\">". $c->getLink($c->name) ."</td>";
       echo "<td valign=\"top\">". $c->prefix ."&nbsp;</td>";
       echo "<td valign=\"top\">". $c->host ."&nbsp;</td>";
       echo "<td valign=\"top\">". $c->tlist[$c->type] ."</td>";
       echo $this->OverviewRowEnd($line++);
	   unset($c);
     }
     echo "</tbody>\n";

     echo $this->list_navigation($this->link1,4,$this->start,$a,$n);
     echo $this->OverviewTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['DBOverview'];
     $this->link1 = "database_overview.php";
     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."tutos_dbs";
     $pre = " WHERE ";

     if ( isset($_GET['name']) && ($_GET['name'] != "*") && ($_GET['name'] != "") ) {
       $this->q .= $pre . $this->dbconn->Like("name",$_GET['name']);
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($_GET['name']));
     }

     check_dbacl( $this->q, $this->user->id);

     # sorting
     $xxx = "";
     $this->link2 = $this->link1;
     order_parse($this->q,$this->link1,$xxx,$xxx,"name");

     if ( $this->user->isadmin() ) {
       $x = array( url => "database_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['DBCreate'],
                   category => array("database","new","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new database_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: database_overview.php,v 1.21 2003/08/19 15:55:40 gokohnert Exp $
    $Author: gokohnert $
-->
