<?php
/**
 * Copyright 2001 Boris Wesslowski
 *
 * @modulegroup BASE
 * @module message_overview
 * @package ADMIN
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 check_user();
 loadmodules("message","overview");
 loadlayout();

 /**
  * show a overview of messages
  */
 class message_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $query = "SELECT * FROM ". $this->dbconn->prefix ."messages ORDER by ts";
#	 $query = "select x.* from (". $query . ") as x limit ". $tutos[maxshow] .",0";
     $result = $this->dbconn->Exec($query);

     $n = $result->numrows();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $result->free();
       return;
     }

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo "<th>Timestamp</th><th>Message</th>\n";
     echo "</tr>\n";
     echo "</thead>\n";

     echo "<tbody>\n";
	 $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       echo $this->OverviewRowStart($line);
       echo " <td>". $result->get($a, "ts") ."</td>\n";
       echo " <td>". $result->get($a, "message") ."</td>\n";
       echo $this->OverviewRowEnd($line++);
       $a++;
     }
     echo "</tbody>\n";
     echo "<tfoot>\n";
     echo $this->list_navigation($this->link1,2,$this->start,$a,$n);
     echo "</tfoot>\n";
     echo $this->OverviewTableEnd();
     $result->free();
   }
   /**
	* naviagte
	*/
   Function navigate() {
     global $lang;

     echo "<tr><td>\n";
     if ( ($this->user->admin == 1) ) {
       echo menulink("message_del.php","Delete messages","Delete all messages");
     }
     echo "</td></tr>";
   }
   /**
	* prepare
	*/
   Function prepare() {
     global $lang,$msg;

     $this->name = "Messages";
     $this->link1 = "message_overview.php";

     if ( ! $this->user->isadmin()) {
       $msg .= "Only admins are allowed to see this";
       $this->stop = true;
     }
   }
 }

 $l = new message_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: message_overview.php,v 1.18 2002/12/23 10:01:35 gokohnert Exp $
    $Author: gokohnert $
-->
