<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 */
include_once 'webelements.p3';
include_once 'permission.p3';

include_once 'layout/layout.pinc';

/* Check if user is allowed to use it */
check_user();
session_write_close();


class minical extends layout {
  function info() {
    global $lang, $current_user;

    $this->assign('f', $this->f);

    // Years are showed up sorted ASC and begins 5 years before now
    // See layout.pinc :: assign_date if you want to change that value.
    $yoff =  Date("Y") - 5;
    $nm = $this->m + 1;
    $ny = $this->y;
    if ( $nm == 13 ) {
      $nm = 1;
      $ny = $this->y + 1;
    }
    $lm = $this->m - 1;
    $ly = $this->y;
    if ( $lm == 0 ) {
      $lm = 12;
      $ly = $this->y -1;
    }

    $this->assign('self', $_SERVER['PHP_SELF']);
    $this->assign('NavBack', $lang['NavBack']);
    $this->assign('NavNext', $lang['NavNext']);
    $this->assign('week', $lang['week']);

    $this->assign('n', $this->n);
    $this->assign('d', $this->d);
    $this->assign('m', $this->m);
    $this->assign('y', $this->y);
    $this->assign('lm', $lm);
    $this->assign('ly', $ly);
    $this->assign('nm', $nm);
    $this->assign('ny', $ny);

    $WeekDayName = array('SSunday', 'SMonday', 'STuesday',
			 'SWednesday', 'SThursday', 'SFriday', 'SSaturday');

    $wdays = array();
    for( $i = $current_user->weekstart; $i<=6; $i++ ) { 
      $wdays[] = $lang[$WeekDayName[$i]];
    }
    for( $i = 0; $i<$current_user->weekstart; $i++ ) {
      $wdays[] = $lang[$WeekDayName[$i]];
    }
    $this->assign('wdays', $wdays);

    $ts = mktime(12,0,0,$this->m,1,$this->y);

    $today=Date("Ymd",time());

    // Back to last weekstart before ts
    while( Date("w", $ts) != $current_user->weekstart ) {
      $ts -= 86400;
    }

    $weeks = array();

    $go = 1;
    $a = 0;
    $w = 0;
    while ( $go == 1 ) {
      $wd = Date("w",$ts);
      $xd = Date("j",$ts);
      $xxd = Date("d",$ts);
      $xm = Date("n",$ts);
      $xy = Date("Y",$ts);
      if ( $wd == $current_user->weekstart ) {
	// new week
	$w0 =  (( 1 + Date("w",mktime(12,0,0,1,1, Date("Y",$ts) ) )) % 7) > 3;
	$wn = sprintf("%02d", Round( (Date("z",$ts)+7 ) / 7) );

	$week = array();
	$week['wn'] = $wn;
	$week['days'] = array();
      }

      $col = "";
      if ( $today == Date("Ymd",$ts) ) {
	$col = "today";
      } else if ($xm != $this->m ) {
	$col = "appday";
      } else if ($wd == 0 ) {
	$col = "holiday";
      } 

      // Years offset :  years are sorted ASC
      $week['days'][] = array('col' => $col,
			      'd'   => $xd + $this->n,
			      'm'   => $xm + $this->n,
			      'y'   => $xy - $yoff - $this->n,
			      'val' => $xxd);

      if ( $wd == ($current_user->weekstart+6)%7   ) {
	// end week
	$weeks[] = $week;
	$week = array();
	if ( ($xm > $this->m) || ($xy > $this->y)  ) {
	  break;
	}
      }
      $a++;
      $w++;
      $ts += 86400;
    }

    if ( $this->n == 1 ) {
      // echo "<tr><th colspan=\"8\"><a class=\"nodeco\" href=\"JavaScript:noneandaway()\">NONE</a></th></tr>";
    }
    $this->assign('weeks', $weeks);

    $this->template('minical');
  }

  function prepare() {
    $this->d = Date("d");
    $this->m = Date("n");
    $this->y = Date("Y");
    $this->f = "default";

    if (isset($_GET['f']) ) {
      $this->f = $_GET['f'];
    }
    if (isset($_GET['d']) ) {
      $this->d = $_GET['d'];
    }
    if (isset($_GET['m']) ) {
      $this->m = $_GET['m'];
    }
    if (isset($_GET['y']) ) {
      $this->y = $_GET['y'];
    }
    if (isset($_GET['n']) ) {
      $this->n = $_GET['n'];
    }

    if ( $this->d == -1 ) {
      $this->d = Date("d");
    }
    if ( $this->m == -1 ) {
      $this->m = Date("n");
    }
    if ( $this->y == -1 ) {
      $this->y = Date("Y");
    }
  }
}

$l = new minical($current_user);
//$l->PrintHeader("MiniCal");
$l->display($withmenu = False);


?>
<!--
    CVS Info:  $Id: minical.php,v 1.20.2.4 2004/09/01 16:44:53 tapoueh Exp $
    $Author: tapoueh $
-->
