<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 * cloning option added by Michal Salaban, 2003
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup product
 * @module product_role_ins
 * @package product
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','ins');

 $gotourl = "product_role_new.php";
 $msg = "";
 $mods = 0;
 $template = false;

 $p = new product($dbconn);
 if ( isset($_POST['id']) ) {
   $p->read($_POST['id']);
   $p->readroles();
   $gotourl= addUrlParameter($gotourl,"id=". $_POST['id'],true);
 } else {
   $p->id = -1;
   $p->creator = $current_user;
 }

 # Delete given Roles
 if ( isset($_POST['del']) ) {
   @reset ($_POST['del']);
   while( list ($i,$f) = @each ($_POST['del'])) {
     ereg ("([0-9]*),([0-9]*)",$f,$regs);
     $m = getObject($dbconn,$regs[1]);
     $p->delRole($m,$regs[2]);
     $gotourl= addUrlParameter($gotourl,"del[]=". $f,true);
   }
 }

 # Add given People Role

 $nbadd = $_POST['nbadd'];

for($i=1; $i<=$nbadd; $i++) {
  $rid   = 'r'.$i.'id';
  $fn    = 'r'.$i.'fn';
  $l     = 'r'.$i.'l';
  $role  = 'role'.$i;
  $rdesc = 'r'.$i.'desc';

 if ( isset($_POST[$fn]) ) {
   $m = check_field(StripSlashes($_POST[$fn]), $fn, $l,
		    $tutos[rolecheck][$_POST[$role]]);

   if ( $m->id > 0 ) {
     $p->setRole($m,$_POST[$role], StripSlashes($_POST[$rdesc]));
   }
 }
 if ( isset($_POST[$rid]) ) {
   $m = getObject($dbconn, $_POST[$rid]);
   $p->setRole($m, $_POST[$role], StripSlashes($_POST[$rdesc]));
 }
 $gotourl= addUrlParameter($gotourl, $role."=". $_POST[$role], true);
 $gotourl= addUrlParameter($gotourl,
			   $rdesc."=".UrlEncode($_POST[$rdesc]),true);
}

 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   // $msg .= $p->save();
   $msg .= $p->saveroles();
   $dbconn->Commit("WORK");

   # we want to see what we create
   $gotourl = $p->getUrl();
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: product_role_ins.php,v 1.2.2.1 2005/04/07 16:43:24 tapoueh Exp $
  *  $Author: tapoueh $
  */
?>