<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 *  CVS Info:  $Id: timetrack_ins.php,v 1.42.2.3 2004/10/05 12:38:22 tapoueh Exp $
 *  $Author: tapoueh $
 *
 * @modulegroup timetrack
 * @module timetrack_ins
 * @package timetrack
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';
 include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("timetrack","ins");

 /* Check Input */
 $msg = "";
 $mode = 0;
 $tt = new timetrack($dbconn);


 if ( isset($_POST['gotourl']) ) {
   $gotourl = $_POST['gotourl'];
 } else {
   $gotourl = "timetrack_new.php";
 }
 if ( isset($_POST['mode']) ) {
   $mode = $_POST['mode'];
   $gotourl= addUrlParameter($gotourl,"mode=". $mode,true);
 }
 if ( isset($_POST['id']) ) {
   $tt->read($_POST['id']);
   $gotourl= addUrlParameter($gotourl,"id=". $tt->id,true);
 } else {
   $tt->creator = $current_user;
 }
 
 # reference
 if ( isset($_POST['lfn']) ) {
   if ( empty($_POST['lfn']) ) {
     $msg .= sprintf($lang['Err0009'],$lang['TimetrackRef']) ."<br>";
   } else {
     $x = check_field(StripSlashes($_POST['lfn']),"lfn","ll","api");   // api: address, product, installation
     $tt->setReference($x->id);
     $tt->ref = getObject($dbconn,$tt->link_id);
     $gotourl= addUrlParameter($gotourl,"lid=". $x->id,true);
   }
 } else if ( isset($_POST['lid']) ) {
   $tt->setReference($_POST['lid']);
   $tt->ref = getObject($dbconn,$tt->link_id);
   $gotourl= addUrlParameter($gotourl,"lid=". $_POST['lid'],true);
 }
 # worker
 if ( isset($_POST['wfn']) ) {
   if ( empty($_POST['wfn']) ) {
     $msg .= sprintf($lang['Err0009'],$lang['TimetrackWorker']) ."<br>";
   } else {
     $x = check_field(StripSlashes($_POST['wfn']),"wfn","wl","a");
     $tt->setWorker($x->id);
     $gotourl= addUrlParameter($gotourl,"wid=". $x->id,true);
   }
 } else if ( isset($_POST['wid']) ) {
   $tt->setWorker($_POST['wid']);
   $gotourl= addUrlParameter($gotourl,"wid=". $_POST['wid'],true);
 }
 # description
 if ( empty($_POST['desc'])  ) {
   $msg .= sprintf($lang['Err0009'],$lang['Description']) ."<br>";
 } else {
   if ( isset($_POST['desc']) ) {
     $tt->setDescription(StripSlashes($_POST['desc']));
     $gotourl= addUrlParameter($gotourl,"desc=". UrlEncode($tt->desc),true);
   }
 }
 # state
 if ( isset($_POST['state']) ) {
   $tt->setState($_POST['state']);
   $gotourl= addUrlParameter($gotourl,"state=". UrlEncode($tt->state),true);
 }

 # Read the Work Day
 $wd = new DateTime(0);
 if ( isset($_POST['wd_d']) ) {
   $wd->setDateTimeF("wd",1);
   if ( !$wd->checkDMY() ) {
     $msg .= sprintf($lang['Err0038'],$lang['Date']) ."<br>";
   } else {
     $gotourl= addUrlParameter($gotourl,"wd=". $wd->getYYYYMMDD(),true);
   }
   $tt->setWorkday($wd);
 }

 if ( isset($_POST['start_d']) ) {
   $start = new DateTime();
   $start->setDateTimeF("start",0);
   if ( !$start->checkDMY() ) {
     $msg .= sprintf($lang['Err0038'],$lang['AppStart']) ."<br>";
   } else {
    $gotourl= addUrlParameter($gotourl,"start=". $start->getYYYYMMDDHHMM(),true);
   }
   $tt->setStart($start);
 }
 if ( isset($_POST['end_d']) ) {
   $end   = new DateTime();
   $end->setDateTimeF("end",0);
   if ( !$end->checkDMY(true) ) {
     $msg .= sprintf($lang['Err0038'],$lang['AppEnd']) ."<br>";
   } else {
     $gotourl= addUrlParameter($gotourl,"end=". $end->getYYYYMMDDHHMM(),true);
   }
   $tt->setEnd($end);
   if ( $tt->t_end->notime == 0 ) {
     $tt->setVolume( ($tt->t_end->getTimeStamp() - $tt->t_start->getTimeStamp()) / 3600.0);
   }
 }

 # volume
 if ( $tt->t_start->notime == 1 ) {
   if ( !checkfloat($_POST['volume'],false) ) {
     $msg .= sprintf($lang['Err0009'],$lang['TaskVolumeDone']) ."<br>";
   }
   else {
     $volume = $_POST['volume'];
     $gotourl= addUrlParameter($gotourl, "volume=". UrlEncode($volume), true);
     $tt->setVolume($volume);
   }
 }

// volume todo, for tasks
if( $tt->ref->getType() == "task" ) {
  if(isset($_POST['calc_volume_todo'])
     && $_POST['calc_volume_todo'] == 'on' ) {
    // User want us to calculate volume done based on given volume and
    // volume_todo

    if (isset($tt->ref->volume_todo) && ($tt->ref->volume_todo != -1) )
      $ref_todo = $tt->ref->volume_todo;
    else
      $ref_todo = $tt->ref->volume - $tt->ref->volume_done;

    // And the calculated volume_todo is the volume todo before this
    // timetrack entry, minus this timetrack entry volume...
    if( $ref_todo > $volume )
      $volume_todo = $ref_todo - $volume;
    else
      $volume_todo = 0;

    $tt->setVolumeTodo($volume_todo);
  }
  else {
    if ( isset($_POST['volume_todo']) && $_POST['volume_todo'] != "" )
      $gotourl = addUrlParameter($gotourl,
				 "volume_todo=".
				 UrlEncode($_POST['volume_todo']),
				 true);

    if ( !checkfloat($_POST['volume_todo'], false) ) {
      $msg .= sprintf($lang['Err0009'],$lang['TaskVolumeTodo']) ."<br>";
    }
    else {
      $tt->setVolumeTodo($_POST['volume_todo']);
    }
  }
}

 if ( !checkfloat($_POST['cph'],true) ) {
   $msg .= sprintf($lang['Err0017'],$lang['TTcph']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"cph=". UrlEncode($_POST['cph']),true);
   $tt->setCph($_POST['cph']);
 }
 # currency
 if ( isset($_POST['currency']) ) {
   $tt->setCurrency($_POST['currency']);
   $gotourl= addUrlParameter($gotourl,"currency=". UrlEncode($tt->currency),true);
 }

 # other modules
 $msg .= module_parseforms($current_user,$tt,$gotourl);

 if ( $msg == "" ) {
   $newobj = $tt->id<0;     
   $dbconn->Begin("WORK");
   $msg .= $tt->save();
   $dbconn->Commit("WORK");
   $gotourl = $tt->ref->getUrl();
#   $gotourl = web_StackPop($newobj?2:2);
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
?>