<?php
/**
 * Copyright 2003 by Gero Kohnert
 *
 * @modulegroup xml
 * @module xml_new
 * @package xml
 *
 * Interface for importing XML data to TUTOS
 *
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("xmlimport","new");
 loadmodule("xmlimport");
 loadlayout();

 /**
  * change/modify a note
  */
 class xml_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang,$tutos,$table;

     echo "<form name=\"xmlnew\" enctype=\"multipart/form-data\" action=\"xml_ins.php\" method=\"POST\">\n";
     echo $this->DataTableStart();

	 if (isset($_GET['XML'])) {
       echo "<tr>\n";
       echo $this->showfield($lang['XMLoutput'],0);
       echo " <td colspan=\"5\"><pre>". UrlDecode($_SESSION['XML']) ."</pre></td>\n";
       echo "</tr>\n";
     }
     echo "<tr><th colspan=\"6\">";
     echo $lang['XMLimport'];
     echo " </th></tr>\n";

     echo "<tr>\n";
     echo " <td colspan=\"6\">Select one of the three alternatives to transfer data</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['XMLtestonly'],0,"testonly");
     echo " <td colspan=\"5\"><input id=\"testonly\" name=\"testonly\" type=\"checkbox\" value=\"1\"". ($this->testonly == 1 ? "checked":"" )."></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['XMLanswer'],"xml","format");
     echo " <td colspan=\"5\"><input id=\"format\" name=\"format\" type=\"checkbox\" value=\"xml\"". ($this->format == "xml" ? "checked":"" )."></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['XMLFile'],0,"datafile");
     echo " <td colspan=\"5\"><input id=\"datafile\" size=\"40\" name=\"datafile\" type=\"file\" value=\"". $this->datafile ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['XMLUrl'],0,"dataurl");
     echo " <td colspan=\"5\"><input id=\"dataurl\" size=\"100\" maxlength=\"100\" name=\"dataurl\" value=\"". myentities($this->dataurl) ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['XMLData'],0,"data");
     echo " <td colspan=\"5\"><textarea id=\"data\"  rows=\"20\" cols=\"80\" name=\"data\">". $this->data ."</textarea></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     submit_reset(0,-1,2,1,2,0);
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
 
     echo $this->setfocus("xmlnew.data");
     echo $lang['FldsRequired'] ."\n";


   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['XMLimport'];
     $this->dataurl = "";
     $this->datafile = "";
     $this->data = "";
     $this->testonly = 1;

     if ( isset($_GET['testonly']) ){
       $this->testonly = StripSlashes($_GET['testonly']);
     } else {
       $this->testonly = 0;
	 }
     if ( isset($_GET['dataurl']) ){
       $this->dataurl = StripSlashes($_GET['dataurl']);
     }
     if ( isset($_GET['datafile']) ){
       $this->datafile = StripSlashes($_GET['datafile']);
     }
     if ( isset($_GET['data']) ){
       $this->data = StripSlashes($_GET['data']);
     }
   }
 }

 $l = new xml_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: xml_new.php,v 1.3 2004/02/04 19:50:54 schueler Exp $
    $Author: schueler $
-->