/*
 * tux.h - tuXeyes figure definition for tux
 * Copyright (C) 1999 Ivo van der Wijk
 *
 * The tux image is (c) Larry Ewing (lewing@isc.tamu.edu)
 * The dustpuppy image is (c) Illiad (http://www.userfriendly.org)
 * The bsd daemon ("Chuck") is (c) Eric Green
 * The luxus image is (c) Urs M. E. Streidl (http://www.gigaperls.org/linux/)
 * 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Pixmaps/images are copyrighted by Larry Ewing.
 * Look at http://www.isc.tamu.edu/~lewing/linux/ for more tux images.
 */
#ifndef TUX_H
#define TUX_H

#include <qapplication.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>

#include "figure.h"

/*
 * Include pixmaps. Masks will be converted to bitmaps
 */
#include "tux/tux_no_pupils.xpm"
#include "tux/tux_mask.xpm"
#include "tux/leftpupil.xpm"
#include "tux/rightpupil.xpm"
#include "tux/tux_eyes.xpm"
#include "tux/tux_eyes_mask.xpm"

class	tux: public figure
{
public:
	tux(): figure()
	{
		loadImage(tuxOrig, tux_no_pupils);
		loadImage(tuxMaskXPM, tux_mask);
		loadImage(leftPupilOrig, leftpupil);
		loadImage(rightPupilOrig, rightpupil);
		loadImage(eyeRegionOrig, tux_eyes);
		loadImage(eyeMaskXPM, tux_eyes_mask);

		// these values have to determined by examining the picture
		leftEyeX = 104;
		leftEyeY = 62;
		rightEyeX = 139;
		rightEyeY = 61;
		leftPupilRadius = 7;
		rightPupilRadius = 9;
		eyeXOffset = 80;
		eyeYOffset = 42;
	}
	~tux() {}
private:
};

#endif // TUX_H
