<?php

if( !$included["lib/ldap/php-ldap.inc.php3"] )
	{ $included["lib/ldap/php-ldap.inc.php3"] = 1;

	include( "config/ldapconfig.inc.php3" );

 	Function ldapSetSource( $source )
		{
		// Change the current source, returning just a true or false
		if( ldapGetLink( "source", $source ) )
			{
			return true;
			// The source has been set
			}
		else
			{
			return false;
			// The source has not been set
			}
		}

 	Function ldapGetLink( $info = "", $source = "" )
		{
		Static $links, $old_source;
		Global $ldapconfig;
		// this function should only be used locally!
	
		// $source is the name of the config variable
		// that holds an array of the hostname, port, bind dn, and password
	
		// return the link identifier of the connection to $source,
	
		if( !$source )
			{
			// No source given, so assume the last accessed source
			$source = $old_source;
			}
		else
			{
			// New source give, update the last access cache
			$old_source = $source;
			}

		if( $info == "basedn" )
			{
			if( is_array( $ldapconfig[$source] ) )
				{
				return $ldapconfig[$source]["basedn"];
				}
			else
				{
				TWIGPrintError( "LDAP source not defined: " . $source );
				return false;
				}
			}
		
		if( isset( $links[$source] ) )
			{
			// We already have this one cached, just spit it back
			return $links[$source];
			}
		else
			{
			// It is not cached, so we have to connect up
			if( is_array( $ldapconfig[$source] ) )
				{
				if( $link = @ldap_connect( $ldapconfig[$source]["hostname"], $ldapconfig[$source]["port"] ) )
					{
					if( @ldap_bind( $link, $ldapconfig[$source]["binddn"], $ldapconfig[$source]["password"] ) )
						{
						$links[$source] = $link;
						return $link;
						}
					else
						{
						if( @ldap_errno( $link ) )
							{
							TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
							}
						return false;
						}
					}
				else
					{
					if( @ldap_errno( $link ) )
						{
						TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
						}
					return false;
					}
				}
			else
				{
				TWIGPrintError( "LDAP source not defined: " . $source );
				return false;
				}
			}
		}
	
 	Function ldapQuery( $type, $dn1, $dn2 = "", $entry = "" )
		{
		// Calling conventions:

		// reading searching and stuff...
		// ldapQuery( "search", "(&ldapfilter=*)", array( fields, to, return ) );
		// ldapQuery( "list", $basedn=ldapGetLink( "basedn" ), "(&ldapfilter=*)", array( fields, to, return ) );
		// ldapQuery( "read", $basedn=ldapGetLink( "basedn" ), "(&ldapfilter=*)", array( fields, to, return ) );

		// writing and deleting and stuff...
		// ldapQuery( "add", $dn, array( fields=>values ) );
		// ldapQuery( "modify", $dn, array( fields=>values ) );
		// ldapQuery( "remove", $dn, array( fields ) );
		// ldapQuery( "delete", $dn );

		$link = ldapGetLink();
		if( !$link )
			{
			TWIGPrintError( "Could not get an LDAP link!" );
			return false;
			}
		$basedn = ldapGetLink( "basedn" );

		switch( strtoupper( $type ) )
			{
			case "SEARCH":
				// here, $dn1 is the filter, $dn2 are fields
				if( is_array( $dn2 ) )
					{
					$result = @ldap_search( $link, $basedn, $dn1, $dn2 );
					}
				else
					{
					$result = @ldap_search( $link, $basedn, $dn1 );
					}

				if( @ldap_errno( $link ) )
					{
					TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
					}
	
				return $result;
				break;
			case "LIST":
				// here, $dn is the filter, $entry are fields
				if( $dn1 )
					{
					$basedn = $dn1;
					}
				$search = $dn2;
				if( is_array( $entry ) )
					{
					$result = @ldap_list( $link, $basedn, $search, $entry );
					}
				else
					{
					$result = @ldap_list( $link, $basedn, $search );
					}
				
				if( @ldap_errno( $link ) )
					{
					TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
					}
	
				return $result;
				break;
			case "READ":
				// here, $dn is the filter, $entry are fields
				if( $dn1 )
					{
					$basedn = $dn1;
					}
				if( $dn2 )
					{
					$search = $dn2;
					}
				else
					{
					$search = "objectClass=*";
					}
				if( is_array( $entry ) )
					{
					$result = @ldap_read( $link, $basedn, $search, $entry );
					}
				else
					{
					$result = @ldap_read( $link, $basedn, $search );
					}
				
				if( @ldap_errno( $link ) )
					{
					TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
					}
	
				return $result;
				break;
			case "ADD":
				$result = @ldap_add( $link, $dn, $entry );
				
				if( @ldap_errno( $link ) )
					{
					TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
					}
	
				return $result;
				break;
			case "MODIFY":
				$result = @ldap_modify( $link, $dn1, $dn2 );
				
				if( @ldap_errno( $link ) )
					{
					TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
					}
	
				return $result;
				break;
			case "REMOVE":
				$result = @ldap_mod_del( $link, $dn1, $dn2 );
				
				if( @ldap_errno( $link ) )
					{
					TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
					}
	
				return $result;
				break;
			case "DELETE":
				$result = @ldap_delete( $link, $dn );
				
				if( @ldap_errno( $link ) )
					{
					TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
					}
	
				return $result;
				break;
			default:
				return false;
				break;
			}
		}
	
 	Function ldapNumRows( $result )
		{
		$link = ldapGetLink();
		if( !$link ) { return false; }

		$count = @ldap_count_entries( $link, $result );
	
		if( @ldap_errno( $link ) )
			{
			TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
			}
	
		return $count;
		}
	
	/*
	// This is the old version, which uses ldap_get_entries to get all data
 	Function ldapResultArray( $result, $i )
		{
		Static $old_result, $old_data;

		$link = ldapGetLink();
		if( !$link ) { return false; }

		if( $result == $old_result )
			{
			return $old_data[$i];
			}
		else
			{
			$data = @ldap_get_entries( $link, $result );
				
			if( @ldap_errno( $link ) )
				{
				TWIGPrintError( @ldap_err2str( @ldap_errno( $link ) ) );
				}
	
			$old_result = $result;
			$old_data = $data;
			return $data[$i];
			}
		}
	*/

	// This is the new version, which gets data only as required
 	Function ldapResultArray( $result, $i )
		{
		Static $old_result, $old_data, $next_result;

		$link = ldapGetLink();
		if( !$link ) { return false; }

		if( $result == $old_result )
			{
			if( isset( $old_data[$i] ) )
				{
				return $old_data[$i];
				}
			elseif( isset( $old_data[0] ) )
				{
				for( $k = count( $old_data ) - 1, $j = ldapNumRows( $result ); $i > $k && $i < $j; $k++ ) 
					{
					$next_result = @ldap_next_entry( $link, $next_result );
					$fdata = @ldap_get_attributes( $link, $next_result );
					while( list( $key, $val ) = each( $fdata ) )
						{
						$data[strtolower($key)] = $val;
						}
					$data["dn"] = @ldap_get_dn( $link, $next_result );
					// $data = @ldap_get_values( $link, $next_result );
					$old_data[] = $data;
					}
				return $old_data[$i];
				}
			else
				{
				$next_result = @ldap_first_entry( $link, $result );
				$fdata = @ldap_get_attributes( $link, $next_result );
				while( list( $key, $val ) = each( $fdata ) )
					{
					$data[strtolower($key)] = $val;
					}
				$data["dn"] = @ldap_get_dn( $link, $next_result );
				// $data = @ldap_get_values( $link, $next_result );
				$old_data[0] = $data;
				}
			}
		else
			{
			$old_data = array();
			$old_result = $result;

			$next_result = @ldap_first_entry( $link, $result );
			$fdata = @ldap_get_attributes( $link, $next_result );
			while( list( $key, $val ) = each( $fdata ) )
				{
				$data[strtolower($key)] = $val;
				}
			$data["dn"] = @ldap_get_dn( $link, $next_result );
			// $data = @ldap_get_values( $link, $next_result );
			$old_data[0] = $data;

			for( $k = 0, $j = ldapNumRows( $result ); $i > $k && $i < $j; $k++ ) 
				{
				$next_result = @ldap_next_entry( $link, $next_result );
				$fdata = @ldap_get_attributes( $link, $next_result );
				while( list( $key, $val ) = each( $fdata ) )
					{
					$data[strtolower($key)] = $val;
					}
				$data["dn"] = @ldap_get_dn( $link, $next_result );
				// $data = @ldap_get_values( $link, $next_result );
				$old_data[] = $data;
				}

			return $old_data[$i];
			}
		}

 	Function ldapMayBeArray( $data, $none = "[none]", $item = "<br>" )
  		{
		if( is_array( $data ) )
    	  		{
 	       		for( $i = 0, $j = $data["count"]; $i < $j; $i++ )
 	       			{
				if( $item && $i > 0 )
					{
					// For subsequent data, put $item as the separator
					$ret .= $item;
					}
				elseif( !$item )
					{
					// So if $item is false, only show the last element
					if( $i = $j - 1 )
 			       			$ret .= $data[$i];
					}
				else
					{
 		       			$ret .= $data[$i];
					}
	 	       		}
	 	       	}
		else
			{
			$ret = $data;
			}
 
		if( !$ret )
			{
			if( $none == "[none]" )
				{
				$none = TWIGPhrase( "[none]" );
				}
			$ret = $none;
			}
 
		return $ret;
		}

	Function ldapBackToDN( $dn, $backlevels  = 1 )
		{
		// This function takes an LDAP dn and removes $backlevels number of components
		// from the front of the dn (ie starting with the lowest component)
		$dnarray = explode( ",", $dn );
		$dncount = count( $dnarray );

		if( $backlevels > $dncount ) { $backlevels = $dncount; }

		for( $i = $backlevels, $j = $dncount; $i < $j; $i++ )
			{
			if( $i != $backlevels ) { $ret .= ","; }
			$ret .= $dnarray[$i];
			}

		return $ret;
		}

	}
 else { $included["lib/ldap/php-ldap.inc.php3"]++; }
	
?>
