<?php

	// This library depends on the following sql tables to exist:
	//
	// $dbconfig["sqlmail_folders"]	   = "twig_mail_folders";
	// $dbconfig["sqlmail_messages"]   = "twig_mail_messages";	

	CLASS mailbox_info
		{
		var $Date;
		var $Driver;
		var $Mailbox;
		var $Nmsgs;
		var $Recent;
		var $Unread;
		var $Size;
		}

	CLASS mailheader_subinfo
		{
		var $personal;
		var $adl;
		var $mailbox;
		var $host;
		}

	CLASS mailheader_info
		{
		var $remail;
		var $date;
		var $Date;
		var $subject;
		var $Subject;
		var $in_reply_to;
		var $message_id;
		var $newsgroups;
		var $followup_to;
		var $references;
		var $Recent;
		var $Unseen;
		var $Answered;
		var $Deleted;
		var $Draft;
		var $Flagged;
		var $toaddress;
		var $to;
		var $fromaddress;
		var $from;
		var $ccaddress;
		var $cc;
		var $bccaddress;
		var $bcc;
		var $reply_toaddress;
		var $reply_to;
		var $senderaddress;
		var $sender;
		var $return_path;
		var $return;
		var $udate;
		}

	CLASS mailstructure_info
		{
		var $encoding;
		var $ifsubtype;
		var $subtype;
		var $ifdescription;
		var $description;
		var $ifid;
		var $id;
		var $lines;
		var $bytes;
		var $ifdisposition;
		var $disposition;
		var $ifdparameters;
		var $dparameters;
		var $ifparameters;
		var $parameters;
		var $parts;
		}
	
	CLASS mailmime_parameters
		{
		var $attribute;
		var $value;
		}

 Function TWIGMailGetFrom()
	{
	GLOBAL $config, $dbconfig, $login;

	if( TWIGCheckACL( $login["username"], 4014, TWIGConvertAccess( "read" ) ) )
		{
		$from = stripslashes( GetPref( "fromaddress", $dbconfig["prefs_table"], $config["defaults"]["mail"]["fromaddress"] ) );
		$from =  str_replace( "\n", "", $from );

		if( !$from ) { $from = $config["defaults"]["mail"]["fromaddress"]; }
		}
	else
		{ 
		$from = $config["defaults"]["mail"]["fromaddress"]; 
		}

	return $from;
	}

 Function TWIGMailDuplicateAddressCheck( $alist )
	{
	$addresses = imap_rfc822_parse_adrlist( $alist, "" );

	for( $i = 0, $j = count( $addresses ); $i < $j; $i++ )
		{
		$emaila = $addresses[$i]->mailbox . "@" . $addresses[$i]->host;

		if( !$found[$emaila] )
			{
			$found[$emaila] = 1;
			if( $out ) { $out .= ", "; }
			if( $addresses[$i]->personal ) { $out .= "\"" . $addresses[$i]->personal . "\" "; }
			$out .= "<" . $emaila . ">";
			}
		}

	return $out;		
	}

 Function TWIGMakeUnixDate( $datestring )
	{
	$months = array( "JAN"=>"1", "FEB"=>"2", "MAR"=>"3", "APR"=>"4", "MAY"=>"5", "JUN"=>"6", "JUL"=>"7", "AUG"=>"8", "SEP"=>"9", "OCT"=>"10", "NOV"=>"11", "DEC"=>"12" );

	$tempsplit = explode( ",", $datestring );

	$tempelements = count( $tempsplit );

	if( $tempelements == 2 )
		{
		$newdate = $tempsplit[1];
		}
	else
		{
		$newdate = $tempsplit[0];
		}
	
	$datesplit = explode( " ", trim( $newdate ) );

	$dateelements = count( $datesplit );

	$timesplit = explode( ":", $datesplit[3] );

	if( $datesplit[4] )
		{
		$temp = substr( $datesplit[4], 0, 1 );

		if( $temp == "-" )
			{
			$hchange = substr( $datesplit[4], 1, 2 );
			$mchange = substr( $datesplit[4], 3, 2 );

			$timesplit[0] += $hchange;
			$timesplit[1] += $mchange;
			}

		if( $temp == "+" )
			{
			$hchange = substr( $datesplit[4], 1, 2 );
			$mchange = substr( $datesplit[4], 3, 2 );

			$timesplit[0] -= $hchange;
			$timesplit[1] -= $mchange;
			}
		}

	$utime = mktime( $timesplit[0], $timesplit[1], $timesplit[2], $months[strtoupper($datesplit[1])], $datesplit[0], $datesplit[2] );

	return $utime;
	}

	Function TWIGGetCClientMailbox( $mailbox )
		{
		TWIGDebug( "TWIGGetCClientMailbox( \"" . $mailbox . "\" );" );

		$box = explode( "}", $mailbox );

		if( count( $box ) > 1 )
			{
			return $box[1];
			}
		else
			{
			return $box[0];
			}
		}
	
	Function TWIGGetMailStreamType( $mailbox )
		{
		$exp = explode( "}", $mailbox );

		if( $exp[0] == "{sql-mbox:" )
			{
			return array( "2", $exp[1] );
			}
		else
			{
			return array( "1", $exp[1] );
			}
		}	

 	Function TWIGCloseMB( $mbox ) 
		{
		TWIGDebug( "TWIGCloseMB( \"$mbox\" );" );
		if( $mbox ) { imap_close( $mbox ); }
		}

 	// Open a mailbox without a lot of hassle
 	Function TWIGOpenMB( $mailbox, $oldmbox = FALSE) 
		{
  		global $session, $config, $login;
  		
		TWIGDebug( "TWIGOpenMB( \"" . $mailbox . "\", \"" . $oldmbox . "\" );" );

		if( CheckMBType( MailboxDecode( $mailbox ) ) > 0 ) { $mailbox = "INBOX"; }
		if( !$mailbox ) { $mailbox = "INBOX"; }

  		if( !$config["imap_server"] ) { $config["imap_server"] = "localhost"; }
  		if( !$config["imap_port"] ) { $config["imap_port"] = "110"; }

		if( $oldmbox != FALSE )
			{
			$mbox = $oldmbox;
			}
		else
			{
			if( $mailbox == "INBOX" )
				{
		  		$mbox = @imap_open( "{" . $config["imap_server"] . "/pop3:" . $config["imap_port"] . "}INBOX", $login["username"], $login["password"] );
				}
			else
				{
				$mbox = TWIGMailGetFolderString( "", "", "", $mailbox );
				}
			}

  		return $mbox;
 		}

	Function TWIGMailOpenMailbox( $mailbox, $user, $password, $options )
		{
		TWIGDebug( "TWIGMailOpenMailbox( \"" . $mailbox . "\", \"" . $user . "\", \"" . $password . "\", \"" . $options . "\" );" );

		return imap_open( $mailbox, $user, $password, $options );
		}

	Function TWIGCheckNewMail( $mbox ) 
		{
		TWIGDebug( "TWIGCheckNewMail( \"" . $mbox . "\" );" );
		$check = TWIGMailBoxCheck( $mbox );

		return $check->Recent;
	 	}

	Function TWIGGetMessageCount( $mbox ) 
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGGetMessageCount( \"" . $mbox . "\" );" );

		$type = TWIGGetMailStreamType( $mbox );

		if( $type[0] == 1 )
			{
		  	$check = imap_check( $mbox );
	  		return $check->Nmsgs;
			}
		else
			{
			$query = "SELECT id FROM " . $dbconfig["sqlmail_messages"] . " WHERE user='" . $login["username"] . "' AND folder='" . $type[1] . "'";
			$result = dbquery( $query );

			return dbNumRows( $result );
			}
	 	}

 	Function MailboxDecode( $mb, $strip = "" ) 
		{ 
  		GLOBAL $config;

  		$mb = str_replace( "!", "/", $mb);

  		if( $strip )
			{
    			return ereg_replace( "^$config[imap_path]", "", $mb );
  			}
  		else 
			{
    			return $mb;
  			}
 		}

 	Function MailboxEncode( $mb ) 
		{ 
		return str_replace( "/", "!", $mb ); 
		}

 	//Check to see what type of mailbox we have, 0 imap, 1 news 2 pop3
 	Function CheckMBType($str) 
		{
   		if( strstr( $str, "/nntp" ) ) { return 1; }
   		else { if( strstr( $str, "/pop3" ) ) { return 2; } 
   		else { return 0; } }
   		}

	Function TWIGMailFetchStructure( $mailbox, $message )
		{
		GLOBAL $dbconfig, $login;

		TWIGDebug( "TWIGMailFetchStructure( \"" . $mailbox . "\", \"" . $message . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			return imap_fetchstructure( $mailbox, $message );
			}
		else
			{
			$query = "SELECT body, headers FROM " . $dbconfig["sqlmail_messages"] . " WHERE user='" . $login["username"] . "' AND id='" . $message . "'";
			$result = dbquery( $query );

			$data = dbresultarray( $result, 0 );

			$lines = explode( "\n", $data["body"] );
			$numlines = count( $lines ) + 1;

			$msgstruct = new mailstructure_info;

			$msgstruct->encoding = 0;
			$msgstruct->ifsubtype = 1;
			$msgstruct->subtype = "PLAIN";
			$msgstruct->ifdescription = 0;
			$msgstruct->description = 0;
			$msgstruct->ifid = 0;
			$msgstruct->id = 0;
			$msgstruct->lines = $numlines;
			$msgstruct->bytes = strlen( $data["body"] ) + $numlines;
			$msgstruct->ifdisposition = 0;
			$msgstruct->disposition = 0;
			$msgstruct->ifdparameters = 0;
			$msgstruct->dparameters = 0;
			$msgstruct->ifparameters = 1;

			$params = new mailmime_parameters;
			$params->attribute = "CHARSET";
			$params->value = "US-ASCII";

			$msgstruct->parameters = array( $params );
			$msgstruct->parts = 0;

			return $msgstruct;
			}
		}

	Function TWIGMailBody( $mailbox, $message )
		{
		return imap_body( $mailbox, $message );
		}

	Function TWIGMailFetchBody( $mailbox, $message, $section )
		{
		GLOBAL $dbconfig, $login;

		TWIGDebug( "TWIGMailFetchBody( \"" . $mailbox . "\", \"" . $message . "\", \"" . $section . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			return imap_fetchbody( $mailbox, $message, $section );
			}
		else
			{
			$query = "SELECT body FROM " . $dbconfig["sqlmail_messages"] . " WHERE user='" . $login["username"] . "' AND id='" . $message . "'";
			$result = dbquery( $query );

			$data = dbresultarray( $result, 0 );

			return $data["body"];
			}
		}
	
	Function TWIGMailBoxCheck( $mailbox )
		{
		TWIGDebug( "TWIGMailBoxCheck( \"" . $mailbox . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			$check = imap_check( $mailbox );
			}
		else
			{
			$check = new mailbox_info;

			$check->Date = "";
			$check->Driver = "SQL Mail";
			$check->Mailbox = $mb;
			$check->Nmsgs = TWIGGetMessageCount( $mailbox );
			$check->Recent = 0;
			}

		return $check;
		}

	Function TWIGMailCopy( $mailbox, $message, $destination )
		{
		TWIGDebug( "TWIGMailCopy( \"" . $mailbox . "\", \"" . $message . "\", \"" . $destination . "\" );" );

//		return imap_mail_copy( $mailbox, $message, $destination );
		}

	Function TWIGMailMove( $mailbox, $message, $destination )
		{
		TWIGDebug( "TWIGMailMove( \"" . $mailbox . "\", \"" . $message . "\", \"" . $destination . "\" );" );

//		return imap_mail_move( $mailbox, $message, $destination );
		}
		
	Function TWIGMailDelete( $mailbox, $item )
		{
		TWIGDebug( "TWIGMailDelete( \"" . $mailbox . "\", \"" . $item . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			imap_delete( $mailbox, $item ); 
			imap_expunge( $mailbox );
			}
		else
			{
			$query = "DELETE FROM " . $dbconfig["sqlmail_messages"] . " WHERE id='" . $item . "'";
			dbquery( $query );
			}

		return TRUE;
		}

	Function TWIGMailSubscribedFolders( $mailbox, $path, $filter )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailSubscribedFolders( \"" . $mailbox . "\", \"" . $path . "\", \"" . $folder . "\" );" );

		$query = "SELECT folder FROM " . $dbconfig["sqlmail_folders"] . " WHERE user='" . $login["username"] . "' AND subscribed='1'";
		$result = dbquery( $query );

		for( $i = 0, $j = dbnumrows( $result ); $i < $j; $i++ )
			{
			$data = dbResultArray( $result, $i );

			$ret[$i] = TWIGMailGetFolderString( "", "", "", $data["folder"] );
			}

		$ret[$i] = TWIGMailGetFolderString( "", "", "", "INBOX" );

		return $ret;
		}

	Function TWIGMailEmptyTrash( $mailbox )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailEmptyTrash( \"" . $mailbox . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			return imap_expunge( $mailbox );
			}
		else
			{
			$query = "DELETE FROM " . $dbconfig["sqlmail_messages"] . " WHERE user='" . $login["username"] . "' AND folder='" . $mb . "' AND deleted='1'";
			dbquery( $query );

			return TRUE;
			}
		}

	Function TWIGMailGetSortedList( $mailbox, $sortedby, $sorteddirection )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailGetSortedList( \"" . $mailbox . "\", \"" . $sortedby . "\", \"" . $sorteddirection . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			return imap_sort( $mailbox, $sortedby, $sorteddirection );
			}
		else
			{
			switch( $sortedby )
				{
				case 0:
					$sortfield = "SENTDATE";
					break;
				case 1:
					$sortfield = "SENTDATE";
					break;
				case 2:
					$sortfield = "SENTFROM";
					break;
				case 3:
					$sortfield = "SUBJECT";
					break;
				case 4:
					$sortfield = "SENTTO";
					break;
				case 5:
					$sortfield = "SENTTO";
					break;
				case 6:
					$sortfield = "SIZE";
					break;
				default:
					$sortfield = "SENTDATE";
					break;
				}

			if( $sorteddirection )
				{
				$sortdir = " DESC";
				}

			$query = "SELECT id FROM " . $dbconfig["sqlmail_messages"] . " WHERE user='" . $login["username"] . "' AND folder='" . $type[1] . "' ORDER BY " . $sortfield . $sortdir;
			$result = dbquery( $query );

			for( $i = 0, $j = dbnumrows( $result ); $i < $j; $i++ )
				{
				$data = dbResultArray( $result, $i );

				$ret[$i] = $data[0];
				}

			return $ret;
			}
		}

	Function TWIGMailCreateFolder( $mailbox, $folder )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailCreateFolder( \"" . $mailbox . "\", \"" . $folder . "\" );" );

		$query = "INSERT INTO " . $dbconfig["sqlmail_folders"] . " SET user='" . $login["username"] . "',folder='" . TWIGGetCClientMailbox( $folder ) . "'";
		dbquery( $query );

		return TRUE;
		}

	Function TWIGMailSubscribeFolder( $mailbox, $folder )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailSubscribeFolder( \"" . $mailbox . "\", \"" . $folder . "\" );" );

		$query = "UPDATE " . $dbconfig["sqlmail_folders"] . " SET subscribed='1' WHERE user='" . $login["username"] . "' AND folder='" . TWIGGetCClientMailbox( $folder ) . "'";
		dbquery( $query );
		
	  	return TRUE;
		}
	
	Function TWIGMailUnSubscribeFolder( $mailbox, $folder )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailUnSubscribeFolder( \"" . $mailbox . "\", \"" . $folder . "\" );" );

		$query = "UPDATE " . $dbconfig["sqlmail_folders"] . " SET subscribed='0' WHERE user='" . $login["username"] . "' AND folder='" . TWIGGetCClientMailbox( $folder ) . "'";
		dbquery( $query );
		
	  	return TRUE;
		}

	Function TWIGMailDeleteFolder( $mailbox, $folder )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailDeleteFolder( \"" . $mailbox . "\", \"" . $folder . "\" );" );

		$query = "DELETE FROM " . $dbconfig["sqlmail_folders"] . " WHERE user='" . $login["username"] . "' AND folder='" . TWIGGetCClientMailbox( $folder ) . "'";
		dbquery( $query );

		$query = "DELETE FROM " . $dbconfig["sqlmail_messages"] . " WHERE user='" . $login["username"] . "' AND folder='" . TWIGGetCClientMailbox( $folder ) . "'";
		dbquery( $query );
		
	  	return TRUE;
		}

	Function TWIGMailRenameFolder( $mailbox, $folder, $newname )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailRenameFolder( \"" . $mailbox . "\", \"" . $folder . "\", \"" . $newname . "\" );" );

		$query = "UPDATE " . $dbconfig["sqlmail_folders"] . " SET folder='" . $newname . "' WHERE user='" . $login["username"] . "' AND folder='" . TWIGGetCClientMailbox( $folder ) . "'";
		dbquery( $query );

		$query = "UPDATE " . $dbconfig["sqlmail_folders"] . " SET folder='" . $newname . "' WHERE user='" . $login["username"] . "' AND folder='" . TWIGGetCClientMailbox( $folder ) . "'";
		dbquery( $query );
		
	  	return TRUE;
		}

	Function TWIGMailFolderList( $mailbox, $startingfolder, $filter )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailFolderList( \"" . $mailbox . "\", \"" . $startingfolder . "\", \"" . $filter . "\" );" );

		$query = "SELECT folder FROM " . $dbconfig["sqlmail_folders"] . " WHERE user='" . $login["username"] . "'";
		$result = dbquery( $query );

		for( $i = 0, $j = dbnumrows( $result ); $i < $j; $i++ )
			{
			$data = dbResultArray( $result, $i );

			$ret[$i] = $data[0];
			}
		$i++;

		$ret[$i] = "INBOX";
		
		return $ret;
		}

	Function TWIGMailFolderInfo( $mailbox )
		{
		TWIGDebug( "TWIGMailFolderInfo( \"" . $mailbox . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			$check = imap_mailboxmsginfo( $mailbox );
			}
		else
			{
			$check = new mailbox_info;

			$check->Date = "";
			$check->Driver = "SQL Mail";
			$check->Mailbox = $mb;
			$check->Nmsgs = TWIGGetMessageCount( $mailbox );
			$check->Recent = 0;
			$check->Unread = 0;
			$check->Size = 0;
			}

		return $check;
		}

	Function TWIGMailHeader( $mailbox, $message, $fromlength, $subjectlength, $defaultdomain )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailHeader( \"" . $mailbox . "\", \"" . $message . "\", \"" . $fromlength . "\", \"" . $subjectlength . "\", \"" . $defaultdomain . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			return imap_header( $mailbox, $message, $fromlength, $subjectlength, $defaultdomain );
			}
		else
			{
			$query = "SELECT headers FROM " . $dbconfig["sqlmail_messages"] . " WHERE user='" . $login["username"] . "' AND id='" . $message . "'";
			$result = dbquery( $query );

			$data = dbResultArray( $result, 0 );

			$foo = explode( "\n", $data[0] );

			while( list( $k, $v ) = each( $foo ) ) 
				{
				$header = explode( ": ", $v );

				if( count( $header ) > 1 ) 
					{
					$curheader = $header[0];
	       				$hlist[$curheader] = $header[1];
					TWIGDebug( $curheader . ": " . $header[1] );
					}
				elseif( trim( $v ) ) 
					{
        				$hlist[$curheader] .= $v;
					TWIGDebug( $curheader . ": " . $v );
					}
				}

			$head = new mailheader_info;

			$head->date = $hlist["Date"];
			$head->Date = $hlist["Date"];
			$head->subject = $hlist["Subject"];
			$head->Subject = $hlist["Subject"];
			$head->in_reply_to = $hlist["in_reply_to"];
			$head->message_id = $hlist["message_id"];
			$head->newsgroups = $hlist["newsgroups"];
			$head->followup_to = $hlist["followup_to"];
			$head->references = $hlist["references"];
			$head->Recent = $hlist["Recent"];
			$head->Unseen = $hlist["Unseen"];
			$head->Answered = $hlist["Answered"];
			$head->Deleted = $hlist["Deleted"];
			$head->Draft = $hlist["Draft"];
			$head->Flagged = $hlist["Flagged"];
			$head->toaddress = $hlist["toaddress"];
			$head->fromaddress = $hlist["fromaddress"];
			$head->ccaddress = $hlist["ccaddress"];
			$head->bccaddress = $hlist["bccaddress"];
			$head->reply_toaddress = $hlist["reply_toaddress"];
			$head->senderaddress = $hlist["senderaddress"];
			$head->return_path = $hlist["return_path"];
			$head->udate = TWIGMakeUnixDate( $head->Date );
			
			$head->to = $hlist["to"];
			$head->from = $hlist["From"];
			$head->cc = $hlist["cc"];
			$head->bcc = $hlist["bcc"];
			$head->reply_to = $hlist["reply_to"];
			$head->sender = $hlist["sender"];
			$head->return = $hlist["return"];

			return $head;
			}
		}

	Function TWIGMailSetMessageFlag( $mailbox, $message, $flag )
		{
		TWIGDebug( "TWIGMailSeteMessageFlag( \"" . $mailbox . "\", \"" . $message . "\", \"" . $flag . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			return imap_setflag_full( $mailbox, $message, $flag );
			}
		}

	Function TWIGMailUnSetMessageFlag( $mailbox, $message, $flag )
		{
		TWIGDebug( "TWIGMailUnSetMessageFlag( \"" . $mailbox . "\", \"" . $message . "\", \"" . $flag . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $mb == 1 )
			{
			return imap_clearflag_full( $mailbox, $message, $flag );
			}
		}

	Function TWIGMailAppendMessage( $mailbox, $folder, $message, $flags )
		{
		TWIGDebug( "TWIGMailAppendMessage( \"" . $mailbox . "\", \"" . $folder . "\", \"" . $message . "\", \"" . $flags . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			return imap_append( $mailbox, $folder, $message, $flags );
			}
		else
			{
			return TRUE;
			}
		}

	Function TWIGMailUndelete( $mailbox, $message )
		{
		TWIGDebug( "TWIGMailUndelete( \"" . $mailbox . "\", \"" . $message . "\" );" );

		return TRUE;
		}

	Function TWIGMailFetchHeader( $mailbox, $message )
		{
		GLOBAL $login, $dbconfig;

		TWIGDebug( "TWIGMailFetchHeader( \"" . $mailbox . "\", \"" . $message . "\" );" );

		$type = TWIGGetMailStreamType( $mailbox );

		if( $type[0] == 1 )
			{
			return imap_fetchheader( $mailbox, $message );
			}
		else
			{	
			$query = "SELECT header FROM " . $dbconfig["sqlmail_messages"] . " WHERE user='" . $login["username"] . "' AND id='" . $message . "'";
			$result = dbquery( $query );

			$data = dbqueryArrray( $result, 0 );

			return $data[0];
			}
		}

	Function TWIGMailParseAddressList( $list, $defaultdomain )
		{		
		return imap_rfc822_parse_adrlist( $list, $defaultdomain );
		}

	Function TWIGMailDecodeBase64( $text )
		{
		return imap_base64( $text );
		}

	Function TWIGMailDecodeQuotedPrintable( $text )
		{
		// Strip out the 76th character MIME wrap and decode
		return quoted_printable_decode( str_replace( "=\r\n", "", $text ) );
		}

	Function TWIGMailGetFolderString( $server, $port, $type, $folder, $user = "", $pass = "" )
		{
		if( $mailbox == "INBOX" )
			{
			$ret = "{" . $server . "/pop3:" . $port . "}INBOX";
			}
		else
			{
			$ret = "{sql-mbox:}" . TWIGProcessGPCString( $folder );
			}

		return $ret;
		}

	Function TWIGMailParseFolderString( $FolderString )
		{
    		$foldersplit = explode( "}", $FolderString );
		if( count( $foldersplit ) > 1 ) { $mbfolder = $foldersplit[1]; }

		$portsplit = explode( ":", $foldersplit[0] );
		if( count( $portsplit ) > 1 ) { $mbport = $portsplit[1]; }
			
		$typesplit = explode( "/", $portsplit[0] );
		if( count( $typesplit ) > 1 ) { $mbtype = $typesplit[1]; }

		$serversplit = explode( "{", $typesplit[0] );
		if( count( $serversplit ) > 1 ) { $mbserver = $serversplit[1]; }

		return array( $mbserver, $mbport, $mbtype, $mbfolder, $mbuser, $mbpass );
		}

	Function TWIGMailGetDisplayName( $Folder )
		{
		GLOBAL $config;

      		return $Folder;
		}

	Function TWIGMailSearch( $mailbox, $criteria, $flags = "" )
		{
		// Valid values for flags are SE_UID, which causes the returned array to contain UIDs instead of
		// messages sequence numbers.
      		return imap_search( $mailbox, $criteria, $flags );
		}

	Function TWIGMailMIMEHeaderDecode( $text )
		{
		// This function only exists in 3.0.17 and higher
		if( function_exists( 'imap_mime_header_decode' ) )
			{
			$decoded = imap_mime_header_decode( $text );
			$text = "";
			while( list( $key, $val ) = each( $decoded ) )
				{
				$text .= $val->text;
				}
			}
		return( $text );
		}

?>
