<?php

srand( ( double )microtime() * 1000000 );

Function TWIGIsMemberOfACLGroup( $name, $groupname )
	{
	Global $dbconfig;

	$query = "SELECT * FROM " . $dbconfig["aclgroups_table"] . " WHERE groupname='" . $groupname . "' AND username='" . $name . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	if( $j > 0 )
		{
		return TRUE;	
		}

	return FALSE;	
	}

Function TWIGConvertAccess( $access )
	{
	switch( strtoupper( $access ) )
		{
		case "NONE":
			return 0;
		case "READ":
			return 2;
		case "WRITE":
			return 4;
		case "DELETE":
			return 8;
		case "SIDADMIN":
			return 16;
		case "OWNER":
			return 32;
		case "ADMIN":
			return 128;
		case 0:
			return "none";
		case 2:
			return "read";
		case 4:
			return "write";
		case 8:
			return "delete";
		case 16:
			return "sidadmin";
		case 32:
			return "owner";
		case 128:
			return "admin";
		}
	}

//
// SID Ranges are as follows:
//
// 	    0-100000  : Internal SID (for features and preferences)
//     100000-2000000 : Assigned by modules for user data
//
// Internal SID's a currently defined as follows: 	
//
//	   0  - 999	: reserved
//	 1000 - 1999	: Global Options
//	 2000 - 2999	: Features (main, mail, etc...)
//	 3000 - 3999	: Main feature prefs
//	 4000 - 4999	: Mail feature prefs
//	 5000 - 5999	: News feature prefs
//	 6000 - 6999	: Contacts feature prefs
//	 7000 - 7999	: Schedule feature prefs
//	 8000 - 8999	: ToDO feature prefs
//	 9000 - 9999	: Bookmarks feature prefs
//	10000 - 10999	: Groups feature prefs
//	11000 - 11999	: Admin feature prefs
//	12000 - 100000	: reserved for future use
//

Function TWIGGenerateSID( $owner = "" )
	{
	Global $dbconfig, $login;

	if( !$owner ) { $owner = $login["username"]; }

	$stayhere = TRUE;
	while( $stayhere == TRUE )	
		{
		// Build a SID, reserve the first 10000 SID's for internal use
		$randval = rand( 100000, 2000000 );

		$query = "SELECT * FROM " . $dbconfig["acl_table"] . " WHERE SID='" . $randval . "'";
		$result = dbquery( $query );

		if( dbnumrows( $result ) == 0 )
			{
			$stayhere = FALSE;
			}
		}

	$query = "INSERT INTO " . $config["acl_table"] . " (SID, ident, alevel) VALUES ('" . $randval . "', '" . $owner . "', '" . TWIGConvertAccess( "owner" ) . "')";

	return $randval;
	}

Function TWIGSCheckACL( $name, $sid, $access )
	{
	Global $config, $dbconfig;

	$query = "SELECT * FROM " . $dbconfig["acl_table"] . " WHERE SID='" . $sid . "' AND ident='" . $name . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	if( $j > 0 )
		{
		for( $i = 0; $i < $j; $i++ )
			{
			$data = dbresultarray( $result, $i );

			if( $data["alevel"] >= $access ) 
				{ 
				return TRUE;
				}
			}	
		}
	else
		{
		return FALSE;
		}
	}

Function TWIGCheckACL( $name, $sid, $access )
	{
	Global $config, $dbconfig;

	$ret = FALSE;

	$query = "SELECT * FROM " . $dbconfig["accounts_table"] . " WHERE username='" . $name . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	$ret = TWIGSCheckACL( $name, $sid, $access );

	if( $j > 0 && $ret == FALSE )
		{
		$query = "SELECT * FROM " . $dbconfig["aclgroups_table"] . " WHERE username='" . $name . "'";
		$result = dbquery( $query );

		$j = dbnumrows( $result );
		for( $i = 0; $i < $j; $i++ )
			{
			$data = dbresultarray( $result, $i );

			if( TWIGSCheckACL( $data["groupname"], $sid, $access ) == TRUE )
				{
				$ret = TRUE;
				$i = $j;
				}
			}
		}


	return $ret;
	}

Function TWIGSGetACL( $name, $sid, $access )
	{
	Global $config, $dbconfig;

	$ret = 0;

	$query = "SELECT * FROM " . $dbconfig["acl_table"] . " WHERE SID='" . $sid . "' AND ident='" . $name . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );
	
	if( $j > 0 )
		{
		for( $i = 0; $i < $j; $i++ )
			{
			$data = dbresultarray( $result, $i );

			if( $data["alevel"] > $ret ) { $ret = $data["alevel"]; }
			}	

		return $ret;
		}
	else
		{
		return 0;
		}
	}

Function TWIGGetACL( $name, $sid )
	{
	Global $config, $dbconfig;

	$ret = FALSE;

	$query = "SELECT * FROM " . $dbconfig["accounts_table"] . " WHERE username='" . $name . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	$ret = TWIGSGetACL( $name, $sid, $access );

	if( $j > 0 && $ret == FALSE )
		{
		$query = "SELECT * FROM " . $dbconfig["aclgroups_table"] . " WHERE username='" . $name . "'";
		$result = dbquery( $query );

		$j = dbnumrows( $result );
		for( $i = 0; $i < $j; $i++ )
			{
			$data = dbresultarray( $result, $i );
			
			$temp = TWIGSGetACL( $data["groupname"], $sid, $access );
			if( $temp > $ret ) { $ret = $temp; }
			}
		}

	return $ret;
	}

Function TWIGModifyACL( $name, $sid )
	{
	Global $dbconfig;

	if( !TWIGCheckACL( $name, $sid, TWIGConvertAccess( "sidadmin" ) ) )
		{
		return TWIGDisplayACL( $name, $sid );
		}

	$query = "SELECT * FROM " . $dbconfig["acl_table"] . " WHERE SID='" . $sid . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	$tableheaders = array( TWIGPhrase( "Object" ), "&nbsp;", TWIGPhrase( "Access" ), "&nbsp;",  TWIGPhrase( "Options" ) );
	$acllevels = array( "none", "read", "write", "delete", "sidadmin", "owner", "admin" );
	
	for( $i = 0; $i < $j; $i++ )
		{
		$data = dbresultarray( $result, $i );
	
		$temp = "<select name=acllevel>";

		for( $k = 0, $l = count( $acllevels ); $k < $l; $k++ )
			{
			if( $acllevels[$k] == TWIGConvertAccess( $data["alevel"] ) ) { $selected = " SELECTED"; } else { $selected = ""; }
			$temp .= "<option" . $selected . " value=\"" . TWIGConvertAccess( $acllevels[$k] ) . "\">" . $acllevels[$k] . "</option>";
			}

		$temp .= "</select>";

		$tablecontents[$i] = array( "<form>" . TWIGSession( "put" ) . TWIGContext( "put" ) . "<input type=hidden name=aclsid value=\"" . $sid . "\"><input type=hidden name=aclobject value=\"" . $data["ident"] . "\">" . $data["ident"],  "&nbsp;", $temp,  "&nbsp;", "<input type=submit name=aclmodifyentry value=" . TWIGPhrase( "Modify" ) . ">&nbsp;<input type=submit name=aclmodifyentry value=" . TWIGPhrase( "Delete" ) . "></form>" );
		}

	$tc = $i;

	$temp = "<form>" . TWIGSession( "put" ) . TWIGContext( "put" ) . "<input type=hidden name=aclsid value=\"" . $sid . "\"><select name=aclobject><option>" . TWIGPhrase( "*Select object*" ) . "</option>";

	$query = "SELECT username FROM " . $dbconfig["accounts_table"];
	$result = dbquery( $query );
	
	$j = dbnumrows( $result );
	for( $i = 0; $i < $j; $i ++ )
		{
		$data = dbresultarray( $result, $i );

		$temp .= "<option>" . $data["username"] . "</option>";
		}

	$query = "SELECT groupname FROM " . $dbconfig["aclgroups_table"];
	$result = dbquery( $query );
	
	$j = dbnumrows( $result );
	for( $i = 0; $i < $j; $i ++ )
		{
		$data = dbresultarray( $result, $i );

		$glist[$data["groupname"]]++;

		if( $glist[$data["groupname"]] < 2 ) { $temp .= "<option>" . $data["groupname"] . "</option>"; }
		}
	
	$temp .= "</select>";

	for( $k = 0, $l = count( $acllevels ); $k < $l; $k++ )
		{
		$artemp .= "<option value=\"" . TWIGConvertAccess( $acllevels[$k] ) . "\">" . $acllevels[$k] . "</option>";
		}

	$tablecontents[$tc] = array( $temp,  "&nbsp;", "<select name=acllevel>" . $artemp . "</select>", "&nbsp;", "<input type=submit name=\"aclmodifyentry\" value=" . TWIGPhrase( "Add" ) . "></form>" );

	return TWIGGenerateTable( $tableheaders, $tablecontents );
	}

Function TWIGProcessACLModify()
	{
	Global $aclmodifyentry, $login, $aclobject, $aclsid, $acllevel, $dbconfig;

	$query = "SELECT username FROM " . $dbconfig["accounts_table"] . " WHERE username='" . $aclobject . "'";
	$uresult = dbquery( $query );

	$query = "SELECT groupname FROM " . $dbconfig["aclgroups_table"] . " WHERE groupname='" . $aclobject . "'";
	$gresult = dbquery( $query );

	if( dbnumrows( $uresult ) == 0 && dbnumrows( $gresult ) == 0 )
		{
		return FALSE;
		}

	switch( $aclmodifyentry )
		{
		case TWIGPhrase( "Add" ):
			TWIGAddACLEntry( $login["username"], $aclobject, $aclsid, $acllevel );

			break;
		case TWIGPhrase( "Modify" ):
			TWIGModifyACLEntry( $login["username"], $aclobject, $aclsid, $acllevel );

			break;
		case TWIGPhrase( "Delete" ):
			TWIGDeleteACLEntry( $login["username"], $aclobject, $aclsid, $acllevel );

			break;
		}
	}

Function TWIGDisplayACL( $name, $sid )
	{
	Global $dbconfig;

	$query = "SELECT * FROM " . $dbconfig["acl_table"] . " WHERE SID='" . $sid . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	$tableheaders = array( TWIGPhrase( "Object" ),  "&nbsp;", TWIGPhrase( "Access" ) );
	
	for( $i = 0; $i < $j; $i++ )
		{
		$data = dbresultarray( $result, $i );

		$tablecontents[$i] = array( $data["ident"],  "&nbsp;", TWIGConvertAccess( $data["alevel"] ) );
		}

	return TWIGGenerateTable( $tableheaders, $tablecontents );
	}

Function TWIGCreateACLGroup( $name, $groupname )
	{
	Global $dbconfig;

	$query = "SELECT * FROM " . $dbconfig["aclgroups_table"] . " WHERE groupname='" . $groupname . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	if( $j > 0 )
		{
		return FALSE;
		}

	$newsid = TWIGGenerateSID();

	$query = "INSERT INTO " . $dbconfig["aclgroups_table"] . " (SID, groupname, username) VALUES ('" . $newsid . "', '" . $groupname . "', '" . $name . "')";
	$result = dbquery( $query );
	
	$query = "INSERT INTO " . $dbconfig["acl_table"] . " (SID, ident, alevel) VALUES ('" . $newsid . "', '" . $name . "', '" . TWIGConvertAccess( "owner" ) . "')";
	$result = dbquery( $query );

	return $newsid;
	}

Function TWIGDeleteACLGroup( $name, $groupname )
	{
	Global $dbconfig;

	$query = "SELECT * FROM " . $dbconfig["aclgroups_table"] . " WHERE groupname='" . $groupname . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	if( $j > 0 )
		{
		$data = dbresultarray( $result, 0 );
	
		if( TWIGCheckACL( $name, $data["SID"], TWIGConvertAccess( "sidadmin" ) ) )
			{
			$query = "DELETE FROM " . $dbconfig["aclgroups_table"] . " WHERE groupname='" . $groupname . "'";
			$result = dbquery( $query );
	
			$query = "DELETE FROM " . $dbconfig["acl_table"] . " WHERE SID='" . $data["SID"] . "'";
			$result = dbquery( $query );

			return TRUE;
			}
		}

	return FALSE;
	}

Function TWIGAddACLGroupMember( $username, $usernametoadd, $groupname )
	{
	Global $dbconfig;

	if( !TWIGCheckACL( $username, TWIGGetSID( $groupname ), TWIGConvertAccess( "sidadmin" ) ) )
		{
		return FALSE;
		}

	if( !TWIGIsMemberOfACLGroup( $usernametoadd, $groupname ) )
		{
		$query = "INSERT INTO " . $dbconfig["aclgroups_table"] . " (sid, groupname, username) VALUES ('" . TWIGGetSID( $groupname ) . "', '" . $groupname . "', '" . $usernametoadd . "')";

		if( !dbquery( $query ) )
			{
			return FALSE;
			}
		
		return TRUE;
		}
	else
		{
		return TRUE;
		}

	return FALSE;
	}

Function TWIGSYSAddACLGroupMember( $usernametoadd, $groupname )
	{
	Global $dbconfig;

	if( !TWIGIsMemberOfACLGroup( $usernametoadd, $groupname ) )
		{
		$query = "INSERT INTO " . $dbconfig["aclgroups_table"] . " (sid, groupname, username) VALUES ('" . TWIGGetSID( $groupname ) . "', '" . $groupname . "', '" . $usernametoadd . "')";

		if( !dbquery( $query ) )
			{
			return FALSE;
			}
		
		return TRUE;
		}
	else
		{
		return TRUE;
		}

	return FALSE;
	}

Function TWIGRemoveACLGroupMember( $username, $usernametoremove, $groupname )
	{
	Global $dbconfig;

	if( !TWIGCheckACL( $username, TWIGGetSID( $groupname ), TWIGConvertAccess( "sidadmin" ) ) )
		{
		return FALSE;
		}

	if( TWIGIsMemberOfACLGroup( $username, $groupname ) )
		{
		$query = "DELETE FROM " . $dbconfig["aclgroups_table"] . " WHERE groupname='" . $groupname . "' AND username='" . $usernametoremove . "'";

		if( !dbquery( $query ) )
			{
			return FALSE;
			}
		
		return TRUE;
		}

	return FALSE;
	}

Function TWIGGetSID( $name )
	{
	Global $dbconfig;

	$query = "SELECT * FROM " . $dbconfig["accounts_table"] . " WHERE username='" . $name . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );
	
	if( $j > 0 )
		{
		$data = dbresultarray( $result, 0 );

		return $data["SID"];
		}
	else
		{
		$query = "SELECT * FROM " . $dbconfig["aclgroups_table"] . " WHERE groupname='" . $name . "'";
		$result = dbquery( $query );

		$j = dbnumrows( $result );

		if( $j > 0 )
			{
			$data = dbresultarray( $result, 0 );

			return $data["SID"];
			}
		}

	return FALSE;
	}

Function TWIGAddACLEntry( $user, $addname, $sid, $access )
	{
	Global $dbconfig;

	if( TWIGCheckACL( $user, $sid, TWIGConvertAccess( "sidadmin" ) ) )
		{
		$query = "SELECT * FROM " . $dbconfig["acl_table"] . " WHERE sid='" . $sid . "' AND ident='" . $addname . "'";
		$result = dbquery( $query );

		if( dbnumrows( $result ) == 0 )
			{		
			$query = "INSERT INTO " . $dbconfig["acl_table"] . " (SID, ident, alevel) VALUES ('" . $sid . "', '" . $addname . "', '" . $access . "')";
			$result = dbquery( $query );
			}

		return $result;		
		}

	return FALSE;
	}

Function TWIGModifyACLEntry( $user, $addname, $sid, $access )
	{
	Global $dbconfig;

	if( TWIGCheckACL( $user, $sid, TWIGConvertAccess( "sidadmin" ) ) )
		{
		$query = "UPDATE " . $dbconfig["acl_table"] . " SET alevel='" . $access . "' WHERE sid='" . $sid . "' AND ident='" . $addname . "'";
		$result = dbquery( $query );

		return $result;		
		}

	return FALSE;
	}

Function TWIGDeleteACLEntry( $user, $addname, $sid, $access )
	{
	Global $dbconfig;

	if( TWIGCheckACL( $user, $sid, TWIGConvertAccess( "sidadmin" ) ) )
		{
		$query = "DELETE FROM " . $dbconfig["acl_table"] . " WHERE sid='" . $sid . "' AND ident='" . $addname . "'";
		$result = dbquery( $query );

		return $result;		
		}

	return FALSE;
	}

Function TWIGGetACLUsers()
	{
	Global $dbconfig;

	$query = "SELECT username FROM " . $dbconfig["accounts_table"];
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	if( $j > 0 )
		{
		for( $i = 0; $i < $j; $i++ )
			{
			$data = dbresultarray( $result, $i );

			$ret[$i] = $data["username"];
			}

		return $ret;
		}

	return FALSE;
	}

Function TWIGGetACLGroups()
	{
	Global $dbconfig;

	$query = "SELECT groupname FROM " . $dbconfig["aclgroups_table"];
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	if( $j > 0 )
		{
		$k = 0;

		for( $i = 0; $i < $j; $i++ )
			{
			$data = dbresultarray( $result, $i );
		
			$glist[$data["groupname"]]++;

			if( $glist[$data["groupname"]] == 1 ) 
				{ 
				$ret[$k] = $data["groupname"];
				$k++;
				}
			}

		return $ret;
		}

	return FALSE;
	}

Function TWIGGetACLGroupMembers( $group )
	{
	Global $dbconfig;

	$query = "SELECT username FROM " . $dbconfig["aclgroups_table"] . " WHERE groupname='" . $group . "'";
	$result = dbquery( $query );

	$j = dbnumrows( $result );

	if( $j > 0 )
		{
		for( $i = 0; $i < $j; $i++ )
			{
			$data = dbresultarray( $result, $i );
		
			$ret[$i] = $data["username"];
			}

		return $ret;
		}

	return FALSE;
	}

?>
