<?php
 // These 6 lines allow TWIG to operate with register_globals off
 @extract($_SERVER,EXTR_SKIP);
 @extract($_SESSION,EXTR_SKIP);
 @extract($_COOKIE,EXTR_SKIP);
 @extract($_POST,EXTR_SKIP);
 @extract($_GET,EXTR_SKIP);
 @extract($_FILES,EXTR_OVERWRITE);

// Thanks to a comment posted to the PHP manual
Function GetCommandLine()
	{
	Global $HTTP_SERVER_VARS;
  
	for ($i=0; $i<$HTTP_SERVER_VARS['argc']; $i++)
		{
		$my_args = array();
		if (ereg("(.*)=(.*)", $HTTP_SERVER_VARS['argv'][$i], $my_args))
			{
			$GLOBALS[$my_args[1]] = $my_args[2];
			}
		}
	}

Function ShowLanguageList( $before, $after1, $after3 )
	{
	$handle = opendir( "SourceFiles/" );

	echo $before . sprintf( "%-10s", "ALL" ) . $after1;

	$i = -1;
	while( ( $file = readdir( $handle ) ) !== false ) 
		{
		if( substr( $file, -13 ) == ".strings.php3" )
			{
			$lang = str_replace( ".strings.php3", "", $file );
			// Pad the language string out, it looks nicer!
			echo $before . sprintf( "%-10s", $lang ) . $after1;
			// Kind of a kluge...
			if( $i % 3 == 0 ) { echo $after3; }
			$i++;
			}
		}

	closedir( $handle );
	}

Function GenerateLanguage( $language )
	{
	// Pull this in from below
	Global $ifhtml;

	if( file_exists( "strings.layout.php3" ) )
		include( "strings.layout.php3" );
	else die( "    Unable to open file!\n" );

	if( file_exists( "SourceFiles/english.strings.php3" ) )
		include( "SourceFiles/english.strings.php3" );
	else die( "    Unable to open file!\n" );
	
	$EnglishTWIGphrase = $TWIGphrase;

	if( file_exists( "SourceFiles/" . $language . ".strings.php3" ) )
		include( "SourceFiles/" . $language . ".strings.php3" );
	else die( "    Unable to open file!\n" );

	echo "Generating files for " . $language . "..." . ( $ifhtml ? "<BR>" : "" ) . "\n";
		
	for( $i = 0, $j = count( $StringFiles ); $i < $j; $i++ )
		{
		if( !file_exists( "Output/" . $StringFiles[$i] . "/." ) ) { mkdir( "Output/" . $StringFiles[$i], 0777 ); }
		$fname = "Output/" . $StringFiles[$i] . "/" . $language . ".strings.php3";
		$newFile = fopen( $fname, "w" );

		echo ( $ifhtml ? "&nbsp;&nbsp;&nbsp;&nbsp;" : "    " ) . $fname . ( $ifhtml ? "<BR>" : "" ) . "\n";

		if( !$newFile )
			die( "  Unable to open file!\n" );

		fwrite( $newFile, "<?php\n" );
		fwrite( $newFile, "\n" );
		fwrite( $newFile, "  //--------------------------------------------------------\n" );
		fwrite( $newFile, "  //\n" );
		fwrite( $newFile, "  // This is a Language Phrases file. \n" );
		fwrite( $newFile, "  // \n" );
		fwrite( $newFile, "  // Created by: " . $FileInfo["Created"] . "\n" );
		fwrite( $newFile, "  // Email: " . $FileInfo["Email"] . "\n" );
		fwrite( $newFile, "  // \n" );
		fwrite( $newFile, "  // Language: " . $FileInfo["Language"] . "\n" );
		fwrite( $newFile, "  // Translated by: " . $FileInfo["Created"] . "\n" );
		fwrite( $newFile, "  // Email: " . $FileInfo["Email"] . "\n" );
		fwrite( $newFile, "  //\n" );
		fwrite( $newFile, "  // Current to TWIG version: " . $FileInfo["Version"] . "\n" );
		fwrite( $newFile, "  //\n" );
		fwrite( $newFile, "  // Please refer to the code specification for instructions\n" );
		fwrite( $newFile, "  // on modifying and/or translating language files.\n" );
		fwrite( $newFile, "  //\n" );
		fwrite( $newFile, "  //--------------------------------------------------------\n" );
		fwrite( $newFile, "\n" );

		if( is_array( $StringLayout[$StringFiles[$i]]["function"] ) )
			{
			for( $k = 0, $l = count( $StringLayout[$StringFiles[$i]]["function"] ); $k < $l; $k++ )
				{
				$tag = $StringLayout[$StringFiles[$i]]["function"][$k];
				fwrite( $newFile, $function[$tag] . "\n\n" );
				}
			}

		if( is_array( $StringLayout[$StringFiles[$i]]["config"] ) )
			{
			for( $k = 0, $l = count( $StringLayout[$StringFiles[$i]]["config"] ); $k < $l; $k++ )
				{
				$tag = $StringLayout[$StringFiles[$i]]["config"][$k];
				if( is_array( $config[$tag] ) )
					{
					$ostring = "  \$config[\"" . $tag . "\"]";
					$ostring = sprintf( "%-40s= array(", $ostring );
					fwrite( $newFile, $ostring );

					$first = 1;

					while( list( $key, $val ) = each( $config[$tag] ) ) 
						{
						if( !$first ) { fwrite( $newFile, "," ); }
						fwrite( $newFile, " \"" . $key . "\"=>\"" . $val . "\"" );
						$first = 0;
						}

					if( !$first ) { fwrite( $newFile, " " ); }
					fwrite( $newFile, ");\n" );
					}
				else
					{
					$config[$tag] = str_replace( "\"", "\\\"", $config[$tag] );

					$ostring = "  \$config[\"" . $tag . "\"]";
					$ostring = sprintf( "%-40s", $ostring );
					fwrite( $newFile, $ostring . "= \"" . $config[$tag] . "\";\n" );
					}
				}
			
			fwrite( $newFile, "\n" );
			}

		if( is_array( $StringLayout[$StringFiles[$i]]["TWIGphrase"] ) )
			{
			for( $k = 0, $l = count( $StringLayout[$StringFiles[$i]]["TWIGphrase"] ); $k < $l; $k++ )
				{
				$tag = $StringLayout[$StringFiles[$i]]["TWIGphrase"][$k];

				$ostring = "  \$TWIGphrase[\"" . $tag . "\"]";

				if( !$TWIGphrase[$tag] ) { $TWIGphrase[$tag] = $EnglishTWIGPhrase[$tag]; }
				if( is_array( $TWIGphrase[$tag] ) )
					{
					while( list( $tagkey, $tagval ) = each( $TWIGphrase[$tag] ) )
						{
						$astring = "[\"" . str_replace( "\\", "\\\\", $tagkey ) . "\"]";
						$bstring = "= \"" . str_replace( "\\", "\\\\", $tagval ) . "\";\n";
						fwrite( $newFile, sprintf( "%-40s%s", $ostring . $astring, $bstring ) );
						}
					}
				else
					{
					$ostring = sprintf( "%-40s", $ostring );
					$bstring = "= \"" . str_replace( "\\", "\\\\", $TWIGphrase[$tag] ) . "\";\n";
					fwrite( $newFile, sprintf( "%-40s%s", $ostring, $bstring ) );
					}
				}
			
			fwrite( $newFile, "\n" );
			}
		
		if( is_array( $StringLayout[$StringFiles[$i]]["dayNamesShort"] ) )
			{
			$ostring = "  \$dayNamesShort";
			$ostring = sprintf( "%-40s", $ostring );

			if( is_array( $dayNamesShort ) )
				{
				fwrite( $newFile, $ostring . "= array(" );

				$first = 1;

				while( list( $key, $val ) = each( $dayNamesShort ) ) 
					{
					if( !$first ) { fwrite( $newFile, "," ); }
					$val = str_replace( "\\", "\\\\", $val );
					fwrite( $newFile, " \"" . $val . "\"" );
					$first = 0;
					}

				if( !$first ) { fwrite( $newFile, " " ); }
				fwrite( $newFile, ");\n" );
				}
			else
				{
				fwrite( $newFile, $ostring . "= array();\n" );
				}
			}

		if( is_array( $StringLayout[$StringFiles[$i]]["dayNames"] ) )
			{
			$ostring = "  \$dayNames";
			$ostring = sprintf( "%-40s", $ostring );

			if( is_array( $dayNames ) )
				{
				fwrite( $newFile, $ostring . "= array(" );

				$first = 1;

				while( list( $key, $val ) = each( $dayNames ) ) 
					{
					if( !$first ) { fwrite( $newFile, "," ); }
					$val = str_replace( "\\", "\\\\", $val );
					fwrite( $newFile, " \"" . $val . "\"" );
					$first = 0;
					}

				if( !$first ) { fwrite( $newFile, " " ); }
				fwrite( $newFile, ");\n" );
				}
			else
				{
				fwrite( $newFile, $ostring . "= array();\n" );
				}
			}

		if( is_array( $StringLayout[$StringFiles[$i]]["monthNames"] ) )
			{
			$ostring = "  \$monthNames";
			$ostring = sprintf( "%-40s", $ostring );

			if( is_array( $dayNames ) )
				{
				fwrite( $newFile, $ostring . "= array(" );

				$first = 1;

				while( list( $key, $val ) = each( $monthNames ) ) 
					{
					if( !$first ) { fwrite( $newFile, "," ); }
					$val = str_replace( "\\", "\\\\", $val );
					fwrite( $newFile, " \"" . $val . "\"" );
					$first = 0;
					}

				if( !$first ) { fwrite( $newFile, " " ); }
				fwrite( $newFile, ");\n" );
				}
			else
				{
				fwrite( $newFile, $ostring . "= array();\n" );
				}
			
			fwrite( $newFile, "\n" );
			}

		fwrite( $newFile, "?>\n" );

		fclose( $newFile );
		}
	}

// Only display the menus in HTML 
if( isset( $HTTP_SERVER_VARS["REQUEST_METHOD"] ) )
	{
	$ifhtml = true;
	}
else
	{
	$ifhtml = false;
	}

if( $ifhtml ) {
?>

<html>
<title>TWIG Language Generation</title>

<body>
<H1>TWIG Language Generation</H1>

Please select the language you wish to generate:
<form>

<select name=genlang>
<?php ShowLanguageList( "<option>", "</option>\n", "" ); ?>
</select>
<input type=submit value=GO>

</form>

<?php
  // The closing HTML tag is at the very end,
  // because Generate() produces some output.
} else {
  // Import the command line arguments.
  GetCommandLine();
?>
This is the TWIG Translation Generation Script.

You may provide an argument to this script specifying
which language you would like to have generated. The
following languages are available:

<?php ShowLanguageList( "    ", "", "\n" ); ?>


Run the command with the php command line interface:

    shell$ php generate.strings.php genlang=<yourlanguage>

<?php

} // End of if( $ifhtml )...

// And of course, only call the main function here if needed!
if( $genlang )
	{
	// This should be non-controversial but quite useful...
	$genlang = strtolower( $genlang );
	echo ( $ifhtml ? "<H2>" : "" ) . "Status:" . ( $ifhtml ? "<H2>" : "" ) . "\n";
	if( $genlang == "all" )
		{
		$handle = opendir( "SourceFiles/" );

		while( ( $file = readdir( $handle ) ) !== false ) 
			{
			// Only compare the last n characters.
			// This excludes ...php3~, e.g. a vim backup.
			if( strstr( substr( $file, -13 ), ".strings.php3" ) )
				{
				$lang = str_replace( ".strings.php3", "", $file );
				GenerateLanguage( $lang );
				}
			}

		closedir( $handle );
		}
	else
		{
		GenerateLanguage( $genlang );
		}
	}

  // Right, need those pesky closing HTML tags...
if( $ifhtml ) { ?>
</body>
</html>
<?php } ?>
