

ifdef(`c_comment', `', `define(`c_comment')')
ifdef(`c_doxygen', `', `define(`c_doxygen')')

dnl 
dnl _G  is used to wrap each function argument.
dnl _G0 is used to wrap including return value.
dnl
dnl _RW type modifier means TT_ARG_READ_WRITE (this is the default)
dnl    i.e. object will be read and/or written to, and may be accessed by libTT
dnl    even after the call returned, provided libTT sets up a mechanism
dnl    not to access the object anymore after it is destroyed.
dnl _W type modifier means TT_ARG_WRITE i.e. object will not (and MUST not)
dnl    be read by libTT, but will be written to and will contain a return value
dnl _R type modifier means TT_ARG_READ i.e. object will only be read (C `const')
dnl    and will *not* be accessed by libTT after the call returned.
dnl _D type modifier means TT_ARG_DIE i.e. object may have be destroyed after
dnl    call is invoked
dnl _A((x)) type modifier is used for arrays:
dnl         the array length is given by the value of x,
dnl         in particular, `x' may refer to the n-th function arg using _P(n)
dnl         and it may refer to the field named `f' using _F(f)
dnl _Z type modifier is used for arrays:
dnl         the array is zero-terminated like C strings.
dnl

ifdef(`_G0', `', `define(`_G0', `$@')')
ifdef(`_G',  `', `define(`_G',  `$@')')

ifdef(`_W',  `', `define(`_W',  `TT_ARG_WRITE')')
ifdef(`_RW', `', `define(`_RW', `TT_ARG_READ_WRITE')')
ifdef(`_R',  `', `define(`_R',  `TT_ARG_READ')')
ifdef(`_D',  `', `define(`_D',  `TT_ARG_DIE')')
ifdef(`_Z',  `', `define(`_Z',  `TT_ARG_ARRAY_Z')')
ifdef(`_A',  `', `define(`_A',  `TT_ARG_ARRAY($@)')')

c_comment(`
/*
 *  m4/TTclasses.m4h  --  header for libTT objects inheritance
 *                      used as template for a lot of autogenerated files.
 *
 *  Copyright (C) 2001,2002 by Massimiliano Ghilardi
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 */
')

divert(-1)

define(`TTtypelist', `el(void) el(ttbyte) el(ttshort) el(ttint) el(ttcol) el(ttfont) el(ttattr) el(ttopaque) el(ttany) el(ttfunction_fn) el(va_list) el(ttarg)')
define(`TTtypealiaslist', `el(ttsbyte,ttbyte) el(ttushort,ttshort) el(ttuint,ttint)')
define(`TTtypefirst', `void')
define(`TTtypelast', `ttarg')

define(`NSHIFT',  `ifdef(`NSHIFT$1', `NSHIFT$1($@)', `ifelse($1, 0, `shift($@)', `NSHIFT(decr($1), shift(shift($@)))')')')
define(`NSHIFT1', `shift(shift($@))')
define(`NSHIFT3', `shift(shift(shift(shift($@))))')
define(`NSHIFT6', `shift(shift(shift(shift(shift(shift(shift($@)))))))')
define(`NSHIFT9', `shift(shift(shift(shift(shift(shift(shift(shift(shift(shift($@))))))))))')

define(`merge', $1$2)

define(`TTnlist')
define(`TTlist')

define(`TTnappend',  `define(`TTlist', TTlist() el($1))')
define(`TTappend',  `define(`TTnlist', TTnlist() el($1))`'TTnappend($1)')


define(`_apply', `ifelse(`$2', `', `', `, $1(`$2')`'_apply(`$1', shift(shift($@)))')')
define(`apply', `ifelse(`$2', `', `', `$1(`$2')`'_apply(`$1', shift(shift($@)))')')

dnl define(`apply_nocomma', `ifelse(`$2', `', `', `$1(`$2')`'apply_nocomma(`$1', shift(shift($@)))')')

define(`_apply_nocomma', `ifelse(`$2', `', `', ` $1(`$2')`'_apply_nocomma(`$1', shift(shift($@)))')')
define(`apply_nocomma', `ifelse(`$2', `', `', `$1(`$2')`'_apply_nocomma(`$1', shift(shift($@)))')')

dnl define(`extract_args_decl_named', `regexp(`$1', `^[^(]*([^(]*)[^(]*(\(.*\))$', `\1')')


dnl
dnl We could have protected/public fields... for now, they all are just fields,
dnl and third argument can be one of:
dnl `'  : field is protected, clients cannot access it.
dnl `r' : field is public, clients can read it (so the method to read it
dnl       is autogenerated).
dnl `w' : field is public, clients can write it (this just means a method
dnl       to set it exists among public* or final* methods)
dnl

TTnappend(ttobj)
define(`TTdef_ttobj',`dnl
`'`'c_comment(`/** ttobj: The base class of all objects */')`'dnl
    field(,ttclass_$1,Class)`'dnl
    field(,ttopaque,id)`'dnl
')
define(`TTdef_ttclass_ttobj',`dnl
dnl also extends ttobj, manually keep in sync with TTdef_ttobj:
    protected(Class,$1,-1, _G0(,ttclass_ttclass,Class))`'dnl
    protected(id,$1,-1, _G0(,ttopaque,id))`'dnl
    protected(magicmask,$1,-1, _G0(,ttuint,magicmask))`'dnl
    protected(magic,$1,-1, _G0(,ttuint,magic))`'dnl
    protected(size,$1,-1, _G0(,ttuint,size))`'dnl
`'`'c_doxygen(`/** get `which' field value from ttobj `o' */')`'dnl
`'`'final_alt(GetField,$1,3, _G0(,ttbyte,), _G(_R,$1,o), _G(_R,ttfield,which), _G(_W _A((1)),ttarg *,value))`'dnl
`'`'c_doxygen(`/** set `which' field to `value' into ttobj `o' */')`'dnl
`'`'final_alt(SetField,$1,3, _G0(,ttbyte,), _G(  ,$1,o), _G(_R,ttfield,which), _G(_R _A((1)),ttarg *,value))`'dnl
`'`'c_doxygen(`/** change `which' field value into ttobj `o' */')`'dnl
`'`'final_alt(ChangeField,$1,3, _G0(,ttbyte,), _G(  ,$1,o), _G(_R,ttfield,which), _G(,ttany,nand_value), _G(,ttany,xor_value))`'dnl
')

TTappend(ttclass)
define(`TTdef_ttclass',`extends(ttobj,$1)`'dnl
`'`'c_comment(`/** ttclass: The runtime type of all objects */')`'dnl
dnl manually keep in sync with TTdef_class_ttobj:
    field(,ttuint,magicmask)`'dnl
    field(,ttuint,magic)`'dnl
    field(,ttuint,size)`'dnl
')
define(`TTdef_ttclass_ttclass',`extends(ttobj,$1)`'dnl
`'`'c_doxygen(`/** get the name of the ttclass `o' */')`'dnl
`'`'final_alt(GetName,$1,1, _G0(_R _Z,ttbyte *,), _G(_R,$1,o))`'dnl
`'`'c_doxygen(`/** get the size (bytes) used by objects of type represented by ttclass `o' */')`'dnl
`'`'final_alt(GetSize,$1,1, _G0(,ttopaque,), _G(_R,$1,o))`'dnl
`'`'c_doxygen(`/** get the parent class of the ttclass `o' */')`'dnl
`'`'final_alt(GetSuper,$1,1, _G0(_R,tt_class,), _G(_R,$1,o))`'dnl
`'`'c_doxygen(`/** return TT_TRUE if type `t' can be cast to type `o' */')`'dnl
`'`'final_alt(IsInstance,$1,2, _G0(,ttbyte,), _G(_R,$1,o), _G(_R,$1,t))`'dnl
`'`'c_doxygen(`/** get the bare class of given type (removing attribute like _R, _W, _D, _A((x))) */')`'dnl
`'`'final_alt(FromType,$1,1, _G0(_R,tt_class,), _G(,ttopaque,type))`'dnl
`'`'c_doxygen(`/** return TT_TRUE if given type indicates an array */')`'dnl
`'`'final_alt(IsArrayType,$1,1, _G0(,ttbyte,), _G(,ttopaque,type))`'dnl
`'`'c_doxygen(`/** return TT_TRUE if given type indicates a primitive type (not a ttobj or derivate) */')`'dnl
`'`'final_alt(IsPrimitiveType,$1,1, _G0(,ttbyte,), _G(,ttopaque,type))`'dnl
')


TTappend(ttobject)
define(`TTdef_ttobject', `extends(ttobj,$1)`'dnl
    field(,ttuint,refcount,r)`'dnl
    field(,ttuint,oflags,r)`'dnl
    field(,ttany,native)`'dnl
    field(,ttany,target_private)`'dnl
    field(,ttany,user_data,rw)`'dnl
    field(,ttopaque,events_inprogress,r)`'dnl
    field(,ttopaque,events_informed,r)`'dnl
')
define(`TTdef_ttclass_ttobject',`extends(ttobj,$1)`'dnl
    protected(New,  $1,2, _G0(,$1,), _G(_R,ttclass_$1,Class), _G(,$1,o))`'dnl
    protected(Build,$1,1, _G0(,$1,), _G(  ,$1,o))`'dnl
    protected(Break,$1,1, _G0(,void,), _G(  ,$1,o))`'dnl
    protected(Del,  $1,1, _G0(,void,), _G(_D,$1,o))`'dnl
`'`'c_doxygen(`/** increase by 1 the reference count of object `o' */')`'dnl
`'`'final(Ref,$1,1, _G0(,void,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** decrease by 1 the reference count of object `o' */')`'dnl
`'`'final(Unref,$1,1, _G0(,void,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** set `user_data' of object `o' */')`'dnl
`'`'final(SetUserData,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttany,user_data))`'dnl
')

TTappend(ttvector)
define(`TTdef_ttvector',`extends(ttobject,$1)`'dnl
`'`'c_comment(`/** ttvector: A generic vector (array) */')`'dnl
    field(,ttopaque,array_size,r)`'dnl
    field(,ttopaque,array_n,r)`'dnl
    field(_A((_F(array_n))),ttany *,array,r)`'dnl
')
define(`TTdef_ttclass_ttvector',`extends(ttobject,$1)`'dnl
`'`'c_doxygen(`/** get vector element at given position */')`'dnl
    public(GetAt,$1,2, _G0(,ttany,), _G(_R,$1,o), _G(,ttopaque,pos))`'dnl
`'`'c_doxygen(`/** set vector element at given position */')`'dnl
    public(SetAt,$1,3, _G0(,ttbyte,), _G(  ,$1,o), _G(,ttopaque,pos), _G(,ttany,value))`'dnl
dnl
`'`'c_doxygen(`/** create vector containing given value */')`'dnl
`'`'final(Create1,$1,1, _G0(,ttvector,), _G(,ttany,value))`'dnl
`'`'c_doxygen(`/** create vector containing given values */')`'dnl
`'`'final(CreateA,$1,3, _G0(,ttvector,), _G(,ttopaque,value_n), _G(_R _A((_P(1))),ttarg *,values))`'dnl
`'`'c_doxygen(`/** create vector containing given values */')`'dnl
`'`'final_var(CreateL,$1,2, _G0(,ttvector,), _G(,ttopaque,value_n), _G(,...,))`'dnl
`'`'c_doxygen(`/** create vector containing given values */')`'dnl
`'`'final(CreateR,$1,1, _G0(,ttvector,), _G(_R,$1,v))`'dnl
`'`'c_doxygen(`/** create vector containing given values */')`'dnl
`'`'final(CreateV,$1,2, _G0(,ttvector,), _G(,ttopaque,value_n), _G(_A((1)),va_list *,values))`'dnl
`'`'c_doxygen(`/** create vector containing given values */')`'dnl
`'`'final(CreateY,$1,2, _G0(,ttvector,), _G(,ttopaque,value_n), _G(_R _A((_P(1))),ttany *,values))`'dnl
dnl
`'`'c_doxygen(`/** add `value' at the end of the vector */')`'dnl
`'`'final(Append,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttany,value))`'dnl
`'`'c_doxygen(`/** add `value' at given pos of the vector */')`'dnl
`'`'final(Add,$1,3, _G0(,ttbyte,), _G(,$1,o), _G(,ttopaque,pos), _G(,ttany,value))`'dnl
`'`'c_doxygen(`/** add values at given position of ttvector `o' */')`'dnl
`'`'final(AddA,$1,4, _G0(,ttbyte,), _G(,$1,o), _G(,ttopaque,pos), _G(,ttopaque,value_n), _G(_R _A((_P(2))),ttarg *,values))`'dnl
`'`'c_doxygen(`/** add values at given position of ttvector `o' */')`'dnl
`'`'final_var(AddL,$1,4, _G0(,ttbyte,), _G(,$1,o), _G(,ttopaque,pos), _G(,ttopaque,value_n), _G(,...,))`'dnl
`'`'c_doxygen(`/** add values at given position of ttvector `o' */')`'dnl
`'`'final(AddR,$1,3, _G0(,ttbyte,), _G(,$1,o), _G(,ttopaque,pos), _G(_R,$1,v))`'dnl
`'`'c_doxygen(`/** add values at given position of ttvector `o' */')`'dnl
`'`'final(AddV,$1,4, _G0(,ttbyte,), _G(,$1,o), _G(,ttopaque,pos), _G(,ttopaque,value_n), _G(_A((1)),va_list *,values))`'dnl
`'`'c_doxygen(`/** add values at given position of ttvector `o' */')`'dnl
    public(AddY,$1,4, _G0(,ttbyte,), _G(,$1,o), _G(,ttopaque,pos), _G(,ttopaque,value_n), _G(_R _A((_P(2))),ttany *,values))`'dnl
dnl
`'`'c_doxygen(`/** search for the first occurrence of `value' in the vector */')`'dnl
    public(ContainsValue,$1,3, _G0(,ttopaque,), _G(_R,$1,o), _G(,ttopaque,pos_start), _G(,ttany,value))`'dnl
`'`'c_doxygen(`/** remove value at given pos of the vector */')`'dnl
`'`'final(RemoveAt,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttopaque,pos))`'dnl
`'`'c_doxygen(`/** remove given range of values from ttvector `o' */')`'dnl
    public(RemoveRange,$1,3, _G0(,ttbyte,), _G(,$1,o), _G(,ttopaque,pos_start), _G(,ttopaque,pos_n))`'dnl
')

TTappend(ttfield)
define(`TTdef_ttfield',`extends(ttobj,$1)`'dnl
`'`'c_comment(`/** ttfield: a reflective class, represents a field in an object */')`'dnl
    field(,ttopaque,name_len,r)`'dnl
    field(_R _Z,ttbyte *,name,r)`'dnl
    field(,ttopaque,type,r)`'dnl
')
define(`TTdef_ttclass_ttfield',`extends(ttobj,$1)`'dnl
`'`'c_doxygen(`/** get the field with given name */')`'dnl
`'`'final_alt(Get,$1,1, _G0(_R,$1,), _G(_R _Z,ttbyte *,name))`'dnl
`'`'c_doxygen(`/** get the value of field `f' in object `o' */')`'dnl
`'`'final_alt(GetValue,$1,3, _G0(,ttbyte,), _G(_R,$1,f), _G(_R,ttobject,o), _G(_W _A((1)),ttarg *,value))`'dnl
`'`'c_doxygen(`/** set the value of field `f' in object `o' */')`'dnl
`'`'final_alt(SetValue,$1,3, _G0(,ttbyte,), _G(_R,$1,f), _G(,ttobject,o), _G(_R _A((1)),ttarg *,value))`'dnl
`'`'c_doxygen(`/** change the value of field `f' in object `o' */')`'dnl
`'`'final_alt(ChangeValue,$1,4, _G0(,ttbyte,), _G(_R,$1,f), _G(,ttobject,o), _G(,ttany,nand_value), _G(,ttany,xor_value))`'dnl
`'`'c_doxygen(`/** return the ttuint representing field `f' in evcodes */')`'dnl
`'`'final_alt(ToEvcode,$1,1, _G0(,ttuint,), _G(_R,$1,f))`'dnl
`'`'c_doxygen(`/** return the field corresponding to ttuint `i' in evcodes */')`'dnl
`'`'final_alt(FromEvcode,$1,1, _G0(_R,$1,), _G(,ttuint,i))`'dnl
`'`'c_doxygen(`/** get the ttuint representing field `f' in evcodes given its name */')`'dnl
`'`'final_alt(GetEvcode,$1,1, _G0(,ttuint,), _G(_R _Z,ttbyte *,name))`'dnl
')


TTappend(ttmethod)
define(`TTdef_ttmethod',`extends(ttobj,$1)`'dnl
`'`'c_comment(`
/**
 * ttmethod: a reflective class, represents a method in an object.
 * It allows runtime inspecting the name, argument types and return types
 * of a method (i.e. almost any libTT function) and allows calling it.
 * 
 * There are 5 different ways to invoke a method using ttmethod objects:
 * TTCall{A,L,R,V,Y}_ttmethod().
 * Each one takes the method to call, the number of arguments you are passing to it
 * (but passing more arguments than needed is harmless), and respectively,
 * a (ttarg []), C variadic arg list, ttvector, (va_list *) or (tany []), of the arguments.
 *
 * A few libTT functions are not represented by ttmethods for various reasons,
 * thus cannot be inspected nor called using ttmethods:
 *
 * 1) functions not related to objects:
 *    TTCheckMagic(), TTOpen(), TTReopen(), TTClose(), TTCloseQuickNDirty(),
 *    TTConnectionFd(), TTInPanic(), TTFlush(), TTTimidFlush(), TTSync(),
 *    TTConfigAllocMem(), TTAllocMem(), TTReallocMem(), TTFreeMem(),
 *    TTMainLoop(), TTMainLoopOnce(), TTExitMainLoop()
 *
 * 2) variadic functions:
 *    TTCreateL_ttvector(), TTCallL_ttmethod()
 *
 */')`'dnl
    field(,ttopaque,name_len,r)`'dnl
    field(_R _A((_F(name_len))),ttbyte *,name,r)`'dnl
    field(,ttfunction_fn,address,r)`'dnl
    field(,ttopaque,return_type,r)`'dnl
    field(,ttvector,parameter_type,r)`'dnl
')
define(`TTdef_ttclass_ttmethod',`extends(ttobj,$1)`'dnl
`'`'c_doxygen(`/** get the method with given name */')`'dnl
`'`'final_alt(Get,$1,1, _G0(_R,$1,), _G(_R _Z,ttbyte *,name))`'dnl
`'`'c_doxygen(`/** get the method with given address */')`'dnl
`'`'final_alt(GetByAddress,$1,1, _G0(_R,$1,), _G(_R,ttfunction_fn,address))`'dnl
`'`'c_doxygen(`/** get the needed array length for the given method arg */')`'dnl
`'`'final_alt(GetArraySizeA,$1,3, _G0(,ttopaque,), _G(_R,$1,m), _G(,ttopaque,arg_array_n), _G(,ttopaque,args_n), _G(_R _A((_P(3))),ttarg *,args))`'dnl
`'`'c_doxygen(`/** check whether the given args have correct array lengths for the method */')`'dnl
`'`'final_alt(CheckArraySizesA,$1,3, _G0(,ttbyte,), _G(_R,$1,m), _G(,ttopaque,args_n), _G(_R _A((_P(2))),ttarg *,args))`'dnl
`'`'c_doxygen(`/** invoke the method `m' with given args */')`'dnl
`'`'final_alt(CallA,$1,4, _G0(,ttbyte,), _G(_R,$1,m), _G(_W _A((1)),ttarg *,return_value), _G(,ttopaque,args_n), _G(_R _A((_P(3))),ttarg *,args))`'dnl
`'`'c_doxygen(`/** invoke the method `m' with given args */')`'dnl
`'`'final_var(CallL,$1,4, _G0(,ttbyte,), _G(_R,$1,m), _G(_W _A((1)),ttarg *,return_value), _G(,ttopaque,args_n), _G(,...,))`'dnl
`'`'c_doxygen(`/** invoke the method `m' with given args */')`'dnl
`'`'final_alt(CallR,$1,3, _G0(,ttbyte,), _G(_R,$1,m), _G(_W _A((1)),ttarg *,return_value), _G(_R,ttvector,args))`'dnl
`'`'c_doxygen(`/** invoke the method `m' with given args */')`'dnl
`'`'final_alt(CallV,$1,4, _G0(,ttbyte,), _G(_R,$1,m), _G(_W _A((1)),ttarg *,return_value), _G(,ttopaque,args_n), _G(_A((1)),va_list *,args))`'dnl
`'`'c_doxygen(`/** invoke the method `m' with given args */')`'dnl
`'`'final_alt(CallY,$1,4, _G0(,ttbyte,), _G(_R,$1,m), _G(_W _A((1)),ttarg *,return_value), _G(,ttopaque,args_n), _G(_R _A((_P(3))),ttany *,args))`'dnl
')


define(`TTdef_ttclass_handymethods', `dnl
`'`'handy_method(LibraryVersion,,0, _G0(,ttuint,))`'dnl
`'`'handy_method(ExitMainLoop,,0, _G0(,void,))`'dnl
`'`'handy_method(New,,1, _G0(,ttobject,), _G(_R,ttclass,Class))`'dnl
`'`'handy_method(Del,,1, _G0(,void,), _G(_D,ttobject,o))`'dnl
`'`'handy_method(ClassOf,,1, _G0(_R,ttclass,), _G(_R,ttobj,o))`'dnl
`'`'handy_method(SuperClassOf,,1, _G(_R,ttclass,), _G(_R,ttobj,o))`'dnl
`'`'handy_method(InstanceOf,,2, _G0(,ttbyte,), _G(_R,ttclass,Class), _G(_R,ttobj,o))`'dnl
`'`'handy_method(ClassNameOf,,1, _G0(_R _Z,ttbyte *,), _G(_R,ttobj,o))`'dnl
')


TTappend(ttevent)
define(`TTdef_ttevent',`extends(ttobject,$1)`'dnl
`'`'c_comment(`/** ttevent: The common part of all events. */')`'dnl
    field(,ttcomponent,component,r)`'dnl
    field(,ttuint,evtype,r)`'dnl
    field(,ttuint,evcode,r)`'dnl
    field(,ttuint,evflags,r)`'dnl
    field(,ttevent,prev,r)`'dnl
    field(,ttevent,next,r)`'dnl
')
define(`TTdef_ttclass_ttevent',`extends(ttobject,$1)`'dnl
`'`'c_doxygen(`/** create a ttevent with given `evtype', `evcode' and `evflags' */')`'dnl
`'`'final(Create,$1,3, _G0(,ttevent,), _G(,ttuint,evtype), _G(,ttuint,evcode), _G(,ttuint,evflags))`'dnl
`'`'c_doxygen(`/** fire the ttevent `ev' on ttcomponent `o' */')`'dnl
`'`'final(Fire,$1,2, _G0(,void,), _G(_D,$1,ev), _G(_R,ttcomponent,o))`'dnl
')

TTappend(tteventbig)
define(`TTdef_tteventbig',`extends(ttevent,$1)`'dnl
`'`'c_comment(`/** tteventbig: The union of all events. */')`'dnl
    field(,ttshort,x,r)`'dnl
    field(,ttshort,y,r)`'dnl
    field(,ttshort,w,r)`'dnl
    field(,ttshort,h,r)`'dnl
    field(,ttany,value,r)`'dnl
    field(,ttany,old_value,r)`'dnl
    field(,ttopaque,data_len,r)`'dnl
    field(_R _A((_F(data_len))),ttbyte *,data,r)`'dnl
')
define(`TTdef_ttclass_tteventbig',`extends(ttevent,$1)`'dnl
`'`'c_doxygen(`/** create a tteventbig with given fields */')`'dnl
`'`'final(Create8,$1,11, _G0(,tteventbig,), _G(,ttuint,evtype), _G(,ttuint,evcode), _G(,ttuint,evflags)`'dnl
`'`'`'`'`', _G(,ttshort,x), _G(,ttshort,y), _G(,ttshort,w), _G(,ttshort,h), _G(,ttany,value), _G(,ttany,old_value)`'dnl
`'`'`'`'`', _G(,ttopaque,data_len), _G(_R _A((_P(10))),ttbyte *,data))`'dnl
`'`'c_doxygen(`/** create a tteventbig with given fields */')`'dnl
`'`'final(Create4,$1,7, _G0(,tteventbig,), _G(,ttuint,evtype), _G(,ttuint,evcode), _G(,ttuint,evflags)`'dnl
`'`'`'`'`', _G(,ttshort,x), _G0(,ttshort,y), _G(,ttshort,w), _G(,ttshort,h))`'dnl
`'`'c_doxygen(`/** create a tteventbig with given fields */')`'dnl
`'`'final(Create4s4,$1,7, _G0(,tteventbig,), _G(,ttuint,evtype), _G(,ttuint,evcode), _G(,ttuint,evflags)`'dnl
`'`'`'`'`', _G(,ttany,value), _G(,ttany,old_value), _G(,ttopaque,data_len), _G(_R _A((_P(6))),ttbyte *,data))`'dnl
')

TTappend(ttbitmask)
define(`TTdef_ttbitmask',`extends(ttobject,$1)`'dnl
`'`'c_comment(`/** ttbitmask: a bitmap mask of generic (ttany) values;
 * used, among others, to hold bitmaps of ttevent evtypes, evcodes and
 * components to block specific ttevents while calling event listeners.
 */')`'dnl
    field(,ttopaque,mask0)`'dnl
    field(,ttopaque,mask_max)`'dnl
    field(,ttopaque,mask_n)`'dnl
    field(_A((_F(mask_n))),ttany *,mask)`'dnl
')
define(`TTdef_ttclass_ttbitmask',`extends(ttobject,$1)`'dnl
`'`'c_doxygen(`/** create a ttbitmask with given value */')`'dnl
`'`'final(Create,$1,1, _G0(,ttbitmask,), _G(,ttany,value))`'dnl
`'`'c_doxygen(`/** create a ttbitmask equal to given one */')`'dnl
`'`'final(CreateB2,$1,1, _G0(,ttbitmask,), _G(_R,$1,o))`'dnl
`'`'c_doxygen(`/** create a ttbitmask with given `value' array and swallow `value' */')`'dnl
`'`'final(CreateR,$1,1, _G0(,ttbitmask,), _G(_D,ttvector,value))`'dnl
`'`'c_doxygen(`/** create a ttbitmask with a copy of given `value' array */')`'dnl
`'`'final(CreateR2,$1,1, _G0(,ttbitmask,), _G(_R,ttvector,value))`'dnl
`'`'c_doxygen(`/** initialize the ttbitmask `o' to empty */')`'dnl
`'`'final(Clear,$1,1, _G0(,void,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** initialize the ttbitmask `o' to full */')`'dnl
`'`'final(Fill,$1,1, _G0(,void,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** negate (i.e. make complement of) the ttbitmask `o' */')`'dnl
`'`'final(Negate,$1,1, _G0(,void,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** change ttbitmask `o' applying given truth table (i.e. logical operation) */')`'dnl
`'`'final(Change,$1,2, _G0(,void,), _G(,$1,o), _G(,ttuint,truth_table))`'dnl
`'`'c_doxygen(`/** check whether `value' is member of the ttbitmask `o' */')`'dnl
`'`'final(Contains,$1,2, _G0(,ttbyte,), _G(_R,$1,o), _G(,ttany,value))`'dnl
`'`'c_doxygen(`/** add `value' to the ttbitmask `o' */')`'dnl
`'`'final(Add,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttany,value))`'dnl
`'`'c_doxygen(`/** add `value' bitmask to the ttbitmask `o' */')`'dnl
`'`'final(AddB,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_R,$1,value))`'dnl
`'`'c_doxygen(`/** add `value' array to the ttbitmask `o' */')`'dnl
`'`'final(AddR,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_R,ttvector,value))`'dnl
`'`'c_doxygen(`/** remove `value' from the ttbitmask `o' */')`'dnl
`'`'final(Remove,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttany,value))`'dnl
`'`'c_doxygen(`/** remove `value' bitmask from the ttbitmask `o' */')`'dnl
`'`'final(RemoveB,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_R,$1,value))`'dnl
`'`'c_doxygen(`/** remove `value' array from the ttbitmask `o' */')`'dnl
`'`'final(RemoveR,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_R,ttvector,value))`'dnl
`'`'c_doxygen(`/** combine ttbitmask `o' with `value' appling given truth table (i.e. logical operation) */')`'dnl
`'`'final(Combine,$1,3, _G0(,ttbyte,), _G(,$1,o), _G(,ttany,value), _G(,ttuint,truth_table))`'dnl
`'`'c_doxygen(`/** combine ttbitmask `o' with `value' array appling given truth table (i.e. logical operation) */')`'dnl
`'`'final(CombineR,$1,3, _G0(,ttbyte,), _G(,$1,o), _G(_R,ttvector,value), _G(,ttuint,truth_table))`'dnl
`'`'c_doxygen(`/** combine ttbitmask `o' with `value' appling given truth table (i.e. logical operation) */')`'dnl
`'`'final(CombineB,$1,3, _G0(,ttbyte,), _G(,$1,o), _G(_R,$1,value), _G(,ttuint,truth_table))`'dnl
')

TTappend(tteventmask)
define(`TTdef_tteventmask',`extends(ttobject,$1)`'dnl
`'`'c_comment(`/** tteventmask: a set of ttbitmasks used to block
 * events matching certain criteria */')`'dnl
    field(,ttbitmask,evtype_mask,rw)`'dnl
    field(,ttbitmask,evcode_mask,rw)`'dnl
    field(,ttbitmask,component_mask,rw)`'dnl
    field(,ttuint,truth_table,rw)`'dnl
')
define(`TTdef_ttclass_tteventmask',`extends(ttobject,$1)`'dnl
`'`'c_doxygen(`/** create a tteventmask with given fields and swallow the bitmasks */')`'dnl
`'`'final(CreateB,$1,3, _G0(,tteventmask,), _G(_D,ttbitmask,evtype_mask), _G(_D,ttbitmask,evcode_mask), _G(_D,ttbitmask,component_mask))`'dnl
`'`'c_doxygen(`/** create a tteventmask with a copy of given bitbasks */')`'dnl
`'`'final(CreateB2,$1,3, _G0(,tteventmask,), _G(_R,ttbitmask,evtype_mask), _G(_R,ttbitmask,evcode_mask), _G(_R,ttbitmask,component_mask))`'dnl
`'`'c_doxygen(`/** set the mask of blocked event types and swallow the evtype bitmask */')`'dnl
`'`'final(SetEvtypeMask,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_D,ttbitmask,evtype_mask))`'dnl
`'`'c_doxygen(`/** set the mask of blocked event codes and swallow the evtype bitmask */')`'dnl
`'`'final(SetEvcodeMask,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_D,ttbitmask,evcode_mask))`'dnl
`'`'c_doxygen(`/** set the mask of blocked event types and swallow the evtype bitmask */')`'dnl
`'`'final(SetComponentMask,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_D,ttbitmask,component_mask))`'dnl
`'`'c_doxygen(`/** set the truth table to combine masks of evtypes, evcodes and components of blocked events */')`'dnl
`'`'final(SetTruthTable,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttuint,truth_table))`'dnl
')


TTappend(ttcallback)
define(`TTdef_ttcallback',`extends(ttobject,$1)`'dnl
`'`'c_comment(`/** ttcallback: The entry point for internal event-based callbacks from target drivers */')`'dnl
    field(,ttuint,lflags,r)`'dnl
    field(,ttcomponent,component,r)`'dnl
    field(,$1,prev,r)`'dnl
    field(,$1,next,r)`'dnl
')
define(`TTdef_ttclass_ttcallback',`extends(ttobject,$1)`'dnl
    protected(Create,$1,1, _G0(,ttcallback,), _G(,ttcomponent,o))`'dnl
')

TTappend(ttlistener)
define(`TTdef_ttlistener',`extends(ttcallback,$1)`'dnl
`'`'c_comment(`/** ttlistener: A ttcallback derivative for user-set event-based callbacks */')`'dnl
    field(,s_ttavl,AVL)`'dnl
    field(,ttevent,event,r)`'dnl
    field(,ttlistener_fn,function,r)`'dnl
    field(,ttopaque,arg_component_n,r)`'dnl
    field(,ttopaque,arg_event_n,r)`'dnl
    field(,ttvector,args,r)`'dnl
    field(,tteventmask,event_mask,rw)`'dnl
    field(,ttlistener,inprogress_prev)`'dnl
    field(,ttlistener,inprogress_next)`'dnl
')
define(`TTdef_ttclass_ttlistener',`extends(ttcallback,$1)`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent with given fields */')`'dnl
`'`'final(Create,$1,5, _G0(,ttlistener,), _G(,ttcomponent,o), _G(,ttuint,evtype)`'dnl
`'`'`'`'`', _G(,ttuint,lflags), _G(_R,ttlistener_fn,function), _G(,ttany,arg))`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent with given fields */')`'dnl
`'`'final(CreateE,$1,5, _G0(,ttlistener,), _G(,ttcomponent,o), _G(_D,ttevent,ev)`'dnl
`'`'`'`'`', _G(,ttuint,lflags), _G(_R,ttlistener_fn,function), _G(,ttany,arg))`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent with given fields */')`'dnl
`'`'final(CreateR,$1,7, _G0(,ttlistener,), _G(,ttcomponent,o), _G(_D,ttevent,ev)`'dnl
`'`'`'`'`', _G(,ttuint,lflags), _G(_R,ttlistener_fn,function), _G(,ttopaque,arg_component_n)`'dnl
`'`'`'`'`', _G(,ttopaque,arg_event_n), _G(_D,ttvector,args))`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent "del" ttevent with given fields */')`'dnl
`'`'final(CreateDel,$1,3, _G0(,ttlistener,), _G(,ttcomponent,o), _G(,ttuint,lflags), _G(_R,ttlistener_fn,function))`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent "askclose" ttevent with given fields */')`'dnl
`'`'final(CreateAskclose,$1,3, _G0(,ttlistener,), _G(,ttcomponent,o), _G(,ttuint,lflags), _G(_R,ttlistener_fn,function))`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent "key" ttevent with given fields */')`'dnl
`'`'final(CreateKey,$1,5, _G0(,ttlistener,), _G(,ttcomponent,o), _G(,ttuint,evcode)`'dnl
`'`'`'`'`', _G(,ttuint,evflags), _G(,ttuint,lflags), _G(_R,ttlistener_fn,function))`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent "mouse" ttevent with given fields */')`'dnl
`'`'final(CreateMouse,$1,5, _G0(,ttlistener,), _G(,ttcomponent,o), _G(,ttuint,evcode)`'dnl
`'`'`'`'`', _G(,ttuint,evflags), _G(,ttuint,lflags), _G(_R,ttlistener_fn,function))`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent "activate" ttevent with given fields */')`'dnl
`'`'final(CreateActivate,$1,3, _G0(,ttlistener,), _G(,ttcomponent,o), _G(,ttuint,lflags), _G(_R,ttlistener_fn,function))`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent "value change" ttevent with given fields */')`'dnl
`'`'final(CreateChange,$1,4, _G0(,ttlistener,), _G(,ttcomponent,o), _G(,ttuint,evcode), _G(,ttuint,lflags), _G(_R,ttlistener_fn,function))`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent "key_data value change" ttevent with given fields (WARNING: listener will be called with `ttdata' as event component!)*/')`'dnl
`'`'final(CreateKeyData,$1,4, _G0(,ttlistener,), _G(,ttcomponent,o), _G(_R _Z,ttbyte *,key), _G(,ttuint,lflags), _G(_R,ttlistener_fn,function))`'dnl
`'`'c_doxygen(`/** create a ttlistener for a ttcomponent "expose" ttevent with given fields */')`'dnl
`'`'final(CreateExpose,$1,3, _G0(,ttlistener,), _G(,ttcomponent,o), _G(,ttuint,lflags), _G(_R,ttlistener_fn,function))`'dnl
`'`'dnl
`'`'c_doxygen(`/** add `o' to the ttcomponent `c' */')`'dnl
    public(AddTo,$1,2, _G0(,void,), _G(,$1,o), _G(,ttcomponent,c))`'dnl
`'`'c_doxygen(`/** remove `o' from the ttcomponent it is attached to */')`'dnl
    public(Remove,$1,1, _G0(,void,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** set the function args of the listener `o' */')`'dnl
`'`'final(SetArgsR,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_D,ttvector,args))`'dnl
`'`'c_doxygen(`/** set the mask of blocked events to be used while listener `o' is being called */')`'dnl
`'`'final(SetEventMask,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_D,tteventmask,event_mask))`'dnl
')

TTappend(tttimer)
define(`TTdef_tttimer',`extends(ttlistener,$1)`'dnl
`'`'c_comment(`/** tttimer: A ttlistener derivative for timer-based callbacks */')`'dnl
    field(,ttany,delay_t,r)`'dnl
    field(,ttany,delay_f,r)`'dnl
    field(,tttimer,timer_prev,r)`'dnl
    field(,tttimer,timer_next,r)`'dnl
')
define(`TTdef_ttclass_tttimer',`extends(ttlistener,$1)`'dnl
`'`'c_doxygen(`/** create a tttimer with given fields */')`'dnl
`'`'final(CreateR,$1,8, _G0(,tttimer,), _G(,ttcomponent,r), _G(,ttuint,lflags), _G(_R,ttlistener_fn,function)`'dnl
`'`'`'`'`', _G(,ttopaque,arg_component_n), _G(,ttopaque,arg_timer_n), _G(_D,ttvector,args), _G(,ttany,delay_t), _G(,ttany,delay_f))`'dnl
`'`'c_doxygen(`/** create a tttimer with given fields */')`'dnl
`'`'final(Create,$1,6, _G0(,tttimer,), _G(,ttcomponent,r), _G(,ttuint,lflags), _G(_R,ttlistener_fn,function)`'dnl
`'`'`'`'`', _G(,ttany,arg), _G(,ttany,delay_t), _G(,ttany,delay_f))`'dnl
`'`'c_doxygen(`/** set delay (seconds and fraction of seconds) */')`'dnl
`'`'final(SetDelay,$1,3, _G0(,void,), _G(,$1,o), _G(,ttany,delay_t), _G(,ttany,delay_s))`'dnl
`'`'c_doxygen(`/** enable or disable tttimer `o' */')`'dnl
    public(SetEnabled,$1,2, _G0(,void,), _G(,$1,o), _G(,ttbyte,enabled))`'dnl
`'`'c_doxygen(`/** get whether tttimer `o' is enabled or disabled */')`'dnl
    public(IsEnabled,$1,1, _G0(,ttbyte,), _G(_R,$1,o))`'dnl
')

TTappend(ttcomponent)
define(`TTdef_ttcomponent',`extends(ttobject,$1)`'dnl
`'`'c_comment(`/** ttcomponent: The superclass of all components (visible objects, groups, applications, ...) */')`'dnl
    field(,ttcallback,callbacks,r)`'dnl
    field(,ttlistener,listeners,r)`'dnl
    field(,tttimer,timers,r)`'dnl
    field(,ttdata,datas,r)`'dnl
')
define(`TTdef_ttclass_ttcomponent',`extends(ttobject,$1)`'dnl
`'`'c_doxygen(`/** add the ttlistener `c' to `o' */')`'dnl
`'`'final(AddListener,$1,2, _G0(,void,), _G(,$1,o), _G(,ttlistener,l))`'dnl
`'`'c_doxygen(`/** remove the ttlistener `c' from `o' */')`'dnl
`'`'final(RemoveListener,$1,2, _G0(,void,), _G(,$1,o), _G(,ttlistener,l))`'dnl
`'`'c_doxygen(`/** associate `data' with `key' in ttcomponent `o' */')`'dnl
`'`'final(SetKeyData,$1,3, _G0(,ttdata,), _G(,$1,o), _G(_R _Z,ttbyte *,key), _G(,ttany,data))`'dnl
`'`'c_doxygen(`/** get `data' associated with with `key' in ttcomponent `o' */')`'dnl
`'`'final(GetKeyData,$1,2, _G0(,ttany,), _G(_R,$1,o), _G(_R _Z,ttbyte *,key))`'dnl
`'`'c_doxygen(`/** remove `data' associated with `key' in ttcomponent `o' */')`'dnl
`'`'final(UnsetKeyData,$1,2, _G0(,void,), _G(,$1,o), _G(_R _Z,ttbyte *,key))`'dnl
`'`'c_doxygen(`/** get the ttdata containing `data' associated with with `key' in ttcomponent `o' */')`'dnl
`'`'final(GetData,$1,2, _G0(,ttdata,), _G(_R,$1,o), _G(_R _Z,ttbyte *,key))`'dnl
')

TTappend(ttdata)
define(`TTdef_ttdata',`extends(ttcomponent,$1)`'dnl
`'`'c_comment(`/**
 * ttdata: wrapper for user-defined data in ttcomponents;
 * this class is derived from ttcomponent to allow creating listeners on it,
 * but this implementation has the undesired side effect that you can
 * TT{Set,Get,Unset}KeyData_ttcomponent also on ttdatas themselves.
 */')`'dnl
    field(,s_ttavl,AVL)`'dnl
    field(,ttcomponent,component,r)`'dnl
    field(,ttopaque,key_len,r)`'dnl
    field(_A((_F(key_len))),ttbyte *,key,r)`'dnl
    field(,ttany,data,rw)`'dnl
')
define(`TTdef_ttclass_ttdata',`extends(ttcomponent,$1)`'dnl
dnl c_doxygen(`/** add `data' to the ttcomponent `c' */')`'dnl
    protected(AddTo,$1,2, _G0(,void,), _G(,$1,data), _G(,ttcomponent,c))`'dnl
dnl c_doxygen(`/** remove `data' from the ttcomponent it is associated to */')`'dnl
    protected(Remove,$1,1, _G0(,void,), _G(,$1,data))`'dnl
`'`'c_doxygen(`/** set the data in ttdata `o' */')`'dnl
`'`'final(SetData,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttany,data))`'dnl
')


TTappend(ttvisible)
define(`TTdef_ttvisible',`extends(ttcomponent,$1)`'dnl
`'`'c_comment(`/** ttvisible: The superclass of all visible objects */')`'dnl
    field(,ttuint,vflags,r)`'dnl
    field(,ttvisible,prev,r)`'dnl
    field(,ttvisible,next,r)`'dnl
    field(,ttvisible,parent,r)`'dnl
    field(,ttvisible,child_first,r)`'dnl
    field(,ttvisible,child_last,r)`'dnl
    field(,ttany,constraint,r)`'dnl
    field(,tttheme,theme,rw)`'dnl
    field(,ttvisible_repaint_fn,repaint,rw)`'dnl
')
define(`TTdef_ttclass_ttvisible',`extends(ttcomponent,$1)`'dnl
`'`'c_doxygen(`/** add the ttvisible `o' into `parent' */')`'dnl
    public_set(AddTo,$1,3, _G0(,void,), _G(,$1,o), _G(,ttvisible,parent), _G(,ttany,constraint))`'dnl
`'`'c_doxygen(`/** apply layout the children of current component */')`'dnl
    public(Validate,$1,1, _G0(,void,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** remove the ttvisible `o' from its parent */')`'dnl
    public_set(Remove,$1,1, _G0(,void,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** invalidate ttvisible `o' internal caches (to force redrawing it) */')`'dnl
    public(Invalidate,$1,1, _G0(,void,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** set the ttvisible `o' to be visible or not */')`'dnl
    public_set(SetVisible,$1,2, _G0(,void,), _G(,$1,o), _G(,ttbyte,visible))`'dnl
`'`'c_doxygen(`/** set the tttheme `theme' of the ttvisible `o' */')`'dnl
    public_set(SetTheme,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_R,tttheme,theme))`'dnl
`'`'c_doxygen(`/** actually draw (part of) the contents of the ttvisible `o' - internally called by TTBuiltinRepaint_ttvisible */')`'dnl
    public(Draw,$1,9, _G0(,void,), _G(,$1,o), _G(,ttshort,x), _G(,ttshort,y), _G(,ttshort,w), _G(,ttshort,h), _G(,ttshort,pitch)`'dnl
`'`'`'`'`', _G(_R _A((_P(5),*,_P(6))),ttbyte *,asciidata), _G(_R _A((_P(5),*,_P(6))),ttfont *,fontdata), _G(_R _A((_P(5),*,_P(6))),ttattr *,attrdata))`'dnl
`'`'c_doxygen(`/** internal libTT method that repaints (part of) the ttvisible `o' using its theme */')`'dnl
    public(BuiltinRepaint,$1,5, _G0(,void,), _G(,$1,o), _G(,ttshort,x), _G(,ttshort,y), _G(,ttshort,w), _G(,ttshort,h))`'
`'`'c_doxygen(`/** change the internal libTT method used to repaint (part of) the ttvisible `o' */')`'dnl
`'`'final(SetRepaint,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_R,ttvisible_repaint_fn,repaint))`'dnl
`'`'c_doxygen(`/** request a repaint for the given part of the ttvisible `o' */')`'dnl
`'`'final(Expose,$1,5, _G0(,void,), _G(,$1,o), _G(,ttshort,x), _G(,ttshort,y), _G(,ttshort,w), _G(,ttshort,h))`'dnl
`'`'c_doxygen(`/** add the ttvisible `child' into `o' */')`'dnl
`'`'final(Add,$1,3, _G0(,void,), _G(,$1,o), _G(,ttvisible,child), _G(,ttany,constraint))`'dnl
')

TTappend(ttlayout)
define(`TTdef_ttlayout',`extends(ttcomponent,$1)`'dnl
`'`'c_comment(`/** ttlayout: The superclass of all layouts */')`'dnl
    field(,ttwidget,widget,r)`'dnl
')
define(`TTdef_ttclass_ttlayout',`extends(ttcomponent,$1)`'dnl
`'`'c_doxygen(`/** set the current widget */')`'dnl
    protected(SetWidget,$1,2, _G0(,void,), _G(,$1,o), _G(,ttwidget,w))`'dnl
`'`'c_doxygen(`/** apply layout to the contents of current widget */')`'dnl
    protected(DoLayout,$1,1, _G0(,void,), _G(,$1,o))`'dnl
')

TTappend(ttboxlayout)
define(`TTdef_ttboxlayout',`extends(ttlayout,$1)`'dnl
`'`'c_comment(`/** ttlayout: a box (horizontal or vertical) layout */')`'dnl
    field(,ttuint,orientation,r)`'dnl
')
define(`TTdef_ttclass_ttboxlayout',`extends(ttlayout,$1)`'dnl
`'`'c_doxygen(`/** create a ttboxlayout with given orientation */')`'dnl
`'`'final(Create,$1,1, _G0(,ttboxlayout,), _G(,ttany,orientation))`'dnl
')


TTappend(ttborderlayout)
define(`TTdef_ttborderlayout',`extends(ttlayout,$1)`'dnl
`'`'c_comment(`/** ttlayout: a border (north+south+west+east+center) layout */')`'dnl
')
define(`TTdef_ttclass_ttborderlayout',`extends(ttlayout,$1)`'dnl
')


TTappend(ttnative)
define(`TTdef_ttnative',`extends(ttvisible,$1)`'dnl
`'`'c_comment(`/** ttnative: class representing all server visible objects not created by us */')`'dnl
')
define(`TTdef_ttclass_ttnative',`extends(ttvisible,$1)`'dnl
`'`'c_doxygen(`/** get the ttnative `root' object into which each top level ttvisible is added */')`'dnl
    public(GetRoot,$1,0, _G0(,ttnative,))`'dnl
`'`'c_doxygen(`/** get `w' (width) field of given ttnative */')`'dnl
    public(GetW,$1,1, _G0(,ttshort,), _G(_R,$1,o))`'dnl
`'`'c_doxygen(`/** get `h' (height) field of given ttnative */')`'dnl
    public(GetH,$1,1, _G0(,ttshort,), _G(_R,$1,o))`'dnl
`'`'c_doxygen(`/** create a ttnative with given fields */')`'dnl
`'`'final(Create,$1,1, _G0(,ttnative,), _G(,ttany,native_value))`'dnl
')

TTappend(ttwidget)
define(`TTdef_ttwidget',`extends(ttvisible,$1)`'dnl
`'`'c_comment(`/** ttwidget: The superclass of all window-like visible containers */')`'dnl
    field(,ttshort,x,rw)`'dnl
    field(,ttshort,y,rw)`'dnl
    field(,ttshort,w,rw)`'dnl
    field(,ttshort,h,rw)`'dnl
    field(,ttlayout,layout,r)`'dnl
    field(,ttint,xl,rw)`'dnl
    field(,ttint,yl,rw)`'dnl
    field(,ttint,wl,rw)`'dnl
    field(,ttint,hl,rw)`'dnl
    field(,ttcol,col,r)`'dnl
    field(,tttooltip,tooltip,rw)`'dnl
')
define(`TTdef_ttclass_ttwidget',`extends(ttvisible,$1)`'dnl
`'`'c_doxygen(`/** set the layout of the ttvisible `o' */')`'dnl
    public_set(SetLayout,$1,2, _G0(,void,), _G(,$1,o), _G(,ttlayout,l))`'dnl
`'`'c_doxygen(`/** set the position `x' and `y' of the ttwidget `o' */')`'dnl
    public_set(SetXY,$1,3, _G0(,ttbyte,), _G(,$1,o), _G(,ttshort,x), _G(,ttshort,y))`'dnl
`'`'c_doxygen(`/** set the size `w' and `h' of the ttwidget `o' */')`'dnl
    public_set(SetWH,$1,3, _G0(,ttbyte,), _G(,$1,o), _G(,ttshort,w), _G(,ttshort,h))`'dnl
`'`'c_doxygen(`/** set the inside scroll position `xl' of the ttwidget `o' */')`'dnl
    public_set(SetXl,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,xl))`'dnl
`'`'c_doxygen(`/** set the inside scroll position `yl' of the ttwidget `o' */')`'dnl
    public_set(SetYl,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,yl))`'dnl
`'`'c_doxygen(`/** set the inside scroll size `wl' of the ttwidget `o' */')`'dnl
    public_set(SetWl,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,wl))`'dnl
`'`'c_doxygen(`/** set the inside scroll size `hl' of the ttwidget `o' */')`'dnl
    public_set(SetHl,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,hl))`'dnl
`'`'c_doxygen(`/** set the the tttooltip of the ttwidget `o' */')`'dnl
    public_set(SetTooltip,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_D,tttooltip,t))`'dnl
`'`'c_doxygen(`/** set some (depeding on `mask') of the inside scroll position `xl' and `yl' of the ttwidget `o' */')`'dnl
`'`'final(SetXlYl,$1,4, _G0(,ttbyte,), _G(,$1,o), _G(,ttuint,mask), _G(,ttint,xl), _G(,ttint,yl))`'dnl
`'`'c_doxygen(`/** set some (depeding on `mask') of the inside scroll sizes `wl' and `hl' of the ttwidget `o' */')`'dnl
`'`'final(SetWlHl,$1,4, _G0(,ttbyte,), _G(,$1,o), _G(,ttuint,mask), _G(,ttint,wl), _G(,ttint,hl))`'dnl
`'`'c_doxygen(`/** set some (depeding on `mask') of the position `x' and `y' and the size `w' and `h' of the ttwidget `o' */')`'dnl
`'`'final(SetXYWH,$1,6, _G0(,ttbyte,), _G(,$1,o), _G(,ttuint,mask), _G(,ttshort,x), _G(,ttshort,y), _G(,ttshort,w), _G(,ttshort,h))`'dnl
`'`'c_doxygen(`/** set the position `x' of the ttwidget `o' */')`'dnl
`'`'final(SetX,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttshort,x))`'dnl
`'`'c_doxygen(`/** set the position `y' of the ttwidget `o' */')`'dnl
`'`'final(SetY,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttshort,y))`'dnl
`'`'c_doxygen(`/** set the size `w' of the ttwidget `o' */')`'dnl
`'`'final(SetW,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttshort,w))`'dnl
`'`'c_doxygen(`/** set the size `h' of the ttwidget `o' */')`'dnl
`'`'final(SetH,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttshort,h))`'dnl
')

TTappend(ttlabel)
define(`TTdef_ttlabel',`extends(ttwidget,$1)`'dnl
`'`'c_comment(`/** ttlabel: A simple text label */')`'dnl
    field(,ttopaque,text_len,r)`'dnl
    field(_A((_F(text_len))),ttfont *,text,r)`'dnl
')
define(`TTdef_ttclass_ttlabel',`extends(ttwidget,$1)`'dnl
`'`'c_doxygen(`/** set the text of the ttlabel `o' and swallow `text' */')`'dnl
    public_set(SetFontD,$1,3, _G0(,void,), _G(,$1,o), _G(,ttopaque,text_len), _G(_D _A((_P(2))),ttfont *,text))`'dnl
`'`'c_doxygen(`/** set the text of the ttlabel `o' to a copy of `text' */')`'dnl
`'`'final(SetFont,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_R _Z,ttfont *,text))`'dnl
`'`'c_doxygen(`/** set the text of the ttlabel `o' to a copy of `text' */')`'dnl
`'`'final(SetText,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_R _Z,ttbyte *,text))`'dnl
`'`'c_doxygen(`/** create a ttlabel with a copy of given text */')`'dnl
`'`'final(Create,$1,1, _G0(,ttlabel,), _G(_R _Z,ttbyte *,text))`'dnl
')

TTappend(tttooltip)
define(`TTdef_tttooltip',`extends(ttlabel,$1)`'dnl
`'`'c_comment(`/** tttooltip: A simple tooltip */')`'dnl
    field(,ttopaque,widget_id)`'dnl
    field(,ttwidget,widget,r)`'dnl
')
define(`TTdef_ttclass_tttooltip',`extends(ttlabel,$1)`'dnl
`'`'c_doxygen(`/** set the widget the tttooltip `o' is connected to */')`'dnl
    public_set(SetWidget,$1,2, _G0(,ttbyte,), _G(_D,$1,o), _G(,ttwidget,w))`'dnl
')

TTappend(ttbuttongroup)
define(`TTdef_ttbuttongroup',`extends(ttcomponent,$1)`'dnl
`'`'c_comment(`/** ttbuttongroup: a mutual-exclusion group of radiobuttons */')`'dnl
    field(,ttradiobutton,group_first,r)`'dnl
    field(,ttradiobutton,group_last,r)`'dnl
    field(,ttradiobutton,checked,r)`'dnl
')
define(`TTdef_ttclass_ttbuttongroup',`extends(ttcomponent,$1)`'dnl
`'`'c_doxygen(`/** add the ttradiobutton `r' to the ttbuttongroup `o' */')`'dnl
    public_set(Add,$1,2, _G0(,void,), _G(,$1,o), _G(,ttradiobutton,r))`'dnl
`'`'c_doxygen(`/** remove the ttradiobutton `r' from the ttbuttongroup `o' */')`'dnl
    public_set(Remove,$1,2, _G0(,void,), _G(,$1,o), _G(,ttradiobutton,r))`'dnl
`'`'c_doxygen(`/** set which ttradiobutton in the ttbuttongroup `o' is checked */')`'dnl
    public_set(SetChecked,$1,2, _G0(,void,), _G(,$1,o), _G(,ttradiobutton,r))`'dnl
')

TTappend(ttanybutton)
define(`TTdef_ttanybutton',`extends(ttwidget,$1)`'dnl
`'`'c_comment(`/** ttanybutton: the abstract class all buttons are derived from */')`'dnl
    field(,ttshort,text_width,r)`'dnl
    field(,ttshort,text_height,r)`'dnl
    field(_A((_F(text_width),*,_F(text_height))),ttattr *,text,r)`'dnl
`'`'dnl cheat: we define enough space for all derived objects shapes
    field(,struct s_ttshape,theme_shape[ttderived_ttanybutton_shape_max])`'dnl
')
define(`TTdef_ttclass_ttanybutton',`extends(ttwidget,$1)`'dnl
    protected(CacheThemeShape,$1,1, _G0(,ttuint,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** set the text of the ttanybutton `o' and swallow `text' */')`'dnl
    public_set(SetAttrD,$1,5, _G0(,void,), _G(,$1,o), _G(,ttshort,w), _G(,ttshort,h), _G(,ttshort,pitch), _G(_D _A((_P(3),*,_P(4))),ttattr *,text))`'dnl
`'`'c_doxygen(`/** set the text of the ttanybutton `o' to a copy of `text' */')`'dnl
`'`'final(SetAttr,$1,5, _G0(,ttbyte,), _G(,$1,o), _G(,ttshort,w), _G(,ttshort,h), _G(,ttshort,pitch), _G(_R _A((_P(3),*,_P(4))),ttattr *,text))`'dnl
`'`'c_doxygen(`/** set the text of the ttanybutton `o' to a copy of `text' */')`'dnl
`'`'final(SetFont,$1,5, _G0(,ttbyte,), _G(,$1,o), _G(,ttshort,w), _G(,ttshort,h), _G(,ttshort,pitch), _G(_R _A((_P(3),*,_P(4))),ttfont *,text))`'dnl
`'`'c_doxygen(`/** set the text of the ttanybutton `o' to a copy of `text' */')`'dnl
`'`'final(SetText,$1,5, _G0(,ttbyte,), _G(,$1,o), _G(,ttshort,w), _G(,ttshort,h), _G(,ttshort,pitch), _G(_R _A((_P(3),*,_P(4))),ttbyte *,text))`'dnl
`'`'c_doxygen(`/** create a ttanybutton with a copy of given text */')`'dnl
`'`'final(Create,$1,4, _G0(,ttanybutton,), _G(,ttshort,w), _G(,ttshort,h), _G(,ttshort,pitch), _G(_R _A((_P(2),*,_P(3))),ttbyte *,text))`'dnl
')

TTappend(ttbutton)
define(`TTdef_ttbutton',`extends(ttanybutton,$1)`'dnl
`'`'c_comment(`/** ttbutton: a normal click-to-activate button */')`'dnl
')
define(`TTdef_ttclass_ttbutton',`extends(ttanybutton,$1)`'dnl
`'`'c_doxygen(`/** set whether the ttbutton `o' is pressed or not */')`'dnl
    public_set(SetPressed,$1,2, _G0(,void,), _G(,$1,o), _G(,ttbyte,pressed))`'dnl
`'`'c_doxygen(`/** get whether the ttbutton `o' is pressed or not */')`'dnl
`'`'final(IsPressed,$1,1, _G0(,ttbyte,), _G(_R,$1,o))`'dnl
`'`'c_doxygen(`/** create a ttbutton with given text */')`'dnl
`'`'final(Create,$1,4, _G0(,ttbutton,), _G(,ttshort,w), _G(,ttshort,h), _G(,ttshort,pitch), _G(_R _A((_P(2),*,_P(3))),ttbyte *,text))`'dnl
')

TTappend(ttcheckbutton)
define(`TTdef_ttcheckbutton',`extends(ttbutton,$1)`'dnl
`'`'c_comment(`/** ttcheckbutton: a two-state (on/off) button */')`'dnl
')
define(`TTdef_ttclass_ttcheckbutton',`extends(ttbutton,$1)`'dnl
`'`'c_doxygen(`/** set whether the ttbutton `o' is checked or not */')`'dnl
    public_set(SetChecked,$1,2, _G0(,void,), _G(,$1,o), _G(,ttbyte,checked))`'dnl
`'`'c_doxygen(`/** get whether the ttbutton `o' is checked or not */')`'dnl
`'`'final(IsChecked,$1,1, _G0(,ttbyte,), _G(_R,$1,o))`'dnl
`'`'c_doxygen(`/** create a ttcheckbutton with given text */')`'dnl
`'`'final(Create,$1,4, _G0(,ttcheckbutton,), _G(,ttshort,w), _G(,ttshort,h), _G(,ttshort,pitch), _G(_R _A((_P(2),*,_P(3))),ttbyte *,text))`'dnl
')

TTappend(ttradiobutton)
define(`TTdef_ttradiobutton',`extends(ttcheckbutton,$1)`'dnl
`'`'c_comment(`/** ttradiobutton: a two-state mutual-exclusion button */')`'dnl
    field(,ttbuttongroup,group,r)`'dnl
    field(,ttradiobutton,group_prev,r)`'dnl
    field(,ttradiobutton,group_next,r)`'dnl
')
define(`TTdef_ttclass_ttradiobutton',`extends(ttcheckbutton,$1)`'dnl
`'`'c_doxygen(`/** add the ttradiobutton `o' to the ttbuttongroup `g' */')`'dnl
`'`'final(AddToGroup,$1,2, _G0(,void,), _G(,$1,o), _G(,ttbuttongroup,g))`'dnl
`'`'c_doxygen(`/** remove the ttradiobutton `o' from its ttbuttongroup */')`'dnl
`'`'final(RemoveFromGroup,$1,1, _G0(,void,), _G(,$1,o))`'dnl
`'`'c_doxygen(`/** create a ttradiobutton with given text */')`'dnl
`'`'final(Create,$1,4, _G0(,ttradiobutton,), _G(,ttshort,w), _G(,ttshort,h), _G(,ttshort,pitch), _G(_R _A((_P(2),*,_P(3))),ttbyte *,text))`'dnl
')

TTappend(ttanyscroll)
define(`TTdef_ttanyscroll',`extends(ttanybutton,$1)`'dnl
`'`'c_comment(`/** ttanyscroll: the abstract class all scroll-like widgets are derived from */')`'dnl
    field(,ttbyte,orientation,rw)`'dnl
    field(,ttint,size,rw)`'dnl
    field(,ttint,real_size,rw)`'dnl
    field(,ttint,view_size,rw)`'dnl
    field(,ttint,real_view_size)`'dnl
    field(,ttint,position,rw)`'dnl
    field(,ttint,real_position,r)`'dnl
    field(,ttuint,state,r)`'dnl
')
define(`TTdef_ttclass_ttanyscroll',`extends(ttanybutton,$1)`'dnl
    protected(Recalculate,$1,5, _G0(,void,), _G(,$1,o), _G(,ttint,size), _G(,ttint,real_size), _G(,ttint,view_size), _G(,ttint,position))`'dnl
    protected(SetState,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttuint,state))`'dnl
`'`'c_doxygen(`/** set the orientation of the ttanyscroll `o' */')`'dnl
    public_set(SetOrientation,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttbyte,orientation))`'dnl
`'`'c_doxygen(`/** set the (virtual) size of the ttanyscroll `o' */')`'dnl
    public_set(SetSize,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,size))`'dnl
`'`'c_doxygen(`/** set the (real) size of the ttanyscroll `o' */')`'dnl
    public_set(SetRealSize,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,real_size))`'dnl
`'`'c_doxygen(`/** set the (virtual) view size of the ttanyscroll `o' */')`'dnl
    public_set(SetViewSize,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,view_size))`'dnl
`'`'c_doxygen(`/** set the (virtual) position of the ttanyscroll `o' */')`'dnl
    public_set(SetPosition,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,position))`'dnl
')

TTappend(ttscrollbar)
define(`TTdef_ttscrollbar',`extends(ttanyscroll,$1)`'dnl
`'`'c_comment(`/** ttscrollbar: a normal, interactive scroll bar */')`'dnl
    field(,ttscrollpane,scrollpane)`'dnl
')
define(`TTdef_ttclass_ttscrollbar',`extends(ttanyscroll,$1)`'dnl
`'`'c_doxygen(`/** create a ttscrollbar with given fields */')`'dnl
`'`'final(Create1,$1,1, _G0(,ttscrollbar,), _G(,ttbyte,orientation))`'dnl
`'`'c_doxygen(`/** create a ttscrollbar with given fields */')`'dnl
`'`'final(Create4,$1,4, _G0(,ttscrollbar,), _G(,ttbyte,orientation), _G(,ttint,size), _G(,ttint,real_size), _G(,ttint,view_size))`'dnl
')

TTappend(ttslider)
define(`TTdef_ttslider',`extends(ttanyscroll,$1)`'dnl
`'`'c_comment(`/** ttslider: a sliding knob within a bounded interval */')`'dnl
    field(,ttint,slide_min,rw)`'dnl
    field(,ttint,slide_max,rw)`'dnl
    field(,ttint,slide_value,rw)`'dnl
')
define(`TTdef_ttclass_ttslider',`extends(ttanyscroll,$1)`'dnl
`'`'c_doxygen(`/** set the slide minimum of the ttslider `o' */')`'dnl
    public_set(SetSlideMin,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,slide_min))`'dnl
`'`'c_doxygen(`/** set the slide maximum of the ttslider `o' */')`'dnl
    public_set(SetSlideMax,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,slide_max))`'dnl
`'`'c_doxygen(`/** set the slide position of the ttslider `o' */')`'dnl
    public_set(SetSlideValue,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttint,slide_value))`'dnl
`'`'c_doxygen(`/** create a ttslider with given fields */')`'dnl
`'`'final(Create,$1,2, _G0(,ttslider,), _G(,ttbyte,orientation), _G(,ttint,real_size))`'dnl
')

TTappend(ttprogressbar)
define(`TTdef_ttprogressbar',`extends(ttanyscroll,$1)`'dnl
`'`'c_comment(`/** ttprogressbar: a percentage completion bar */')`'dnl
    field(,ttint,real_position_frac_above)`'dnl
    field(,ttint,real_position_frac_below)`'dnl
')
define(`TTdef_ttclass_ttprogressbar',`extends(ttanyscroll,$1)`'dnl
`'`'c_doxygen(`/** create a ttprogressbar with given fields */')`'dnl
`'`'final(Create,$1,1, _G0(,ttprogressbar,), _G(,ttbyte,orientation))`'dnl
')

TTappend(ttscrollpane)
define(`TTdef_ttscrollpane',`extends(ttwidget,$1)`'dnl
`'`'c_comment(`/** ttscrollpane: a scrollable widget;
 * it keeps track of its wl and hl
 * from the ttwidgets you put inside it;
 * also used as the scrollpane of a ttscroller.
 */')`'dnl
    field(,ttscrollbar,bar_x,rw)`'dnl
    field(,ttscrollbar,bar_y,rw)`'dnl
')
define(`TTdef_ttclass_ttscrollpane',`extends(ttwidget,$1)`'dnl
`'`'c_doxygen(`/** create a ttscrollpane with given size */')`'dnl
`'`'final(Create,$1,2, _G0(,ttscrollpane,), _G(,ttshort,w), _G(,ttshort,h))`'dnl
`'`'c_doxygen(`/** set the x scrollbar the ttscrollpane `o' is connected to */')`'dnl
    public_set(SetBarX,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttscrollbar,bar_x))`'dnl
`'`'c_doxygen(`/** set the y scrollbar the ttscrollpane `o' is connected to */')`'dnl
    public_set(SetBarY,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(,ttscrollbar,bar_y))`'dnl
')

TTappend(ttwindow)
define(`TTdef_ttwindow',`extends(ttwidget,$1)`'dnl
`'`'c_comment(`/** ttwindow: a full-featured window */')`'dnl
    field(,ttopaque,title_len,r)`'dnl
    field(_A((_F(title_len))),ttbyte *,title,r)`'dnl
')
define(`TTdef_ttclass_ttwindow',`extends(ttwidget,$1)`'dnl
`'`'c_doxygen(`/** set the title of the ttwindow `o' */')`'dnl
    public_set(SetTitle,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_R _Z,ttbyte *,title))`'dnl
')

TTappend(ttframe)
define(`TTdef_ttframe',`extends(ttwindow,$1)`'dnl
`'`'c_comment(`/** ttframe: a toplevel window */')`'dnl
    field(,ttmenubar,menubar,rw)`'dnl
')
define(`TTdef_ttclass_ttframe',`extends(ttwindow,$1)`'dnl
`'`'c_doxygen(`/** set the menubar of the ttframe `o' */')`'dnl
    public_set(SetMenubar,$1,2, _G0(,ttbyte,), _G(,$1,o), _G(_R,ttmenubar,m))`'dnl
`'`'c_doxygen(`/** create a ttframe with given title */')`'dnl
`'`'final(Create,$1,1, _G0(,ttframe,), _G(_R _Z,ttbyte *,title))`'dnl
')

TTappend(ttscroller)
define(`TTdef_ttscroller',`extends(ttwindow,$1)`'dnl
`'`'c_comment(`/** ttscroller: a scrollable container;
 * you can put any ttwidget inside its scrollpane
 */')`'dnl
    field(,ttscrollpane,scrollpane,r)`'dnl
')
define(`TTdef_ttclass_ttscroller',`extends(ttwindow,$1)`'dnl
`'`'c_doxygen(`/** create a ttscroller with given size */')`'dnl
`'`'final(Create,$1,2, _G0(,ttscroller,), _G(,ttshort,w), _G(,ttshort,h))`'dnl
')

TTappend(ttmenuitem)
define(`TTdef_ttmenuitem',`extends(ttvisible,$1)`'dnl
`'`'c_comment(`/** ttmenuitem: a simple line in a menu */')`'dnl
    field(,ttopaque,name_len,r)`'dnl
    field(_A((_F(name_len))),ttbyte *,name,r)`'dnl
')
define(`TTdef_ttclass_ttmenuitem',`extends(ttvisible,$1)`'dnl
')

TTappend(ttcheckmenuitem)
define(`TTdef_ttcheckmenuitem',`extends(ttmenuitem,$1)`'dnl
`'`'c_comment(`/** ttcheckmenuitem: a checkable line in a menu */')`'dnl
')
define(`TTdef_ttclass_ttcheckmenuitem',`extends(ttmenuitem,$1)`'dnl
')

TTappend(ttradiomenuitem)
define(`TTdef_ttradiomenuitem',`extends(ttcheckmenuitem,$1)`'dnl
`'`'c_comment(`/** ttradiomenuitem: a radio (mutual-exclusion) line in a menu */')`'dnl
')
define(`TTdef_ttclass_ttradiomenuitem',`extends(ttcheckmenuitem,$1)`'dnl
')

TTappend(ttmenu)
define(`TTdef_ttmenu',`extends(ttmenuitem,$1)`'dnl
`'`'c_comment(`/** ttmenu: a line in a menu pointing to a sub menu */')`'dnl
    field(,ttmenubar,menubar,r)`'dnl
')
define(`TTdef_ttclass_ttmenu',`extends(ttmenuitem,$1)`'dnl
')

TTappend(ttmenubar)
define(`TTdef_ttmenubar',`extends(ttvisible,$1)`'dnl
`'`'c_comment(`/** ttmenubar: a complete menu bar */')`'dnl
')
define(`TTdef_ttclass_ttmenubar',`extends(ttvisible,$1)`'dnl
`'`'c_doxygen(`/** get the default ttmenubar used by ttwidget:s */')`'dnl
`'`'final(GetDefault,$1,0, _G0(,ttmenubar,))`'dnl
')

TTappend(ttanytext)
define(`TTdef_ttanytext',`extends(ttwindow,$1)`'dnl
`'`'c_comment(`/** ttanytext: the superclass of all text-only widgets */')`'dnl
    field(,ttopaque,text_len,r)`'dnl
    field(_A((_F(text_len))),ttattr *,text,r)`'dnl
')
define(`TTdef_ttclass_ttanytext',`extends(ttwindow,$1)`'dnl
')

TTappend(tttextfield)
define(`TTdef_tttextfield',`extends(ttanytext,$1)`'dnl
`'`'c_comment(`/** tttextfield: a single line user editable text-only widget */')`'dnl
')
define(`TTdef_ttclass_tttextfield',`extends(ttanytext,$1)`'dnl
')

TTappend(tttextarea)
define(`TTdef_tttextarea',`extends(tttextfield,$1)`'dnl
`'`'c_comment(`/** tttextarea: a multi line user editable text-only widget */')`'dnl
')
define(`TTdef_ttclass_tttextarea',`extends(tttextfield,$1)`'dnl
')

TTappend(tttheme)
define(`TTdef_tttheme',`extends(ttcomponent,$1)`'dnl
`'`'c_comment(`/** tttheme: the look-n-feel of the application */')`'dnl
    field(,ttopaque,name_len,r)`'dnl
    field(_A((_F(name_len))),ttbyte *,name,r)`'dnl
    field(,ttfont,fill)`'dnl
    field(_A((_F(tttheme_bg_max))),ttcol,bg[tttheme_bg_max])`'dnl
    field(_A((_F(tttheme_val_max))),ttint,val[tttheme_val_max])`'dnl
    field(_A((_F(tttheme_shape_max)*2)),struct s_ttshape,shape[tttheme_shape_max][2])`'dnl
')
define(`TTdef_ttclass_tttheme',`extends(ttcomponent,$1)`'dnl
`'`'c_doxygen(`/** get the default tttheme used by ttvisible:s */')`'dnl
`'`'final(GetDefault,$1,0, _G0(,tttheme,))`'dnl
')

TTappend(ttapplication)
define(`TTdef_ttapplication',`extends(ttcomponent,$1)`'dnl
`'`'c_comment(`/** ttapplication: the topmost object */')`'dnl
    field(,ttopaque,name_len,r)`'dnl
    field(_A((_F(name_len))),ttbyte *,name,r)`'dnl
')
define(`TTdef_ttclass_ttapplication',`extends(ttcomponent,$1)`'dnl
`'`'c_doxygen(`/** create (only one allowed) a ttapplication with given name */')`'dnl
`'`'final(Create,$1,1, _G0(,ttapplication,), _G(_R _Z,ttbyte *,name))`'dnl
`'`'c_doxygen(`/** get the current application */')`'dnl
`'`'final(Get,$1,0, _G0(,ttapplication,))`'dnl
')


dnl defines for objects and types hierarchy
define(`m4_super_ttobj', `ttobj')
define(`m4_super_ttclass_ttobj', `ttclass_ttobj')
define(`m4_super_ttclass', `ttclass')

define(`extends',`dnl
define(`m4_super_$2',`$1')`'dnl
define(`m4_super_ttclass_$2',`ttclass_$1')`'dnl
')
define(`field',`')
define(`el',`TTdef_$1($1)`'dnl
')
TTlist()

define(`field')
define(`extends')
define(`protected')
define(`public')
define(`public_set')
define(`final')
define(`final_alt', `final($@)')
define(`final_var')

undefine(`TTappend')
undefine(`el')

divert

