/* twpsk  - A gui application for PSK
 * Copyright (C) 1999-2005 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 2.1 - Aug 2002
 */

#ifndef TWPSKWIDS_INCLUDED
#define TWPSKWIDS_INCLUDED

#define MAX_BUTTONS 9
#define SPACING 10
#define ARROW_WIDTH 35
#define NUM_XMSTRINGS 8
#define SCROLLING 1

#include "GUI.h"
#include "twpskWF.h"
#include "twpskScope.h"
#include "../server/server.h"


/*
 * Wids class
 */

class Wids {

   private:
      int i, j;
      XmString xs[20];
      int qpsk, lsb;
      char str[8];
      Arg args[20];  
      Pixmap saPixmap, wfPixmap;
      Pixel fg, bg;
      int fftSpeed;
      int fftSample;
      int rxFreqFocus;
      int rxScrollFlag;
      int brightness;

      Widget mainform;
      Widget   label1, menuBar, fileMenu, fileCas;
      Widget   controlsMenu, controlsCas;
      Widget     audioBtn, videoBtn;
      Widget     rxBtn, txBtn, tuneBtn, sep;
      Widget     broadBtn, mediumBtn, narrowBtn; 
      Widget     saBtn, wfBtn, openBtn;
      Widget   seekMenu, seekCas;
      Widget     upBtn, downBtn, haltBtn;
      Widget   helpMenu, helpCas;
      Widget     aboutBtn, helpBtn;
      
      Widget   paneWin;
      Widget     rxTextSW;
      Widget       rxText;
      Widget       clrRxPopup;
      Widget     txTextSW;
      Widget       txText;
      Widget       clrTxPopup;
      
      Widget   displayForm; 
      Widget   displayRC;
      Widget     scopeDA, wfDA, dispLabel;
      Widget     bwRB;
      Widget       broadTB, mediumTB, narrowTB;
      Widget     displayRB;
      Widget       saTB, wfTB;
      
      Widget   controlsForm;
      Widget     rxLabel;
      Widget     rxComboForm;
      Widget       rxFreqTF, rxUpArrow,rxDnArrow, afcTB;
      Widget     txLabel;
      Widget     txComboForm;
      Widget       txFreqTF, txUpArrow,txDnArrow, netTB;
      Widget     trLabel;
      Widget     controlsRC;
      Widget       trRB;
      Widget         rxTB, txTB, tuneTB;
      Widget     modesRC;
      Widget       modeLabel, dcdTB, qpskTB, lsbTB, cwidTB;
      Widget       imdFrame, imdForm, imdTF, imdLabel;
      
      Widget   audioDiag;
      Widget     mixerFrame, mixerForm ;
      Widget        mixerLabel;
      Widget        mainLabel, mainScale, outLabel, pcmScale;
      Widget        configLabel;
      Widget        inputLabel, inScale, audioCloseBtn;
      Widget     scFrame, scForm, scRC;
      Widget        chansOM, bitsOM;

      Widget   displayDiag;
      Widget     brightLabel,  brightScale, fftLabel, fftScale, displayCloseBtn;
      
      Widget rxScrollBar;
      Widget rxtTB[3];

      void createButtons (Widget shell, char *buttonNames);


   public:
      void buildWidgets (Widget shell, AppRes *appRes);

      Widget get_mainform()
      {
         return mainform;
      }

      Widget get_label1()
      {
         return label1;
      }

      Boolean getLSB(void)
      {
         return (XmToggleButtonGetState (lsbTB));
      }
    
      void setLSB(int value)
      {
         XtVaSetValues(lsbTB, XmNset, value, NULL);
      }

      Boolean getQPSK()
      {
	 return (XmToggleButtonGetState (qpskTB));
      }

      void setQPSK(Boolean value)
      {
	 XmToggleButtonSetState (qpskTB, value, 1);
      }

      Boolean getAFC()
      {
	 return (XmToggleButtonGetState (afcTB));
      }

      void setAFC(Boolean value)
      {
	 XmToggleButtonSetState (afcTB, value, 1);
      }

      float getFreq()
      {
	 String str;
	 XtVaGetValues (rxFreqTF, XmNvalue, &str, NULL);  /* Get the freq */
	 float f = atof(str);                        /* convert to a float */
	 return f;
      }

      void setFreq(float freq)
      {
	 sprintf(str, "%4.1f", freq);
         XmTextFieldSetString (rxFreqTF, str);
	 commControl(COMM_RXCH, COMM_FREQ, (int)(freq*100));
      }

      Widget getShell(void)
      {
         return XtParent (mainform);
      }

      Widget getScope(void)
      {
         return (scopeDA);
      }

      Widget getWF(void)
      {
         return (wfDA);
      }

      Widget getRxText(void)
      {
         return (rxText);
      }

      Widget getTxText(void)
      {
         return (txText);
      }

      Widget getDcdTB(void)
      {
         return (dcdTB);
      }

      Boolean getDCD()
      {
	 return (XmToggleButtonGetState (dcdTB));
      }

      Widget getRxFreqTF(void)
      {
         return (rxFreqTF);
      }

      Widget getTxFreqTF(void)
      {
         return (txFreqTF);
      }

      Widget getCwidTB(void)
      {
         return (cwidTB);
      }

      Widget getImdTF(void)
      {
         return (imdTF);
      }

      int getRxFreqFocus(void)
      {
         return (rxFreqFocus);
      }

      void setRxFreqFocus(int f)
      {
         rxFreqFocus = f;
      }

      void setRxScrollFlag(int x)
      {
         rxScrollFlag = x;
      }

      int getRxScrollFlag(void)
      {
         return (rxScrollFlag);
      }

      int getFFTspeed(void)
      {
         return (fftSpeed);
      }

      int getFFTsample(void)
      {
         return (fftSample);
      }
   
      Widget *get_rxtTB (void)
      {
         return (rxtTB);
      }
};
#endif
