<?php

/**
 * Configuring a dynamic table, user_photomarathon
 * 
 * The point of this is, that the table definition does not need to be loaded with every single instance in the backend. 
 * The whole definition is loaded only if it is used.
 */
$TCA['user_photomarathon'] = Array (
	'ctrl' => $TCA['user_photomarathon']['ctrl'],	// Setting the current [ctrl] value so they are not entered redundantly
	'feInterface' => $TCA['user_photomarathon']['feInterface'],
		// The list of fields displayed when you do a 'Info' on the record in the backend.
	'interface' => Array (
		'showRecordFieldList' => 'title,description,images,hidden'
	),
	'columns' => Array (	
			// Title is set up as an ordinary input-field, one line.
		'title' => Array (
			'label' => 'LLL:EXT:user_photomarathon/locallang_tables.php:title',
			'config' => Array (
				'type' => 'input',
				'size' => '40',
				'max' => '80',
				'eval' => 'trim'		// Trimming this fields means that the content is stripped for whitespace in the ends before stored in the database.
			)
		),
			// Image description is set up as a textarea form element in the backend
		'description' => Array (
			'label' => 'LLL:EXT:user_photomarathon/locallang_tables.php:description',
			'config' => Array (
				'type' => 'text',
				'cols' => '48',	
				'rows' => '5'
			)
		),
			// Images are stored in a tinyblob where the filenames from uploads/photomarathon are stored comma-separated
		'images' => Array (
			'label' => 'LLL:EXT:user_photomarathon/locallang_tables.php:image',
			'config' => Array (
				'type' => 'group',
				'internal_type' => 'file',
				'allowed' => 'gif,jpg,jpeg,png',		// Allowed extensions
				'max_size' => '1000',			// Max 1000 kb pr. image
				'uploadfolder' => 'uploads/photomarathon',		// This is the folder relative to the PATH_site where the images are stored! Must be write enabled for PHP.
				'show_thumbs' => '1',		// Yes, show thumbnails in backend
				'size' => '3',				// The image list box is 3 items high
				'maxitems' => '6',			// Max 6 images pr. record!
				'minitems' => '0'			// Min 0 images.
			)
		),
			// Hidden field: This field is configured in the 'ctrl' section of the array to be used as hidden-field. So if this fields is > 1 then the record is hidden. Else it's shown. The field is configured as a check-box.
		'hidden' => Array (
			'label' => 'LLL:EXT:user_photomarathon/locallang_tables.php:hidden',
			'config' => Array (
				'type' => 'check'
			)
		),
			// Photo date
		'photodate' => Array (
			'label' => 'LLL:EXT:user_photomarathon/locallang_tables.php:photodate',
			'config' => Array (
				'type' => 'input',
				'size' => '7',
				'max' => '20',
				'eval' => 'date',
				'checkbox' => '0',
				'default' => '0'
			)
		),
			// This field is loaded with the uid of the fe_user who created the photomarathon image. The value of this field determines ownership of the record regarding the front end users. The backend users has access to this record according to it's position in the page-tree as usual.
		'fe_cruser_id' => Array (
			'label' => 'LLL:EXT:user_photomarathon/locallang_tables.php:fe_cruser_id',
			'config' => Array (
				'type' => 'group',
				'internal_type' => 'db',
				'allowed' => 'fe_users',
				'size' => '1',
				'maxitems' => '1',
				'minitems' => '0',
				'show_thumbs' => '1'
			)
		)
	),

		// This defines the order of the above defined fields in the backend interface in the doc-module. Notice that the title-field is set up to activate palette number 1 when the cursor is placed in the field!
	'types' => Array (
		'0' => Array('showitem' => 'title;;1,photodate,description,images,fe_cruser_id')
	),

		// This defines the fields on palette 1. This palette is activated when the user places his cursor in the title field. See the 'types' configuration above!
	'palettes' => Array (
		'1' => Array('showitem' => 'hidden')	
	)
);
?>