#include "cs.h"
/* process edge (j,i) of the matrix */
static void cs_cedge (CS_INT j, CS_INT i, const CS_INT *first, CS_INT *maxfirst, CS_INT *delta,
    CS_INT *prevleaf, CS_INT *ancestor)
{
    CS_INT q, s, sparent, jprev ;
    if (i <= j || first [j] <= maxfirst [i]) return ;
    maxfirst [i] = first [j] ;	/* update max first[j] seen so far */
    jprev = prevleaf [i] ;	/* j is a leaf of the ith subtree */
    delta [j]++ ;		/* A(i,j) is in the skeleton matrix */
    if (jprev != -1)
    {
	/* q = least common ancestor of jprev and j */
	for (q = jprev ; q != ancestor [q] ; q = ancestor [q]) ;
	for (s = jprev ; s != q ; s = sparent)
	{
	    sparent = ancestor [s] ;	/* path compression */
	    ancestor [s] = q ;
	}
	delta [q]-- ;		/* decrement to account for overlap in q */
    }
    prevleaf [i] = j ;		/* j is now previous leaf of ith subtree */
}

/* colcount = column counts of LL'=A or LL'=A'A, given parent & post ordering */
CS_INT *cs_counts (const cs *A, const CS_INT *parent, const CS_INT *post, CS_INT ata)
{
    CS_INT i, j, k, p, n, m, ii, s, *ATp, *ATi, *maxfirst, *prevleaf, *ancestor,
	*head = NULL, *next = NULL, *colcount, *w, *first, *delta ;
    cs *AT ;
    if (!A || !parent || !post) return (NULL) ;	    /* check inputs */
    m = A->m ; n = A->n ;
    s = 4*n + (ata ? (n+m+1) : 0) ;
    w = cs_malloc (s, sizeof (CS_INT)) ; first = w+3*n ;	/* get workspace */
    ancestor = w ; maxfirst = w+n ; prevleaf = w+2*n ;
    delta = colcount = cs_malloc (n, sizeof (CS_INT)) ;	/* allocate result */
    AT = cs_transpose (A, 0) ;
    if (!AT || !colcount || !w) return (cs_idone (colcount, AT, w, 1)) ;
    for (k = 0 ; k < s ; k++) w [k] = -1 ;	/* clear workspace w [0..s-1] */
    for (k = 0 ; k < n ; k++)			/* find first [j] */
    {
	j = post [k] ;
	delta [j] = (first [j] == -1) ? 1 : 0 ;  /* delta[j]=1 if j is a leaf */
	for ( ; j != -1 && first [j] == -1 ; j = parent [j]) first [j] = k ;
    }
    ATp = AT->p ; ATi = AT->i ;
    if (ata)
    {
	head = w+4*n ; next = w+5*n+1 ;
	for (k = 0 ; k < n ; k++) w [post [k]] = k ;    /* invert post */
	for (i = 0 ; i < m ; i++)
	{
	    k = n ;		    /* k = least postordered column in row i */
	    for (p = ATp [i] ; p < ATp [i+1] ; p++) k = CS_MIN (k, w [ATi [p]]);
	    next [i] = head [k] ;   /* place row i in link list k */
	    head [k] = i ;
	}
    }
    for (i = 0 ; i < n ; i++) ancestor [i] = i ; /* each node in its own set */
    for (k = 0 ; k < n ; k++)
    {
	j = post [k] ;		/* j is the kth node in postordered etree */
	if (parent [j] != -1) delta [parent [j]]-- ;	/* j is not a root */
	if (ata)
	{
	    for (ii = head [k] ; ii != -1 ; ii = next [ii])
	    {
		for (p = ATp [ii] ; p < ATp [ii+1] ; p++)
		    cs_cedge (j, ATi [p], first, maxfirst, delta, prevleaf,
			    ancestor) ;
	    }
	}
	else
	{
	    for (p = ATp [j] ; p < ATp [j+1] ; p++)
		cs_cedge (j, ATi [p], first, maxfirst, delta, prevleaf,
			    ancestor) ;
	}
	if (parent [j] != -1) ancestor [j] = parent [j] ;
    }
    for (j = 0 ; j < n ; j++)		/* sum up delta's of each child */
    {
	if (parent [j] != -1) colcount [parent [j]] += colcount [j] ;
    }
    return (cs_idone (colcount, AT, w, 1)) ;	/* success: free workspace */
}
