/*
 *  update-cluster-parseconfig.c / parse configuration file for update-cluster.
 *  Copyright 2001, 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/* $Id: update-cluster-parseconfig.c,v 1.12 2002/10/07 11:26:47 dancer Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dancer-xml.h>
#include "config.h"
#include "update-cluster-i18n.h"


#define BUFFSIZE 8192
const int depth_cluster = 1;
const int depth_host = 2;
const int depth_elements = 3;

typedef struct assoclist
{
  char * topic;
  char * content;  
  struct assoclist * next;
}assoclist;  

static char ** global_av;
static int global_ac;

/**
 * @return 0 on success
 */
int
check_one_dxml(dxml_element* real_e)
{
  int i;
  dxml_element*e;
  
  if (!real_e)
    {
      fprintf(stderr, _("Unexplicable error: NULL e was given\n"));
      exit (1);
    }
  
  for (i=1; i < global_ac; ++i)
    {
      int found = 0;
      
      for (e = real_e; e; e = e-> next)
	{
	  if (!strcmp(e->element_name, global_av[i]))
	    {
	      if (!e->child)
		{
		  fprintf(stderr, _("Unexplicable error: NULL e->child was given\n"));
		  exit (1);
		}

	      if (e->child->element_type != element_type_pcdata)
		{
		  fprintf(stderr, _("Syntax error: PCDATA expected, and not given here. \n"));
		  exit (1);
		}
	      if (e->element_type != element_type_element)
		{
		  fprintf(stderr, _("Syntax error: element expected, and not given here. \n"));
		  exit (1);
		}

	      if ( i > 1 )
		printf (" "); /* space only when more than 1 */
		
	      printf("%s", e->child->element_name);
	      found = 1;		  
	      break;
	    }
	}
      if (! found)
	{
	  fprintf (stderr, "Failed to find a field entry for [%s]\n", 
		   global_av[i]);
	  exit (1);
	}
    }
  return 0;
}

int
check_all_dxml(dxml_element*e)
{
  if (!e)
    {
      fprintf(stderr, _("Unexplicable error: NULL e was given\n"));
      exit (1);
    }
  
  for (; e; e=e->next )
    {
      if (check_one_dxml(e->child))
	return 1;
      printf("\n");
    }
  
  return 0;
}



int
main(int argc, char **argv) 
{
  dxml_element * e;

  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE_NAME, LOCALEDIR);
  textdomain(PACKAGE_NAME);
  
  if ((argc <= 1) || (!(strcmp (argv[1], "--help"))) || 
      (!(strcmp(argv[1], "-h"))))
    {
      fprintf(stderr, _("update-cluster-parseconfig by Junichi Uekawa 2001\n\n"
	      "update-cluster-parseconfig [element] ...\n"
	      "  parses an XML content, and outputs space-delimited text\n\n"
	      "please read the manpage for details.\n"));
      exit (1);      
    }
  
  e = dxml_read_xml (stdin);

  if (!e) 
    {
      fprintf(stderr, _("Failed initialization of the parser\n"));
      exit(EXIT_FAILURE);
    }

  global_ac = argc;
  global_av = argv;

  check_all_dxml(e -> child);
  
  exit (EXIT_SUCCESS);
}  

