/*
 * Copyright (c) 1995 The Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 * 	This product includes software developed by the Network Research
 * 	Group at Lawrence Berkeley National Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
static const char rcsid[] =
    "@(#) $Header: encoder.cc,v 1.4 96/03/16 13:12:51 van Exp $ (LBL)";

#include "config.h"
#include "rtp.h"
#include "encoder.h"
#include "transmitter.h"

static class PCM_EncoderMatcher : public Matcher {
public:
	PCM_EncoderMatcher() : Matcher("encoder") {}
	TclObject* match(const char* fmt) {
		if (strcasecmp(fmt, "pcm") == 0)
			return (new PCM_Encoder);
		else
			return (0);
	}
} pcm_encoder_matcher;

PCM_Encoder::PCM_Encoder() : tx_(0), last_ts_(0)
{
}

int PCM_Encoder::command(int argc, const char*const* argv)
{
	if (argc == 3) {
		if (strcmp(argv[1], "transmitter") == 0) {
			tx_ = (Transmitter*)TclObject::lookup(argv[2]);
			return (TCL_OK);
		}
	}
	return (TclObject::command(argc, argv));
}

void PCM_Encoder::encode(u_int32_t ts, u_int8_t* samples, int len)
{
	register int marker = (ts != last_ts_) ? htons(RTP_M) : 0;
	last_ts_ = ts + len;

	Transmitter::pktbuf* pb = tx_->alloch(ts, RTP_PT_PCMU);
	rtphdr* rh = (rtphdr*)pb->hdr;
	rh->rh_flags |= marker;
	pb->iov[0].iov_len = sizeof(rtphdr);
	pb->iov[1].iov_base = (caddr_t)samples;
	pb->iov[1].iov_len = len;
	tx_->send(pb);
}

