/*
 * virtualconsole.h: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */


#ifndef __VIRTUALCONSOLE_H__
#define __VIRTUALCONSOLE_H__


#include <sys/ioctl.h>
#include <termios.h>

#include <vdr/tools.h>
#include <vdr/remote.h>

#include "ipc.h"
#include "terminalemulation.h"


#define INPUT_BUFSIZE 1024





class cConsTerminalEmulation;
class cConsConsoles;



class cConsVirtualConsole
: public cListObject,
  public IConsWaitable
{

  friend class cConsConsoles;

private:

  unsigned char _buf[INPUT_BUFSIZE + 1];

  volatile int _childPid;
  int _master;
  bool _isOpen;

  char* _title;

  cConsTerminalEmulation _screen;

private:
  bool Open(const char* command, char* const argv[]);
  bool ConsoleWaitPid(volatile int& pid, int timeoutMs);
  bool HandleOutput();


public:
  cConsVirtualConsole(const char* title, const char* command, char* const argv[]);
  virtual ~cConsVirtualConsole();

  bool IsOpen();

  bool Close();
  void HasClosed(bool force = false);

  void setTerminalSize(int charW, int charH, int pixelW, int pixelH);

  void Write(const unsigned char* data, int len);

  const char* getTitle() { return _title; }
  cConsTerminalEmulation& getScreen() { return _screen; }
  pid_t getChildPid() { return _childPid; }

// IConsWaitable
  virtual int SignalToWaitFor() const { return _master; }
};



#endif // __VIRTUALCONSOLE_H__


