#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "guiutils.h"
#include "cdialog.h"

#include "editor.h"
#include "editortdialog.h"
#include "editortdialogcb.h"

#ifdef MEMWATCH
# include "memwatch.h"
#endif


void EditorTDialogPullOutCB(void *widget, void *data);
void EditorTDialogPushInCB(void *widget, void *data);

void EditorTDialogFindActivateCB(GtkWidget *widget, gpointer data);
void EditorTDialogRevertCB(GtkWidget *widget, gpointer data);

void EditorTDialogTextChangeCB(GtkEditable *editable, gpointer data);
void EditorTDialogTextInsertCB(
	GtkEditable *editable, const gchar *text, gint length,
	gint *position, gpointer data
);
void EditorTDialogTextDeleteCB(
	GtkEditable *editable, gint start_pos, gint end_pos, gpointer data
);



/*
 *	Pull out callback.
 */
void EditorTDialogPullOutCB(void *widget, void *data)
{
	GtkWidget *w;
	ma_editor_struct *editor;
	ma_editor_tdialog_struct *d = (ma_editor_tdialog_struct *)data;
	if(d == NULL)
	    return;

	d->pulled_out = TRUE;

	/* Get pointer to editor. */
	editor = (ma_editor_struct *)d->editor_ptr;
	if(editor != NULL)
	{
	    /* Record last size of editor's text_dialog_toplevel. */
	    w = editor->text_dialog_toplevel;
	    if(w != NULL)
	    {
		/* Record those values onto text dialog's structure. */
		d->last_width = w->allocation.width;
		d->last_height = w->allocation.height;
	    }

	    /* Increase size of editor's lists_and_views_toplevel. */
	    w = editor->lists_and_views_toplevel;
	    if(w != NULL)
	    {
		int new_height = w->allocation.height + d->last_height;
		gtk_widget_set_usize(w, -1, new_height);
	    }
	}

	/* Update title of pulled out window. */
	w = (GtkWidget *)GUIPullOutGetToplevelWindow(
	    d->toplevel, NULL, NULL, NULL, NULL
	);
	if(w != NULL)
	    gtk_window_set_title(GTK_WINDOW(w), PROG_NAME ": Text Dialog");

	return;
}

/*
 *	Push in callback.
 */
void EditorTDialogPushInCB(void *widget, void *data)
{
	GtkWidget *w;
	ma_editor_struct *editor;
	ma_editor_tdialog_struct *d = (ma_editor_tdialog_struct *)data;
	if(d == NULL)
	    return;

	d->pulled_out = FALSE;

	/* Get pointer to editor. */
	editor = (ma_editor_struct *)d->editor_ptr;
	if(editor != NULL)
	{
	    /* Reduce size of editor's lists_and_views_toplevel. */
	    w = editor->lists_and_views_toplevel;
	    if(w != NULL)
	    {
		int new_height = w->allocation.height - d->last_height;
		gtk_widget_set_usize(w, -1, new_height);
	    }
	}

	return;
}


/*
 *	Text dialog find combo activate callback.
 */
void EditorTDialogFindActivateCB(GtkWidget *widget, gpointer data)
{
	static gbool reenterant = FALSE;
	gbool	search_wrapped = FALSE,
		case_sensitive = FALSE;
	int start_pos;
	GtkCombo *combo;
	GtkText *text;
	gchar *haystack, *needle;
	ma_editor_tdialog_struct *d = (ma_editor_tdialog_struct *)data;
	if(d == NULL)
	    return;

	combo = (GtkCombo *)d->find_combo;
	if(combo == NULL)
	    return;
	text = (GtkText *)d->text;
	if(text == NULL)
	    return;

	/* Get needle, the search string. */
	needle = gtk_entry_get_text(
	    GTK_ENTRY(combo->entry)
	);
	if(needle == NULL)
	    return;

	if(reenterant)
	    return;
	else
	    reenterant = TRUE;

	/* Make a copy of the search string. */
	needle = strdup(needle);
	if(needle == NULL)
	{
	    reenterant = FALSE;
	    return;
	}

	/* Get haystack, the buffer to search through. */
	haystack = gtk_editable_get_chars(
	    GTK_EDITABLE(text), 0, -1
	);

	/* Get starting position as position of cursor in text. */
	start_pos = gtk_editable_get_position(GTK_EDITABLE(text)) + 1;

	/* Perform find procedure. */
	if(EditorTDialogDoFind(
	    d, text, haystack, needle,
	    strlen(haystack),	/* Haystack length. */
	    start_pos,		/* Start position. */
	    case_sensitive,	/* Case sensitive. */
	    TRUE,		/* Move to selection. */
	    &search_wrapped
	))
	{
	    /* Found string! */

	    /* Search wrapped? */
	    if(search_wrapped)
	    {


	    }
	}


	/* Deallocate buffers. */
	g_free(haystack);
	haystack = NULL;
	free(needle);
	needle = NULL;

	reenterant = FALSE;
	return;
}


/*
 *	Revert callback.
 */
void EditorTDialogRevertCB(GtkWidget *widget, gpointer data)
{
	ma_editor_tdialog_struct *d = (ma_editor_tdialog_struct *)data;
	if(d == NULL)
	    return;

	/* Ignore text delete if text dialog is operating on text. */
	if(d->text_operating)
	    return;

	EditorTDialogClear(d);
	EditorTDialogFetch(d->editor_ptr, d);

	d->has_changes = FALSE;

	EditorTDialogUpdateMenus(d);

	return;
}


/*
 *	Text change callback.
 */
void EditorTDialogTextChangeCB(GtkEditable *editable, gpointer data)
{
	ma_editor_tdialog_struct *d = (ma_editor_tdialog_struct *)data;
	if(d == NULL)
	    return;

	/* Ignore text delete if text dialog is operating on text. */
	if(d->text_operating)
	    return;



	return;
}

/*
 *	Text insert callback.
 */
void EditorTDialogTextInsertCB(
	GtkEditable *editable, const gchar *text, gint length,
	gint *position, gpointer data
)
{
	gbool need_update_menus = FALSE;
	ma_editor_struct *editor;
	ma_editor_tdialog_struct *d = (ma_editor_tdialog_struct *)data;
	if(d == NULL)
	    return;

	/* Ignore text delete if text dialog is operating on text. */
	if(d->text_operating)
	    return;

	editor = (ma_editor_struct *)d->editor_ptr;
	if(editor == NULL)
	    return;

	/* Editor did not have changes? */
	if(!editor->has_changes)
	{
	    editor->has_changes = TRUE;
	    need_update_menus = TRUE;
	}

	/* Text dialog did not have changes? */
	if(!d->has_changes)
	{
	    d->has_changes = TRUE;
	    EditorTDialogUpdateMenus(d);
	}

	if(need_update_menus)
	    EditorUpdateMenus(editor);

	return;
}

/*
 *	Text delete callback.
 */
void EditorTDialogTextDeleteCB(
	GtkEditable *editable, gint start_pos, gint end_pos, gpointer data
)
{
	gbool need_update_menus = FALSE;
	ma_editor_struct *editor;
	ma_editor_tdialog_struct *d = (ma_editor_tdialog_struct *)data;
	if(d == NULL)
	    return;

	/* Ignore text delete if text dialog is operating on text. */
	if(d->text_operating)
	    return;

	editor = (ma_editor_struct *)d->editor_ptr;
	if(editor == NULL)
	    return;

	/* Editor did not have changes? */
	if(!editor->has_changes)
	{
	    editor->has_changes = TRUE;
	    need_update_menus = TRUE;
	}

	/* Text dialog did not have changes? */
	if(!d->has_changes)
	{
	    d->has_changes = TRUE;
	    EditorTDialogUpdateMenus(d);
	}

	if(need_update_menus)
	    EditorUpdateMenus(editor);

	return;
}
