/*
			     Font Selection Dialog
 */

#ifndef FSD_H
#define FSD_H

#include <gtk/gtk.h>

extern gint FSDInit(void);
extern void FSDSetStyle(GtkRcStyle *rc_style);
extern void FSDSetTransientFor(GtkWidget *w);
extern gboolean FSDIsQuery(void);
extern void FSDBreakQuery(void);
extern gboolean FSDGetResponse(
	const gchar *title,
	const gchar *ok_label, const gchar *cancel_label,
	gchar *start_font_name,
	gchar **font_name_rtn
);
extern void FSDMap(void);
extern void FSDUnmap(void);
extern void FSDShutdown(void);

extern GtkWidget *FSDPromptNew(
	const gchar *label, gint label_width,
	gint entry_width,
	gpointer client_data,
	void (*func_cb)(GtkWidget *, gpointer)
);
extern GtkWidget *FSDPromptNewSimple(
	const gchar *label, gint label_width,
	gint entry_width
);
extern GtkWidget *FSDPromptGetEntry(GtkWidget *w);
extern GtkWidget *FSDPromptGetButton(GtkWidget *w);
extern gchar *FSDPromptGetFontName(GtkWidget *w);
extern void FSDPromptSetFontName(GtkWidget *w, const gchar *font_name);


#endif	/* FSD_H */
