// Copyright 2005 Ben Hutchings <ben@decadent.org.uk>.
// See the file "COPYING" for licence details.

#ifndef INC_STYLESHEETS_HPP
#define INC_STYLESHEETS_HPP

#include <nsCOMPtr.h>
#include <nsIStyleSheet.h>

class nsIPresShell;

// These functions load and apply a style-sheet as necessary,
// overriding the built-in "preferences".

// init_agent_style_sheet() must be called once during startup
// apply_agent_style_sheet() must be called for each page

#if MOZ_VERSION_MAJOR > 1 || (MOZ_VERSION_MAJOR == 1 && MOZ_VERSION_MINOR >= 8)

struct agent_style_sheet_holder {};

// Load agent style sheet from an (absolute) URI, and register it if
// possible.
agent_style_sheet_holder init_agent_style_sheet(const char * uri);
inline void apply_agent_style_sheet(agent_style_sheet_holder, nsIPresShell *)
{}

#else

typedef nsCOMPtr<nsIStyleSheet> agent_style_sheet_holder;
already_AddRefed<nsIStyleSheet> init_agent_style_sheet(const char * uri);
void apply_agent_style_sheet(nsIStyleSheet *, nsIPresShell *);

#endif


#endif // !INC_STYLESHEETS_HPP
