/*
 *	VME Linux/m68k Loader
 *
 *	(c) Copyright 1997 by Nick Holgate
 *
 *	This file is subject to the terms and conditions of the GNU General Public
 *	License.  See the file COPYING for more details.
 */

/*--------------------------------------------------------------------------*/
/*  MVME Initial Program Loader
 */

/*--------------------------------------------------------------------------*/
/* Disk read command packet structure
 */

.equ	cbd_clun,	0				| Controller LUN
.equ	cbd_dlun,	1				| Device LUN
.equ	cbd_status, 2				| Status word
.equ	cbd_addr,	4				| Address
.equ	cbd_block,	8				| Block
.equ	cbd_count,	12				| Block count
.equ	cbd_flags,	14				| Flags
.equ	cbd_am,		15 				| Address modifier

.equ	sizeof_cbd,	16				| size of disk command block in bytes

/*--------------------------------------------------------------------------*/

.equ	bootaddr,	0x20000			| address where boot sector is loaded
.equ	bootcode,	0x22			| offset to start of boot code (start)
.equ	fraglist,	0x96			| offset to fragment list

.equ	loader,		0x10000			| address to store linux loader

/*--------------------------------------------------------------------------*/

.text
start:
	movem.l	%d0-%d7/%a0-%a6,-(%a7)		| save registers

	lea.l	start-sizeof_cbd(%pc),%a5	| get address of command packet buffer

	move.l	%a5,%a4						| get working pointer to cmd pkt address
	move.b	%d1,(%a4)+					| set controller lun (passed in from MVMEBug)
	move.b	%d0,(%a4)+					| set device lun

#if 0
	movea.l	#bootaddr+fraglist,%a6				| get address of fragment list
#else
	lea.l	start-bootcode+fraglist(%pc),%a6	| get address of fragment list
#endif
	movea.l	#loader,%a0				| destination address

main.loop:
	move.w	(%a6)+,%d1				| get number of 256 byte blocks
	beq.s	done					| branch if end of list

	move.l	(%a6)+,%d2				| get disk block number
	bne.s	disk.read				| if not a hole, go read disk

	lsl.w	#6,%d1					| convert 256 byte blocks to long words
	bra.s	clear.loop.test			| enter clear memory loop

clear.loop:
	move.l	%d2,(%a0)+				| clear long word
clear.loop.test:
	dbra	%d1,clear.loop			| until all cleared
	bra.s	main.loop				| back for next fragment

disk.read:
	lea.l	cbd_status(%a5),%a4
	clr.w	(%a4)+					| clear status
	move.l	%a0,(%a4)+				| set load address
	move.l	%d2,(%a4)+				| set block number
	move.w	%d1,(%a4)+				| set number of 256 byte blocks
	clr.w	(%a4)					| clear flags and address modifier
	pea		(%a5)					| pass command packet pointer
	trap	#15
	dc.w	0x0010					| disk read
	tst.w	cbd_status(%a5)			| disk error?
	bne.s	error					| yes, report it
	lsl.w	#6,%d1					| convert 256 byte blocks to long words
	lea.l	(%a0,%d1.w*4),%a0		| update memory pointer

	bra.s	main.loop				| back for next fragment

done:
	move.l	%a7,-(%a7)				| pass pointer to stacked registers
	jsr		loader					| call loader

error:
#if 0 /* NOT ENOUGH SPACE FOR CODE TO PRINT MESSAGE */
	pea		errmsg(%pc)				| pass pointer to error message
	trap	#15
	dc.w	0x0024					| print string + CRLF
#endif
	trap	#15
	dc.w	0x0063					| enter MVMEBug

	movem.l	(%a7)+,%d0-%d7/%a0-%a6	| restore initial registers
	bra.s	start					| try again if 'go' from MVMEBug

#if 0
errmsg:
	dc.b	endmsg-.
	dc.b	13,10
	dc.b	13,10
.ascii		"Disk read error"
	dc.b	13,10
endmsg:
#endif

/*-----------------------------< end of file >------------------------------*/
