// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tif.C
// 
// Purpose:     
// 
// Created:     4 Jan 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tif.C,v 1.3 1997/02/24 10:18:47 jfasch Exp $
// 
// $Log: tif.C,v $
// Revision 1.3  1997/02/24 10:18:47  jfasch
// timeout added to TIOINETRequest
//
// Revision 1.2  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// Revision 1.1  1997/02/04 13:48:16  jfasch
// Initial revision
//
// 
// </file> 
#include "tif.h"

#include <hyperg/utils/assert.h>

// --------------------------------------------------------------------
int TIOINETRequest :: last_id_ = 0 ;
const char* TIOINETRequest :: version2 = "TIOINETRequest: $Id: tif.C,v 1.3 1997/02/24 10:18:47 jfasch Exp $" ;

TIOINETRequest :: TIOINETRequest (const INETAddress& a, TIOINETFactoryUser* u)
: id_(last_id_++),
  addr_(a),
  timeout_(0),
  user_(u),
  worker_(nil) {}

TIOINETRequest :: TIOINETRequest (const INETAddress& a, long timeout, TIOINETFactoryUser* u)
: id_(last_id_++),
  addr_(a),
  timeout_(timeout),
  user_(u),
  worker_(nil) {}

void TIOINETRequest :: cancel (const TIOINETFactoryUser* u) {
   // I cannot be cancelled if I have no user (issuer). in other
   // words, if I have no user, I am supposed to be handled in a
   // blocking fashion. so, I dont know what has happened when a
   // blocking request gets cancelled. most probably, a silly error.
   hgassert (user_, "TIOINETRequest::cancel(): "
             "cannot cancel a blocking request (actually, makes no sense at all)") ;
   // nil cancllor is not valid.
   hgassert (u, "TIOINETRequest::cancel(): nil cancellor") ;
   // also, I can be cancelled by my user himself ONLY.
   hgassert (user_==u, "TIOINETRequest::cancel(): cancellor is not my issuer") ;
   // also also, I must already be worked by someone. else cancelling
   // makes no sense.
   hgassert (worker_, "TIOINETRequest::cancel(): "
             "no worker yet set (am I not being issued yet?)") ;

   // having passed the paranoia section, finally do the work.
   worker_->cancel_(this) ; // I am his best friend
}

void TIOINETRequest :: set_worker_(TIOINETFactory* f) {
   worker_ = f ;
}

// --------------------------------------------------------------------
const char* TIOINETResponse :: version1 = "TIOINETResponse: $Id: tif.C,v 1.3 1997/02/24 10:18:47 jfasch Exp $" ;

TIOINETResponse :: TIOINETResponse (const TIOINETRequest* req,
                                    const TransparentIOPtr& io, 
                                    const TIOINETAttributes& a) 
: io_(io),
  attr_(a),
  error_(TIOINETFactory::TIFOK),
  request_(req) {} 

TIOINETResponse :: TIOINETResponse (const TIOINETRequest* req, TIOINETFactory::Error e) 
: error_(e),
  request_(req) {}

// --------------------------------------------------------------------
const char* TIOINETFactory :: version1 = "TIOINETFactory: $Id: tif.C,v 1.3 1997/02/24 10:18:47 jfasch Exp $" ;

void TIOINETFactory :: set_worker_(const TIOINETRequestPtr& r) {
   hgassert (r, "TIOINETFactory::set_worker_(): nil request") ;
   r.ptr()->set_worker_(this) ;
}

