// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tiorpcbuf.h
// 
// Purpose:     
// 
// Created:     20 Feb 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: a copy of rpcbuf.h
// 
// $Id: tiorpcbuf.h,v 1.1 1997/02/20 19:32:25 jfasch Exp $
// 
// $Log: tiorpcbuf.h,v $
// Revision 1.1  1997/02/20 19:32:25  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tiorpcbuf_h
#define hg_dispatch_tiorpcbuf_h

#include "libdispatch.h"

#include "iostreamb.h"
#include "tio.h"

#include <hyperg/utils/verbose.h>

class TIOrpcbuf : public streambuf {
public:
   static Verbose verbose ;

public:
   TIOrpcbuf(iostreamb* = nil);
   virtual ~TIOrpcbuf();

   const TransparentIOPtr& tio() const { return tio_; }

   TIOrpcbuf* attach (const TransparentIOPtr&) ;
   TIOrpcbuf* close() ;

   int start_request();
   int read_request();

   virtual int overflow(int c = EOF);
   virtual int underflow();
#ifdef WIN32
   int readon();
#endif
   virtual int sync();
#if defined(cplusplus_2_1) || defined(WIN32)
   virtual streampos seekoff(streamoff, ios::seek_dir, int);
#else
   virtual streampos seekoff(streamoff, seek_dir, int);
#endif
   virtual streambuf* setbuf(char*, int);
protected:
   virtual int doallocate();
   void finish_request();
   boolean expand_g(int);
   boolean expand_p();
   void error(const char*);
   iostreamb& mystream();
   char* rptr();
   void setr(char*);
   void rbump(int);
protected:
   iostreamb* _mystream;	// reference to the stream that uses me
   char* _rptr;		// beginning of outgoing RPC request
   int _actualWidth;		// width of outgoing RPC request's length field
   TransparentIOPtr tio_ ;

public:
   // link time assertion
   static const char* version1 ;
};
static const char* TIOrpcbuf_version = TIOrpcbuf::version1 ;

// Get the stream which will format the length field of RPC requests.

inline iostreamb& TIOrpcbuf::mystream() {
    return *_mystream;
}

// Get and set the pointer to the outgoing RPC request's beginning.

inline char* TIOrpcbuf::rptr() {
    return _rptr;
}

inline void TIOrpcbuf::setr(char* rptr) {
    _rptr = rptr;
}

inline void TIOrpcbuf::rbump(int n) {
    _rptr += n;
}

#endif
