// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1995
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        timeval.h
// 
// Purpose:     
// 
// Created:     13 Mar 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: timeval.h,v 1.3 1997/02/12 20:16:11 jfasch Exp $
// 
// $Log: timeval.h,v $
// Revision 1.3  1997/02/12 20:16:11  jfasch
// moved to utils
//
// Revision 1.2  1997/01/30 12:59:42  gorasche
// include for bool
//
// Revision 1.1  1996/03/22 16:23:11  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_utils_timeval_h
#define hg_utils_timeval_h

#include <sys/time.h>

#ifdef WIN32
// include for bool type
#  include "types.h"
#endif

class TimeVal : public timeval {
public:
   TimeVal() { tv_sec = 0; tv_usec = 0; }
   TimeVal (long sec, long usec) { tv_sec = sec; tv_usec = usec; }
   TimeVal (timeval t) { tv_sec = t.tv_sec; tv_usec = t.tv_usec; }

   long sec() const { return tv_sec; }
   long usec() const { return tv_usec; }
   double secs() const { return tv_sec + (double)tv_usec / (double)one_second; }

   bool operator < (const TimeVal&) const ;
   bool operator == (const TimeVal&) const ;
   bool operator > (const TimeVal&) const ;

   static TimeVal now() ;

   enum { one_second = 1000000 } ;
} ;

TimeVal operator + (const TimeVal&, const TimeVal&) ;
TimeVal operator - (const TimeVal&, const TimeVal&) ;


#endif
