/*
 * Copyright (C) 1992 by Software Research Associates, Inc.
 *      Author: Y. Kawabe <kawabe@sra.co.jp>
 *
 * Permission to use, copy, modify, and distribute, and sell this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Software Research Associates
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * This header file is based on
 *
 *		    Xlib - C Language X Interface
 *		       X Version 11, Release 5
 *		    First Revision - August, 1991
 *
 *				and
 *
 *     Protocol Specification for the Distributed Input System
 *		on the X Window System, Version 11
 *		Revision 3.5 - 20 September, 1991
 *
 */

#if !defined(XlibSpecificationRelease) || (XlibSpecificationRelease < 5)

typedef unsigned long XIMStyle;

#define	XIMPreeditArea		0x0001L
#define XIMPreeditCallbacks	0x0002L
#define XIMPreeditPosition	0x0004L
#define XIMPreeditNothing	0x0008L
#define XIMPreeditNone		0x0010L
#define XIMStatusArea		0x0100L
#define XIMStatusCallbacks	0x0200L
#define XIMStatusNothing	0x0400L
#define XIMStatusNone		0x0800L

#endif

/*
 * Ximp Protocol Version
 */

const char* XIMP_PROTOCOL_VERSION	= "XIMP.3.5";

/*
 * Basename of Ximp input language
 *
 *   Basic Declaration of Input
 *	_XIMP_<localename>
 *   Detailed Declaration of Input
 *	_XIMP_<localename>@<servername>.<screen>
 *
 */

const char* _XIMP_BASE			= "_XIMP_";

/*
 * Input Context ID
 */

typedef unsigned long	ICID;

/*
 * Request from the client to the IMS
 */

enum XimpRequest {
    XIMP_KEYPRESS		= 1,	/* Forward KeyEvent */
    XIMP_CREATE			= 2,	/* Open Connection Request */
    XIMP_DESTROY		= 3,	/* Close Connection Request */
    XIMP_BEGIN			= 4,	/* Begin Process Request */
    XIMP_END			= 5,	/* End Process Request */
    XIMP_SETFOCUS		= 6,	/* Focus Window Request */
    XIMP_UNSETFOCUS		= 7,	/* UnFocus Window Request */
    XIMP_MOVE			= 9,	/* Move Preedit Window Request */
    XIMP_RESET			= 10,	/* Rest IMS Request */
    XIMP_SETVALUE		= 11,	/* Set Value Request */
    XIMP_GETVALUE		= 12,	/* Get Value Request */
};

/*
 * Reply from the IMS to the client
 */

enum XimpReply {
    XIMP_KEYPRESSED		= 1,	/* Forward KeyEvent */
    XIMP_CREATE_RETURN	 	= 2,	/* Return ICID */
    XIMP_PROCESS_BEGIN		= 30,	/* Begin Process Notify */
    XIMP_PROCESS_END		= 31,	/* End Process Nodify */
    XIMP_READPROP	        = 32,	/* Return Converted String */
    XIMP_GETVALUE_RETURN	= 33,	/* Return Attributes */
    XIMP_RESET_RETURN		= 34,	/* Reset IMS return */
    XIMP_ERROR			= 99,	/* Error Notify */
};

/*
 * Error Number
 */

enum XimpError {
    XIMP_NoError		= 0,	/* No error */
    XIMP_BadAlloc		= 1,	/* memeory alloc fail */
    XIMP_BadStyle         	= 2,	/* unspported input style */
    XIMP_BadClientWindow        = 3,	/* invalid client window */
    XIMP_BadFocusWindow		= 4,	/* invalid focus window */
    XIMP_BadArea		= 5,	/* invalid area */
    XIMP_BadSpotLocation	= 6,	/* spot location out of range */
    XIMP_BadColormap		= 7,	/* invalid colormap id */
    XIMP_BadAtom		= 8,	/* invalid atom id */
    XIMP_BadPixel		= 9,	/* invalid pixel value */
    XIMP_BadPixmap		= 10,	/* invalid pixmap value */
    XIMP_BadName		= 11,	/* invalid font name */
    XIMP_BadCursor		= 12,	/* invalid cursor id */
    XIMP_BadProtocol		= 13,	/* invalid protocol */
    XIMP_BadProperty		= 14,	/* invalid property */
    XIMP_BadPropertyType	= 15,	/* invalid property type */
};

/*
 * Mask Value
 */

#define XIMP_FOCUS_WIN_MASK		(1L <<  0)
#define XIMP_PRE_AREA_MASK		(1L <<  1)
#define XIMP_PRE_FG_MASK		(1L <<  2)
#define XIMP_PRE_BG_MASK		(1L <<  3)
#define XIMP_PRE_COLORMAP_MASK		(1L <<  4)
#define XIMP_PRE_BGPIXMAP_MASK		(1L <<  5)
#define XIMP_PRE_LINESP_MASK		(1L <<  6)
#define XIMP_PRE_CURSOR_MASK		(1L <<  7)
#define XIMP_PRE_AREANEED_MASK		(1L <<  8)
#define XIMP_PRE_SPOTL_MASK		(1L <<  9)
#define XIMP_STS_AREA_MASK		(1L << 10)
#define XIMP_STS_FG_MASK		(1L << 11)
#define XIMP_STS_BG_MASK		(1L << 12)
#define XIMP_STS_COLORMAP_MASK		(1L << 13)
#define XIMP_STS_BGPIXMAP_MASK		(1L << 14)
#define XIMP_STS_LINESP_MASK		(1L << 15)
#define XIMP_STS_CURSOR_MASK		(1L << 16)
#define XIMP_STS_AREANEED_MASK		(1L << 17)
#define XIMP_STS_WINDOW_MASK		(1L << 18)
#define XIMP_PRE_FONT_MASK		(1L << 19)
#define XIMP_STS_FONT_MASK		(1L << 20)

#define XIMP_PRE_MASK	\
    (XIMP_PRE_AREA_MASK | XIMP_PRE_FG_MASK | XIMP_PRE_BG_MASK | XIMP_PRE_COLORMAP_MASK | XIMP_PRE_BGPIXMAP_MASK | XIMP_PRE_LINESP_MASK | XIMP_PRE_CURSOR_MASK | XIMP_PRE_AREANEED_MASK | XIMP_PRE_SPOTL_MASK)

#define XIMP_STS_MASK	\
    (XIMP_STS_AREA_MASK | XIMP_STS_FG_MASK | XIMP_STS_BG_MASK | XIMP_STS_COLORMAP_MASK | XIMP_STS_BGPIXMAP_MASK | XIMP_STS_LINESP_MASK | XIMP_STS_CURSOR_MASK | XIMP_STS_AREANEED_MASK | XIMP_STS_WINDOW_MASK)

/*
 * _XIMP_STYLES property struct
 */

typedef struct {
    XIMStyle		style;
} Ximp_Style;

typedef struct {
    int			nitems;
    Ximp_Style		*styles;
} Ximp_Styles;

/*
 * _XIMP_KEYS property struct
 */

typedef struct {
    unsigned long	modifier;
    unsigned long	mask;
    KeySym		keysym;
} Ximp_Key;

typedef struct {
    int			nitems;
    Ximp_Key		*keys;
} Ximp_Keys;

/*
 * Area struct
 */

typedef struct {
    long		x;
    long		y;
    long		width;
    long		height;
} Ximp_Area;

/*
 * Color Pixel
 */

typedef unsigned long    Pixel;

/*
 * AreaNeeded struct
 */

typedef struct {
    long		width;
    long		height;
} Ximp_AreaNeeded;

/*
 * SpotLocation struct
 */

typedef struct {
    long		x;
    long		y;
} Ximp_SpotLocation;

/*
 * _XIMP_PREEDIT property struct
 */

typedef struct  {
    Ximp_Area		Area;
    Pixel		Foreground;
    Pixel		Background;
    XColormap		Colormap;
    Pixmap		Bg_Pixmap;
    long		LineSpacing;
    XCursor		Cursor;
    Ximp_AreaNeeded	AreaNeeded;
    Ximp_SpotLocation	SpotLocation;
} Ximp_Preedit;

/*
 * _XIMP_STATUS property struct
 */

typedef struct  {
    Ximp_Area		Area;
    Pixel		Foreground;
    Pixel		Background;
    XColormap		Colormap;
    Pixmap		Bg_Pixmap;
    long		LineSpacing;
    XCursor		Cursor;
    Ximp_AreaNeeded	AreaNeeded;
    XWindow		status_window;
} Ximp_Status;

